/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.libval;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.core.internal.JptCommonCoreMessages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibValUtil {
    public static IStatus validate(Iterable<IPath> libraryPaths, Set<String> classNames) {
        HashSet<String> classFileNames = new HashSet<String>();
        HashMap<String, String> classFileNameToClassName = new HashMap<String, String>();
        for (String className : classNames) {
            String classFileName = String.valueOf(className.replace('.', '/')) + ".class";
            classFileNames.add(classFileName);
            classFileNameToClassName.put(classFileName, className);
        }
        HashMap<String, Integer> classAppearanceCounts = new HashMap<String, Integer>();
        for (String string : classFileNames) {
            classAppearanceCounts.put(string, 0);
        }
        for (IPath iPath : libraryPaths) {
            File file = iPath.toFile();
            if (!file.exists()) continue;
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(file);
                    Enumeration<? extends ZipEntry> itr = zip.entries();
                    while (itr.hasMoreElements()) {
                        ZipEntry zipEntry = itr.nextElement();
                        String name = zipEntry.getName();
                        Integer count = (Integer)classAppearanceCounts.get(name);
                        if (count == null) continue;
                        classAppearanceCounts.put(name, count + 1);
                    }
                }
                catch (IOException iOException) {
                    if (zip == null) continue;
                    try {
                        zip.close();
                    }
                    catch (IOException iOException2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zip == null) continue;
            try {
                zip.close();
            }
            catch (IOException iOException) {}
        }
        for (Map.Entry entry : classAppearanceCounts.entrySet()) {
            int count = (Integer)entry.getValue();
            if (count != 0) continue;
            String classFileName = (String)entry.getKey();
            String className = (String)classFileNameToClassName.get(classFileName);
            String message = NLS.bind((String)JptCommonCoreMessages.USER_LIBRARY_VALIDATOR__CLASS_NOT_FOUND, (Object)className);
            return new Status(4, "org.eclipse.jst.common.project.facet.core", message);
        }
        return Status.OK_STATUS;
    }
}

