/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.Command;
import org.eclipse.jpt.common.utility.CommandExecutor;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public abstract class JDTAnnotatedElement
implements AnnotatedElement {
    private final String name;
    private final ICompilationUnit compilationUnit;
    private final CommandExecutor modifySharedDocumentCommandExecutor;
    private final AnnotationEditFormatter annotationEditFormatter;

    protected JDTAnnotatedElement(String name, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor) {
        this(name, compilationUnit, modifySharedDocumentCommandExecutor, DefaultAnnotationEditFormatter.instance());
    }

    protected JDTAnnotatedElement(String name, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor, AnnotationEditFormatter annotationEditFormatter) {
        this.name = name;
        this.compilationUnit = compilationUnit;
        this.modifySharedDocumentCommandExecutor = modifySharedDocumentCommandExecutor;
        this.annotationEditFormatter = annotationEditFormatter;
    }

    public String getName() {
        return this.name;
    }

    public abstract ModifiedDeclaration getModifiedDeclaration(CompilationUnit var1);

    public ModifiedDeclaration getModifiedDeclaration() {
        return this.getModifiedDeclaration(this.buildASTRoot());
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.name);
    }

    public void edit(AnnotatedElement.Editor editor) {
        try {
            this.edit_(editor);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void edit_(AnnotatedElement.Editor editor) throws JavaModelException, BadLocationException {
        ITextFileBuffer buffer;
        boolean createWorkingCopy;
        boolean bl = createWorkingCopy = !this.compilationUnit.isWorkingCopy();
        if (createWorkingCopy) {
            this.compilationUnit.becomeWorkingCopy(null);
        }
        boolean sharedDocument = (buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.compilationUnit.getResource().getFullPath(), LocationKind.NORMALIZE)) != null;
        IDocument doc = sharedDocument ? buffer.getDocument() : new Document(this.compilationUnit.getBuffer().getContents());
        try {
            CompilationUnit astRoot = this.buildASTRoot();
            astRoot.recordModifications();
            editor.edit(this.getModifiedDeclaration(astRoot));
            TextEdit edits = astRoot.rewrite(doc, this.compilationUnit.getJavaProject().getOptions(true));
            if (sharedDocument) {
                this.modifySharedDocumentCommandExecutor.execute((Command)new ModifySharedDocumentCommand(edits, doc));
            } else {
                this.applyEdits(edits, doc);
            }
        }
        finally {
            if (createWorkingCopy) {
                this.compilationUnit.getBuffer().setContents(doc.get());
                this.compilationUnit.commitWorkingCopy(true, null);
                this.compilationUnit.discardWorkingCopy();
            }
        }
    }

    protected void applyEdits(TextEdit edits, IDocument doc) throws MalformedTreeException, BadLocationException {
        edits.apply(doc, 2);
        this.annotationEditFormatter.format(doc, edits);
    }

    protected CompilationUnit buildASTRoot() {
        return ASTTools.buildASTRoot(this.compilationUnit);
    }

    protected class ModifySharedDocumentCommand
    implements Command {
        private final TextEdit edits;
        private final IDocument doc;

        protected ModifySharedDocumentCommand(TextEdit edits, IDocument doc) {
            this.edits = edits;
            this.doc = doc;
        }

        public void execute() {
            try {
                JDTAnnotatedElement.this.applyEdits(this.edits, this.doc);
            }
            catch (MalformedTreeException ex) {
                throw new RuntimeException(ex);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

