/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.Messages;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations.AbstractTrinidadTransformOperation;
import org.eclipse.jst.jsf.apache.trinidad.tagsupport.converter.operations.CommandNavigationItemOperation;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationPaneOperation
extends AbstractTrinidadTransformOperation {
    private static final String STYLECLASS_OUTERDIV = "af_navigationPane";
    private static final String STYLECLASS_BAR_OUTERDIV = "af_navigationPane_bar";
    private static final String STYLECLASS_BAR_TABLE_INACTIVE_ENABLED = "af_navigationPane_bar-inactive-enabled";
    private static final String STYLECLASS_BAR_TABLE_ACTIVE_ENABLED = "af_navigationPane_bar-active-enabled";
    private static final String STYLECLASS_BAR_TABLE_INACTIVE_DISABLED = "af_navigationPane_bar-inactive-disabled";
    private static final String STYLECLASS_BAR_TABLE_ACTIVE_DISABLED = "af_navigationPane_bar-active-disabled";
    private static final String STYLECLASS_BAR_DIV_CONTENT = "af_navigationPane_bar-content";
    private static final String STYLECLASS_BAR_DIV_SEPARATOR = "af_navigationPane_bar-separator";
    private static final String STYLECLASS_BUTTONS_TABLE_INACTIVE_ENABLED = "af_navigationPane_buttons-inactive-enabled";
    private static final String STYLECLASS_BUTTONS_TABLE_ACTIVE_ENABLED = "af_navigationPane_buttons-active-enabled";
    private static final String STYLECLASS_BUTTONS_TABLE_INACTIVE_DISABLED = "af_navigationPane_buttons-inactive-disabled";
    private static final String STYLECLASS_BUTTONS_TABLE_ACTIVE_DISABLED = "af_navigationPane_buttons-active-disabled";
    private static final String STYLECLASS_BUTTONS_DIV_CONTENT = "af_navigationPane_buttons-content";
    private static final String STYLECLASS_BUTTONS_DIV_SEPARATOR = "af_navigationPane_buttons-separator";
    private static final String STYLECLASS_CHOICE_SELECT = "af_navigationPane_choice-options";
    private static final String STYLECLASS_CHOICE_BUTTON = "af_navigationPane_choice-button";
    private static final String STYLECLASS_LIST_TABLE_INACTIVE_ENABLED = "af_navigationPane_list-inactive-enabled";
    private static final String STYLECLASS_LIST_TABLE_ACTIVE_ENABLED = "af_navigationPane_list-active-enabled";
    private static final String STYLECLASS_LIST_TABLE_INACTIVE_DISABLED = "af_navigationPane_list-inactive-disabled";
    private static final String STYLECLASS_LIST_TABLE_ACTIVE_DISABLED = "af_navigationPane_list-active-disabled";
    private static final String STYLECLASS_LIST_TD_BULLET = "af_navigationPane_list-bullet";
    private static final String STYLECLASS_LIST_DIV_CONTENT = "af_navigationPane_list-content";
    private static final String STYLECLASS_TABS_TABLE_INACTIVE_ENABLED = "af_navigationPane_tabs-inactive";
    private static final String STYLECLASS_TABS_TABLE_ACTIVE_ENABLED = "af_navigationPane_tabs-active";
    private static final String STYLECLASS_TABS_TABLE_INACTIVE_DISABLED = "af_navigationPane_tabs-inactive p_AFDisabled";
    private static final String STYLECLASS_TABS_TABLE_ACTIVE_DISABLED = "af_navigationPane_tabs-active p_AFDisabled";
    private static final String STYLECLASS_TABS_TD_START = "af_navigationPane_tabs-start";
    private static final String STYLECLASS_TABS_TD_START_JOIN = "af_navigationPane_tabs-start-join";
    private static final String STYLECLASS_TABS_TD_START_JOINFROMACTIVE = "af_navigationPane_tabs-start-join-from-active";
    private static final String STYLECLASS_TABS_TD_START_JOINFROMINACTIVE = "af_navigationPane_tabs-start-join-from-inactive";
    private static final String STYLECLASS_TABS_TD_BOTTOM_START = "af_navigationPane_tabs-bottom-start";
    private static final String STYLECLASS_TABS_TD_MID = "af_navigationPane_tabs-mid";
    private static final String STYLECLASS_TABS_TD_BOTTOM_MID = "af_navigationPane_tabs-bottom-mid";
    private static final String STYLECLASS_TABS_TD_END = "af_navigationPane_tabs-end";
    private static final String STYLECLASS_TABS_TD_END_JOINTOINACTIVE = "af_navigationPane_tabs-end-join-to-inactive";
    private static final String STYLECLASS_TABS_TD_BOTTOM_END = "af_navigationPane_tabs-bottom-end";
    private static final String STYLECLASS_TABS_TD_BOTTOM_END_JOIN = "af_navigationPane_tabs-bottom-end-join";
    private static final String STYLECLASS_TABS_DIV_BOTTOM_START_CONTENT = "af_navigationPane_tabs-bottom-start-content";
    private static final String STYLECLASS_TABS_DIV_BOTTOM_MID_CONTENT = "af_navigationPane_tabs-bottom-mid-content";
    private static final String STYLECLASS_TABS_DIV_BOTTOM_END_CONTENT = "af_navigationPane_tabs-bottom-end-content";

    public Element transform(Element srcElement, Element curElement) {
        Element div = null;
        String hint = this.getHint(srcElement);
        div = hint.equalsIgnoreCase("bar") ? this.transformAsBar(srcElement) : (hint.equalsIgnoreCase("buttons") ? this.transformAsButtons(srcElement) : (hint.equalsIgnoreCase("choice") ? this.transformAsChoice(srcElement) : (hint.equalsIgnoreCase("list") ? this.transformAsList(srcElement) : (hint.equalsIgnoreCase("tabs") ? this.transformAsTabs(srcElement) : this.transformAsBar(srcElement)))));
        return div;
    }

    private Element transformAsBar(Element srcElement) {
        return this.transformAsBarOrButtons(srcElement, true);
    }

    private Element transformAsButtons(Element srcElement) {
        return this.transformAsBarOrButtons(srcElement, false);
    }

    private Element transformAsBarOrButtons(Element srcElement, boolean isBar) {
        String styleClass_divSeparator;
        String styleClass_divContent;
        String styleClass_tableActiveDisabled;
        String styleClass_tableInactiveDisabled;
        String styleClass_tableActiveEnabled;
        String styleClass_tableInactiveEnabled;
        String styleClass_outerDiv;
        Element div = null;
        if (isBar) {
            styleClass_outerDiv = STYLECLASS_BAR_OUTERDIV;
            styleClass_tableInactiveEnabled = STYLECLASS_BAR_TABLE_INACTIVE_ENABLED;
            styleClass_tableActiveEnabled = STYLECLASS_BAR_TABLE_ACTIVE_ENABLED;
            styleClass_tableInactiveDisabled = STYLECLASS_BAR_TABLE_INACTIVE_DISABLED;
            styleClass_tableActiveDisabled = STYLECLASS_BAR_TABLE_ACTIVE_DISABLED;
            styleClass_divContent = STYLECLASS_BAR_DIV_CONTENT;
            styleClass_divSeparator = STYLECLASS_BAR_DIV_SEPARATOR;
        } else {
            styleClass_outerDiv = STYLECLASS_OUTERDIV;
            styleClass_tableInactiveEnabled = STYLECLASS_BUTTONS_TABLE_INACTIVE_ENABLED;
            styleClass_tableActiveEnabled = STYLECLASS_BUTTONS_TABLE_ACTIVE_ENABLED;
            styleClass_tableInactiveDisabled = STYLECLASS_BUTTONS_TABLE_INACTIVE_DISABLED;
            styleClass_tableActiveDisabled = STYLECLASS_BUTTONS_TABLE_ACTIVE_DISABLED;
            styleClass_divContent = STYLECLASS_BUTTONS_DIV_CONTENT;
            styleClass_divSeparator = STYLECLASS_BUTTONS_DIV_SEPARATOR;
        }
        div = this.createElement("div");
        this.setClassAndStyleAttributes(srcElement, styleClass_outerDiv, div);
        List<Element> childCmdNavItems = this.getChildCmdNavItems(srcElement);
        int index = 0;
        int numChildCmdNavItems = childCmdNavItems.size();
        if (numChildCmdNavItems > 0) {
            for (Element childCmdNavItem : childCmdNavItems) {
                String styleClass = this.determineStyleClass(childCmdNavItem, styleClass_tableActiveEnabled, styleClass_tableActiveDisabled, styleClass_tableInactiveEnabled, styleClass_tableInactiveDisabled);
                Element tbody = this.appendTableAndTBody(div, true, styleClass);
                Element tr = this.appendChildElement("tr", tbody);
                Element contentTD = this.appendChildElement("td", tr);
                Element contentDiv = this.appendChildElement("div", contentTD);
                this.appendAttribute(contentDiv, "class", styleClass_divContent);
                this.tagConverterContext.addChild((Node)childCmdNavItem, new ConvertPosition((Node)contentDiv, 0));
                if (index++ >= numChildCmdNavItems - 1) continue;
                Element separatorTD = this.appendChildElement("td", tr);
                Element separatorDiv = this.appendChildElement("div", separatorTD);
                this.appendAttribute(separatorDiv, "class", styleClass_divSeparator);
                this.appendChildText("|", separatorDiv);
            }
        } else {
            this.setEmptyNavPaneMessage(div);
        }
        return div;
    }

    private Element transformAsChoice(Element srcElement) {
        Element div = null;
        div = this.createElement("div");
        this.setClassAndStyleAttributes(srcElement, STYLECLASS_OUTERDIV, div);
        List<Element> childCmdNavItems = this.getChildCmdNavItems(srcElement);
        if (childCmdNavItems.size() > 0) {
            Element select = this.appendChildElement("select", div);
            this.appendAttribute(select, "class", STYLECLASS_CHOICE_SELECT);
            for (Element childCmdNavItem : childCmdNavItems) {
                if (CommandNavigationItemOperation.isDisabled(childCmdNavItem)) continue;
                Element option = this.appendChildElement("option", select);
                if (CommandNavigationItemOperation.isSelected(childCmdNavItem)) {
                    this.appendAttribute(option, "selected", "selected");
                }
                this.appendChildText(CommandNavigationItemOperation.getText(childCmdNavItem), option);
            }
            Element span = this.appendChildElement("span", div);
            this.appendAttribute(span, "style", "width: 5px;");
            this.appendChildText(" ", span);
            Element button = this.appendChildElement("button", div);
            this.appendAttribute(button, "class", STYLECLASS_CHOICE_BUTTON);
            this.appendAttribute(button, "type", "button");
            this.appendChildText("Go", button);
        } else {
            this.setEmptyNavPaneMessage(div);
        }
        return div;
    }

    private Element transformAsList(Element srcElement) {
        Element div = null;
        div = this.createElement("div");
        this.setClassAndStyleAttributes(srcElement, STYLECLASS_OUTERDIV, div);
        List<Element> childCmdNavItems = this.getChildCmdNavItems(srcElement);
        if (childCmdNavItems.size() > 0) {
            for (Element childCmdNavItem : childCmdNavItems) {
                String styleClass = this.determineStyleClass(childCmdNavItem, STYLECLASS_LIST_TABLE_ACTIVE_ENABLED, STYLECLASS_LIST_TABLE_ACTIVE_DISABLED, STYLECLASS_LIST_TABLE_INACTIVE_ENABLED, STYLECLASS_LIST_TABLE_INACTIVE_DISABLED);
                Element tbody = this.appendTableAndTBody(div, false, styleClass);
                Element tr = this.appendChildElement("tr", tbody);
                Element bulletTD = this.appendChildElement("td", tr);
                this.appendAttribute(bulletTD, "class", STYLECLASS_LIST_TD_BULLET);
                Element bulletDiv = this.appendChildElement("div", bulletTD);
                this.appendChildText(" ", bulletDiv);
                Element contentTD = this.appendChildElement("td", tr);
                Element contentDiv = this.appendChildElement("div", contentTD);
                this.appendAttribute(contentDiv, "class", STYLECLASS_LIST_DIV_CONTENT);
                this.tagConverterContext.addChild((Node)childCmdNavItem, new ConvertPosition((Node)contentDiv, 0));
            }
        } else {
            this.setEmptyNavPaneMessage(div);
        }
        return div;
    }

    private Element transformAsTabs(Element srcElement) {
        Element div = null;
        div = this.createElement("div");
        this.setClassAndStyleAttributes(srcElement, STYLECLASS_OUTERDIV, div);
        List<Element> childCmdNavItems = this.getChildCmdNavItems(srcElement);
        int index = 0;
        int numChildCmdNavItems = childCmdNavItems.size();
        int selectedTabIndex = this.determineSelectedTabIndex(childCmdNavItems);
        if (numChildCmdNavItems > 0) {
            for (Element childCmdNavItem : childCmdNavItems) {
                String tableStyleClass = this.determineStyleClass(childCmdNavItem, STYLECLASS_TABS_TABLE_ACTIVE_ENABLED, STYLECLASS_TABS_TABLE_ACTIVE_DISABLED, STYLECLASS_TABS_TABLE_INACTIVE_ENABLED, STYLECLASS_TABS_TABLE_INACTIVE_DISABLED);
                Element outerTBody = this.appendTableAndTBody(div, true, "");
                Element outerTR = this.appendChildElement("tr", outerTBody);
                Element outerTD = this.appendChildElement("td", outerTR);
                Element innerTBody = this.appendTableAndTBody(outerTD, false, tableStyleClass);
                this.appendStartColumn(innerTBody, index, selectedTabIndex);
                outerTD = this.appendChildElement("td", outerTR);
                innerTBody = this.appendTableAndTBody(outerTD, false, tableStyleClass);
                this.appendMidColumn(innerTBody, childCmdNavItem);
                if (index + 1 != selectedTabIndex) {
                    outerTD = this.appendChildElement("td", outerTR);
                    innerTBody = this.appendTableAndTBody(outerTD, false, tableStyleClass);
                    this.appendEndColumn(innerTBody, index, numChildCmdNavItems);
                }
                ++index;
            }
        } else {
            this.setEmptyNavPaneMessage(div);
        }
        return div;
    }

    private List<Element> getChildCmdNavItems(Element srcElement) {
        ArrayList<Element> childCmdNavItems;
        block3: {
            NodeList childElements;
            block2: {
                childCmdNavItems = new ArrayList<Element>();
                childElements = srcElement.getElementsByTagNameNS("http://myfaces.apache.org/trinidad", "commandNavigationItem");
                if (childElements == null || childElements.getLength() <= 0) break block2;
                int i = 0;
                int len = childElements.getLength();
                while (i < len) {
                    childCmdNavItems.add((Element)childElements.item(i));
                    ++i;
                }
                break block3;
            }
            Element nodeStampFacet = this.getChildFacetByName(srcElement, "nodeStamp");
            if (nodeStampFacet == null || (childElements = nodeStampFacet.getElementsByTagNameNS("http://myfaces.apache.org/trinidad", "commandNavigationItem")) == null || childElements.getLength() <= 0) break block3;
            int i = 0;
            int len = childElements.getLength();
            while (i < len) {
                childCmdNavItems.add((Element)childElements.item(i));
                ++i;
            }
        }
        return childCmdNavItems;
    }

    private String getHint(Element srcElement) {
        String hint = srcElement.getAttribute("hint");
        return hint != null ? hint : "bar";
    }

    private void setClassAndStyleAttributes(Element srcElement, String baseStyleClass, Element curElement) {
        String style;
        String styleClass = this.calculateStyleClass(baseStyleClass, srcElement);
        if (styleClass != null) {
            this.appendAttribute(curElement, "class", styleClass);
        }
        if ((style = srcElement.getAttribute("inlineStyle")) != null) {
            this.appendAttribute(curElement, "style", style);
        }
    }

    private void setEmptyNavPaneMessage(Element curElement) {
        this.appendAttribute(curElement, "style", "color:silver;font-family:Arial,Helvetica,Geneva,sans-serif;font-size:8pt;");
        this.appendChildText(Messages.NavigationPaneOperation_EmptyNavigationPaneTag, curElement);
    }

    private Element appendTableAndTBody(Element parentElement, boolean isInline, String styleClass) {
        Element table = this.appendChildElement("table", parentElement);
        this.appendAttribute(table, "cellpadding", "0");
        this.appendAttribute(table, "cellspacing", "0");
        this.appendAttribute(table, "border", "0");
        if (isInline) {
            this.appendAttribute(table, "style", "display: inline;");
        }
        this.appendAttribute(table, "class", styleClass);
        Element tbody = this.appendChildElement("tbody", table);
        return tbody;
    }

    private String determineStyleClass(Element cmdNavItem, String styleClass_ActiveEnabled, String styleClass_ActiveDisabled, String styleClass_InactiveEnabled, String styleClass_InactiveDisabled) {
        String styleClass = CommandNavigationItemOperation.isSelected(cmdNavItem) ? (!CommandNavigationItemOperation.isDisabled(cmdNavItem) ? styleClass_ActiveEnabled : styleClass_ActiveDisabled) : (!CommandNavigationItemOperation.isDisabled(cmdNavItem) ? styleClass_InactiveEnabled : styleClass_InactiveDisabled);
        return styleClass;
    }

    private int determineSelectedTabIndex(List<Element> childCmdNavItems) {
        int selectedTabIndex = -2;
        int curTabIndex = 0;
        for (Element childCmdNavItem : childCmdNavItems) {
            if (CommandNavigationItemOperation.isSelected(childCmdNavItem)) {
                selectedTabIndex = curTabIndex;
                break;
            }
            ++curTabIndex;
        }
        return selectedTabIndex;
    }

    private void appendStartColumn(Element parentTBody, int curTabIndex, int selectedTabIndex) {
        String divStyleClass;
        String bottomTDStyleClass;
        String topTDStyleClass;
        if (curTabIndex == 0) {
            topTDStyleClass = STYLECLASS_TABS_TD_START;
            bottomTDStyleClass = STYLECLASS_TABS_TD_BOTTOM_START;
            divStyleClass = STYLECLASS_TABS_DIV_BOTTOM_START_CONTENT;
        } else if (curTabIndex == selectedTabIndex) {
            topTDStyleClass = STYLECLASS_TABS_TD_START_JOIN;
            bottomTDStyleClass = STYLECLASS_TABS_TD_BOTTOM_START;
            divStyleClass = STYLECLASS_TABS_DIV_BOTTOM_START_CONTENT;
        } else {
            topTDStyleClass = curTabIndex == selectedTabIndex + 1 ? STYLECLASS_TABS_TD_START_JOINFROMACTIVE : STYLECLASS_TABS_TD_START_JOINFROMINACTIVE;
            bottomTDStyleClass = STYLECLASS_TABS_TD_BOTTOM_END;
            divStyleClass = STYLECLASS_TABS_DIV_BOTTOM_MID_CONTENT;
        }
        Element topTR = this.appendChildElement("tr", parentTBody);
        Element topTD = this.appendChildElement("td", topTR);
        this.appendAttribute(topTD, "class", topTDStyleClass);
        Element bottomTR = this.appendChildElement("tr", parentTBody);
        Element bottomTD = this.appendChildElement("td", bottomTR);
        this.appendAttribute(bottomTD, "class", bottomTDStyleClass);
        Element div = this.appendChildElement("div", bottomTD);
        this.appendAttribute(div, "class", divStyleClass);
    }

    private void appendMidColumn(Element parentTBody, Element cmdNavItem) {
        Element topTR = this.appendChildElement("tr", parentTBody);
        Element topTD = this.appendChildElement("td", topTR);
        this.appendAttribute(topTD, "class", STYLECLASS_TABS_TD_MID);
        this.tagConverterContext.addChild((Node)cmdNavItem, new ConvertPosition((Node)topTD, 0));
        Element bottomTR = this.appendChildElement("tr", parentTBody);
        Element bottomTD = this.appendChildElement("td", bottomTR);
        this.appendAttribute(bottomTD, "class", STYLECLASS_TABS_TD_BOTTOM_MID);
        Element div = this.appendChildElement("div", bottomTD);
        this.appendAttribute(div, "class", STYLECLASS_TABS_DIV_BOTTOM_MID_CONTENT);
    }

    private void appendEndColumn(Element parentTBody, int curTabIndex, int numTabs) {
        String bottomTDStyleClass;
        String topTDStyleClass;
        if (curTabIndex < numTabs - 1) {
            topTDStyleClass = STYLECLASS_TABS_TD_END_JOINTOINACTIVE;
            bottomTDStyleClass = STYLECLASS_TABS_TD_BOTTOM_END_JOIN;
        } else {
            topTDStyleClass = STYLECLASS_TABS_TD_END;
            bottomTDStyleClass = STYLECLASS_TABS_TD_BOTTOM_END;
        }
        Element topTR = this.appendChildElement("tr", parentTBody);
        Element topTD = this.appendChildElement("td", topTR);
        this.appendAttribute(topTD, "class", topTDStyleClass);
        Element bottomTR = this.appendChildElement("tr", parentTBody);
        Element bottomTD = this.appendChildElement("td", bottomTR);
        this.appendAttribute(bottomTD, "class", bottomTDStyleClass);
        Element div = this.appendChildElement("div", bottomTD);
        this.appendAttribute(div, "class", STYLECLASS_TABS_DIV_BOTTOM_END_CONTENT);
    }
}

