/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import org.eclipse.jpt.jpa.core.context.BaseColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.context.VirtualBaseColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaVirtualNamedColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaVirtualBaseColumn<O extends ReadOnlyNamedColumn.Owner, C extends BaseColumn>
extends AbstractJavaVirtualNamedColumn<O, C>
implements VirtualBaseColumn {
    protected String specifiedTable;
    protected String defaultTable;
    protected Boolean specifiedUnique;
    protected boolean defaultUnique;
    protected Boolean specifiedNullable;
    protected boolean defaultNullable;
    protected Boolean specifiedInsertable;
    protected boolean defaultInsertable;
    protected Boolean specifiedUpdatable;
    protected boolean defaultUpdatable;

    protected AbstractJavaVirtualBaseColumn(JavaJpaContextNode parent, O owner) {
        super(parent, owner);
    }

    @Override
    public void update() {
        super.update();
        this.setSpecifiedTable(this.buildSpecifiedTable());
        this.setDefaultTable(this.buildDefaultTable());
        this.setSpecifiedUnique(this.buildSpecifiedUnique());
        this.setDefaultUnique(this.buildDefaultUnique());
        this.setSpecifiedNullable(this.buildSpecifiedNullable());
        this.setDefaultNullable(this.buildDefaultNullable());
        this.setSpecifiedInsertable(this.buildSpecifiedInsertable());
        this.setDefaultInsertable(this.buildDefaultInsertable());
        this.setSpecifiedUpdatable(this.buildSpecifiedUpdatable());
        this.setDefaultUpdatable(this.buildDefaultUpdatable());
    }

    @Override
    public String getTable() {
        return this.specifiedTable != null ? this.specifiedTable : this.defaultTable;
    }

    @Override
    public String getSpecifiedTable() {
        return this.specifiedTable;
    }

    protected void setSpecifiedTable(String table) {
        String old = this.specifiedTable;
        this.specifiedTable = table;
        this.firePropertyChanged("specifiedTable", old, table);
    }

    protected String buildSpecifiedTable() {
        return ((BaseColumn)this.getOverriddenColumn()).getSpecifiedTable();
    }

    @Override
    public String getDefaultTable() {
        return this.defaultTable;
    }

    protected void setDefaultTable(String table) {
        String old = this.defaultTable;
        this.defaultTable = table;
        this.firePropertyChanged("defaultTable", old, table);
    }

    protected String buildDefaultTable() {
        return this.owner.getDefaultTableName();
    }

    @Override
    public boolean isUnique() {
        return this.specifiedUnique != null ? this.specifiedUnique.booleanValue() : this.isDefaultUnique();
    }

    @Override
    public Boolean getSpecifiedUnique() {
        return this.specifiedUnique;
    }

    protected void setSpecifiedUnique(Boolean unique) {
        Boolean old = this.specifiedUnique;
        this.specifiedUnique = unique;
        this.firePropertyChanged("specifiedUnique", old, unique);
    }

    protected Boolean buildSpecifiedUnique() {
        return ((BaseColumn)this.getOverriddenColumn()).getSpecifiedUnique();
    }

    @Override
    public boolean isDefaultUnique() {
        return this.defaultUnique;
    }

    protected void setDefaultUnique(boolean unique) {
        boolean old = this.defaultUnique;
        this.defaultUnique = unique;
        this.firePropertyChanged("defaultUnique", old, unique);
    }

    protected boolean buildDefaultUnique() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return this.specifiedNullable != null ? this.specifiedNullable.booleanValue() : this.isDefaultNullable();
    }

    @Override
    public Boolean getSpecifiedNullable() {
        return this.specifiedNullable;
    }

    protected void setSpecifiedNullable(Boolean nullable) {
        Boolean old = this.specifiedNullable;
        this.specifiedNullable = nullable;
        this.firePropertyChanged("specifiedNullable", old, nullable);
    }

    protected Boolean buildSpecifiedNullable() {
        return ((BaseColumn)this.getOverriddenColumn()).getSpecifiedNullable();
    }

    @Override
    public boolean isDefaultNullable() {
        return this.defaultNullable;
    }

    protected void setDefaultNullable(boolean nullable) {
        boolean old = this.defaultNullable;
        this.defaultNullable = nullable;
        this.firePropertyChanged("defaultNullable", old, nullable);
    }

    protected boolean buildDefaultNullable() {
        return true;
    }

    @Override
    public boolean isInsertable() {
        return this.specifiedInsertable != null ? this.specifiedInsertable.booleanValue() : this.isDefaultInsertable();
    }

    @Override
    public Boolean getSpecifiedInsertable() {
        return this.specifiedInsertable;
    }

    protected void setSpecifiedInsertable(Boolean insertable) {
        Boolean old = this.specifiedInsertable;
        this.specifiedInsertable = insertable;
        this.firePropertyChanged("specifiedInsertable", old, insertable);
    }

    protected Boolean buildSpecifiedInsertable() {
        return ((BaseColumn)this.getOverriddenColumn()).getSpecifiedInsertable();
    }

    @Override
    public boolean isDefaultInsertable() {
        return this.defaultInsertable;
    }

    protected void setDefaultInsertable(boolean insertable) {
        boolean old = this.defaultInsertable;
        this.defaultInsertable = insertable;
        this.firePropertyChanged("defaultInsertable", old, insertable);
    }

    protected boolean buildDefaultInsertable() {
        return true;
    }

    @Override
    public boolean isUpdatable() {
        return this.specifiedUpdatable != null ? this.specifiedUpdatable.booleanValue() : this.isDefaultUpdatable();
    }

    @Override
    public Boolean getSpecifiedUpdatable() {
        return this.specifiedUpdatable;
    }

    protected void setSpecifiedUpdatable(Boolean updatable) {
        Boolean old = this.specifiedUpdatable;
        this.specifiedUpdatable = updatable;
        this.firePropertyChanged("specifiedUpdatable", old, updatable);
    }

    protected Boolean buildSpecifiedUpdatable() {
        return ((BaseColumn)this.getOverriddenColumn()).getSpecifiedUpdatable();
    }

    @Override
    public boolean isDefaultUpdatable() {
        return this.defaultUpdatable;
    }

    protected void setDefaultUpdatable(boolean updatable) {
        boolean old = this.defaultUpdatable;
        this.defaultUpdatable = updatable;
        this.firePropertyChanged("defaultUpdatable", old, updatable);
    }

    protected boolean buildDefaultUpdatable() {
        return true;
    }
}

