/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetDataModelProperties;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetDataModelProvider;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaFacetVersionChangeDataModelProvider
extends JpaFacetDataModelProvider
implements JpaFacetDataModelProperties {
    protected static final IStatus PLATFORM_DOES_NOT_SUPPORT_FACET_VERSION_STATUS = JpaFacetVersionChangeDataModelProvider.buildErrorStatus(JptCoreMessages.VALIDATE_PLATFORM_DOES_NOT_SUPPORT_FACET_VERSION);

    protected String getProjectName() {
        return this.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
    }

    protected JpaProject getJpaProject() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
        return JptJpaCorePlugin.getJpaProject(project);
    }

    @Override
    protected JpaPlatformDescription getDefaultPlatform() {
        return this.getJpaProject().getJpaPlatform().getDescription();
    }

    @Override
    protected String getDefaultConnection() {
        return this.getJpaProject().getDataSource().getConnectionProfileName();
    }

    @Override
    protected Boolean getDefaultUserWantsToOverrideDefaultCatalog() {
        if (this.getJpaProject().getUserOverrideDefaultCatalog() != null) {
            return true;
        }
        return false;
    }

    @Override
    protected String getDefaultCatalogIdentifier() {
        return this.getJpaProject().getUserOverrideDefaultCatalog();
    }

    @Override
    protected Boolean getDefaultUserWantsToOverrideDefaultSchema() {
        if (this.getJpaProject().getUserOverrideDefaultSchema() != null) {
            return true;
        }
        return false;
    }

    @Override
    protected String getDefaultSchemaIdentifier() {
        return this.getJpaProject().getDefaultSchema();
    }

    @Override
    protected Boolean getDefaultDiscoverAnnotatedClasses() {
        return this.getJpaProject().discoversAnnotatedClasses();
    }

    @Override
    protected Iterable<JpaPlatformDescription> buildValidPlatformDescriptions() {
        CompositeIterable validPlatformDescs = super.buildValidPlatformDescriptions();
        if (!CollectionTools.contains(validPlatformDescs, (Object)this.getDefaultPlatform())) {
            validPlatformDescs = new CompositeIterable((Object)this.getDefaultPlatform(), validPlatformDescs);
        }
        return validPlatformDescs;
    }

    @Override
    protected IStatus validatePlatform() {
        IStatus status = super.validatePlatform();
        if (status.isOK() && !this.getPlatform().supportsJpaFacetVersion(this.getProjectFacetVersion())) {
            status = PLATFORM_DOES_NOT_SUPPORT_FACET_VERSION_STATUS;
        }
        return status;
    }
}

