/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeMappingValidator<T extends TypeMapping>
implements JptValidator {
    protected T typeMapping;
    protected JavaResourcePersistentType jrpt;
    protected TypeMappingTextRangeResolver textRangeResolver;

    protected AbstractTypeMappingValidator(T typeMapping, JavaResourcePersistentType jrpt, TypeMappingTextRangeResolver textRangeResolver) {
        this.typeMapping = typeMapping;
        this.jrpt = jrpt;
        this.textRangeResolver = textRangeResolver;
    }

    @Override
    public boolean validate(List<IMessage> messages, IReporter reporter) {
        this.validateType(messages);
        return true;
    }

    protected abstract void validateType(List<IMessage> var1);

    protected boolean isMemberType() {
        if (this.jrpt == null) {
            return false;
        }
        return this.jrpt.isMemberType();
    }

    protected boolean isStaticType() {
        if (this.jrpt == null) {
            return false;
        }
        return this.jrpt.isStatic();
    }

    protected boolean isFinalType() {
        if (this.jrpt == null) {
            return false;
        }
        return this.jrpt.isFinal();
    }

    protected boolean hasPrivateNoArgConstructor() {
        if (this.jrpt == null) {
            return false;
        }
        return this.jrpt.hasPrivateNoArgConstructor();
    }

    protected boolean hasNoArgConstructor() {
        if (this.jrpt == null) {
            return false;
        }
        return this.jrpt.hasNoArgConstructor();
    }

    protected IMessage buildTypeMessage(String msgID) {
        return DefaultJpaValidationMessages.buildMessage(1, msgID, new String[]{this.typeMapping.getName()}, this.typeMapping, this.textRangeResolver.getTypeMappingTextRange());
    }
}

