/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.NamedColumn;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTable;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.JoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaReferenceTable;
import org.eclipse.jpt.jpa.core.internal.resource.java.NullJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaJoinTable
extends GenericJavaReferenceTable<JoinTableAnnotation>
implements JavaJoinTable {
    protected final Vector<JavaJoinColumn> specifiedInverseJoinColumns = new Vector();
    protected final SpecifiedInverseJoinColumnContainerAdapter specifiedInverseJoinColumnContainerAdapter = new SpecifiedInverseJoinColumnContainerAdapter();
    protected final JavaJoinColumn.Owner inverseJoinColumnOwner = this.buildInverseJoinColumnOwner();
    protected JavaJoinColumn defaultInverseJoinColumn;

    public GenericJavaJoinTable(JavaJoinTableRelationshipStrategy parent, Table.Owner owner) {
        super(parent, owner);
        this.initializeSpecifiedInverseJoinColumns();
    }

    @Override
    protected JavaJoinColumn.Owner buildJoinColumnOwner() {
        return new JoinColumnOwner();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedInverseJoinColumns();
        if (this.defaultInverseJoinColumn != null) {
            this.defaultInverseJoinColumn.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedInverseJoinColumns());
        this.updateDefaultInverseJoinColumn();
    }

    @Override
    public JoinTableAnnotation getTableAnnotation() {
        return this.getRelationshipStrategy().getJoinTableAnnotation();
    }

    @Override
    protected void removeTableAnnotation() {
    }

    @Override
    public ListIterator<JavaJoinColumn> inverseJoinColumns() {
        return this.getInverseJoinColumns().iterator();
    }

    protected ListIterable<JavaJoinColumn> getInverseJoinColumns() {
        return this.hasSpecifiedInverseJoinColumns() ? this.getSpecifiedInverseJoinColumns() : this.getDefaultInverseJoinColumns();
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.hasSpecifiedInverseJoinColumns() ? this.specifiedInverseJoinColumnsSize() : this.defaultInverseJoinColumnsSize();
    }

    @Override
    public void convertDefaultToSpecifiedInverseJoinColumn() {
        MappingTools.convertJoinTableDefaultToSpecifiedInverseJoinColumn(this);
    }

    @Override
    public ListIterator<JavaJoinColumn> specifiedInverseJoinColumns() {
        return this.getSpecifiedInverseJoinColumns().iterator();
    }

    public ListIterable<JavaJoinColumn> getSpecifiedInverseJoinColumns() {
        return new LiveCloneListIterable(this.specifiedInverseJoinColumns);
    }

    @Override
    public int specifiedInverseJoinColumnsSize() {
        return this.specifiedInverseJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedInverseJoinColumns() {
        return this.specifiedInverseJoinColumns.size() != 0;
    }

    @Override
    public JavaJoinColumn getSpecifiedInverseJoinColumn(int index) {
        return this.specifiedInverseJoinColumns.get(index);
    }

    @Override
    public JavaJoinColumn addSpecifiedInverseJoinColumn() {
        return this.addSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.size());
    }

    @Override
    public JavaJoinColumn addSpecifiedInverseJoinColumn(int index) {
        JoinColumnAnnotation annotation = this.getTableAnnotation().addInverseJoinColumn(index);
        return this.addSpecifiedInverseJoinColumn_(index, annotation);
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedInverseJoinColumn(this.specifiedInverseJoinColumns.indexOf(joinColumn));
    }

    @Override
    public void removeSpecifiedInverseJoinColumn(int index) {
        this.getTableAnnotation().removeInverseJoinColumn(index);
        this.removeTableAnnotationIfUnset();
        this.removeSpecifiedInverseJoinColumn_(index);
    }

    protected void removeSpecifiedInverseJoinColumn_(int index) {
        this.removeItemFromList(index, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    @Override
    public void moveSpecifiedInverseJoinColumn(int targetIndex, int sourceIndex) {
        this.getTableAnnotation().moveInverseJoinColumn(targetIndex, sourceIndex);
        this.moveItemInList(targetIndex, sourceIndex, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    @Override
    public void clearSpecifiedInverseJoinColumns() {
        int i = this.specifiedInverseJoinColumns.size();
        while (i-- > 0) {
            this.removeSpecifiedInverseJoinColumn(i);
        }
    }

    protected void initializeSpecifiedInverseJoinColumns() {
        for (JoinColumnAnnotation joinColumnAnnotation : this.getInverseJoinColumnAnnotations()) {
            this.specifiedInverseJoinColumns.add(this.buildInverseJoinColumn(joinColumnAnnotation));
        }
    }

    protected void syncSpecifiedInverseJoinColumns() {
        ContextContainerTools.synchronizeWithResourceModel(this.specifiedInverseJoinColumnContainerAdapter);
    }

    protected Iterable<JoinColumnAnnotation> getInverseJoinColumnAnnotations() {
        return CollectionTools.iterable(this.getTableAnnotation().inverseJoinColumns());
    }

    protected void moveSpecifiedInverseJoinColumn_(int index, JavaJoinColumn joinColumn) {
        this.moveItemInList(index, joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
    }

    protected JavaJoinColumn addSpecifiedInverseJoinColumn_(int index, JoinColumnAnnotation joinColumnAnnotation) {
        JavaJoinColumn joinColumn = this.buildInverseJoinColumn(joinColumnAnnotation);
        this.addItemToList(index, joinColumn, this.specifiedInverseJoinColumns, "specifiedInverseJoinColumns");
        return joinColumn;
    }

    protected void removeSpecifiedInverseJoinColumn_(JavaJoinColumn joinColumn) {
        this.removeSpecifiedInverseJoinColumn_(this.specifiedInverseJoinColumns.indexOf(joinColumn));
    }

    protected JavaJoinColumn.Owner buildInverseJoinColumnOwner() {
        return new InverseJoinColumnOwner();
    }

    @Override
    public JavaJoinColumn getDefaultInverseJoinColumn() {
        return this.defaultInverseJoinColumn;
    }

    protected void setDefaultInverseJoinColumn(JavaJoinColumn joinColumn) {
        JavaJoinColumn old = this.defaultInverseJoinColumn;
        this.defaultInverseJoinColumn = joinColumn;
        this.firePropertyChanged("defaultInverseJoinColumn", old, joinColumn);
    }

    protected ListIterable<JavaJoinColumn> getDefaultInverseJoinColumns() {
        return this.defaultInverseJoinColumn != null ? new SingleElementListIterable((Object)this.defaultInverseJoinColumn) : EmptyListIterable.instance();
    }

    protected int defaultInverseJoinColumnsSize() {
        return this.defaultInverseJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultInverseJoinColumn() {
        if (this.buildsDefaultInverseJoinColumn()) {
            if (this.defaultInverseJoinColumn == null) {
                this.setDefaultInverseJoinColumn(this.buildInverseJoinColumn(new NullJoinColumnAnnotation(this.getTableAnnotation())));
            } else {
                this.defaultInverseJoinColumn.update();
            }
        } else {
            this.setDefaultInverseJoinColumn(null);
        }
    }

    protected boolean buildsDefaultInverseJoinColumn() {
        return !this.hasSpecifiedInverseJoinColumns();
    }

    @Override
    public JavaJoinTableRelationshipStrategy getParent() {
        return (JavaJoinTableRelationshipStrategy)super.getParent();
    }

    protected JavaJoinTableRelationshipStrategy getRelationshipStrategy() {
        return this.getParent();
    }

    @Override
    protected String buildDefaultName() {
        return this.getRelationshipStrategy().getJoinTableDefaultName();
    }

    @Override
    public void initializeFrom(ReadOnlyJoinTable oldTable) {
        super.initializeFrom(oldTable);
        for (ReadOnlyJoinColumn joinColumn : CollectionTools.iterable(oldTable.specifiedInverseJoinColumns())) {
            this.addSpecifiedInverseJoinColumn().initializeFrom(joinColumn);
        }
    }

    @Override
    public void initializeFromVirtual(ReadOnlyJoinTable virtualTable) {
        super.initializeFromVirtual(virtualTable);
        for (ReadOnlyJoinColumn joinColumn : CollectionTools.iterable(virtualTable.inverseJoinColumns())) {
            this.addSpecifiedInverseJoinColumn().initializeFromVirtual(joinColumn);
        }
    }

    protected JavaJoinColumn buildInverseJoinColumn(JoinColumnAnnotation joinColumnAnnotation) {
        return this.buildJoinColumn(this.inverseJoinColumnOwner, joinColumnAnnotation);
    }

    @Override
    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationshipStrategy().getRelationship().getMapping();
    }

    @Override
    public PersistentAttribute getPersistentAttribute() {
        return this.getRelationshipMapping().getPersistentAttribute();
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn column : CollectionTools.iterable(this.inverseJoinColumns())) {
            result = column.javaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validateJoinColumns(messages, reporter, astRoot);
        this.validateJoinColumns(this.inverseJoinColumns(), messages, reporter, astRoot);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getRelationshipStrategy().validatesAgainstDatabase();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class AbstractJoinColumnOwner
    implements JavaJoinColumn.Owner {
        protected AbstractJoinColumnOwner() {
        }

        @Override
        public TypeMapping getTypeMapping() {
            return GenericJavaJoinTable.this.getRelationshipStrategy().getRelationship().getTypeMapping();
        }

        public PersistentAttribute getPersistentAttribute() {
            return GenericJavaJoinTable.this.getPersistentAttribute();
        }

        @Override
        public String getDefaultColumnName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tableNameIsInvalid(String tableName) {
            return Tools.valuesAreDifferent((Object)this.getDefaultTableName(), (Object)tableName);
        }

        @Override
        public Iterator<String> candidateTableNames() {
            return EmptyIterator.instance();
        }

        @Override
        public Table resolveDbTable(String tableName) {
            return Tools.valuesAreEqual((Object)GenericJavaJoinTable.this.getName(), (Object)tableName) ? GenericJavaJoinTable.this.getDbTable() : null;
        }

        @Override
        public String getDefaultTableName() {
            return GenericJavaJoinTable.this.getName();
        }

        @Override
        public TextRange getValidationTextRange(CompilationUnit astRoot) {
            return GenericJavaJoinTable.this.getValidationTextRange(astRoot);
        }
    }

    protected class InverseJoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected InverseJoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            RelationshipMapping relationshipMapping = GenericJavaJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getResolvedTargetEntity();
        }

        public String getAttributeName() {
            RelationshipMapping relationshipMapping = GenericJavaJoinTable.this.getRelationshipMapping();
            return relationshipMapping == null ? null : relationshipMapping.getName();
        }

        public Table getReferencedColumnDbTable() {
            Entity relationshipTarget = this.getRelationshipTarget();
            return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
        }

        public boolean joinColumnIsDefault(ReadOnlyBaseJoinColumn joinColumn) {
            return GenericJavaJoinTable.this.defaultInverseJoinColumn == joinColumn;
        }

        public int joinColumnsSize() {
            return GenericJavaJoinTable.this.inverseJoinColumnsSize();
        }

        public JptValidator buildColumnValidator(NamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return GenericJavaJoinTable.this.getParent().buildJoinTableInverseJoinColumnValidator((JoinColumn)column, this, (JoinColumnTextRangeResolver)textRangeResolver);
        }
    }

    protected class JoinColumnOwner
    extends AbstractJoinColumnOwner {
        protected JoinColumnOwner() {
        }

        public Entity getRelationshipTarget() {
            return GenericJavaJoinTable.this.getRelationshipStrategy().getRelationship().getEntity();
        }

        public String getAttributeName() {
            return MappingTools.getTargetAttributeName(GenericJavaJoinTable.this.getRelationshipMapping());
        }

        public Table getReferencedColumnDbTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        public boolean joinColumnIsDefault(ReadOnlyBaseJoinColumn joinColumn) {
            return GenericJavaJoinTable.this.defaultJoinColumn == joinColumn;
        }

        public int joinColumnsSize() {
            return GenericJavaJoinTable.this.joinColumnsSize();
        }

        public JptValidator buildColumnValidator(NamedColumn column, NamedColumnTextRangeResolver textRangeResolver) {
            return GenericJavaJoinTable.this.getParent().buildJoinTableJoinColumnValidator((JoinColumn)column, this, (JoinColumnTextRangeResolver)textRangeResolver);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedInverseJoinColumnContainerAdapter
    implements ContextContainerTools.Adapter<JavaJoinColumn, JoinColumnAnnotation> {
        protected SpecifiedInverseJoinColumnContainerAdapter() {
        }

        @Override
        public Iterable<JavaJoinColumn> getContextElements() {
            return GenericJavaJoinTable.this.getSpecifiedInverseJoinColumns();
        }

        @Override
        public Iterable<JoinColumnAnnotation> getResourceElements() {
            return GenericJavaJoinTable.this.getInverseJoinColumnAnnotations();
        }

        @Override
        public JoinColumnAnnotation getResourceElement(JavaJoinColumn contextElement) {
            return contextElement.getColumnAnnotation();
        }

        @Override
        public void moveContextElement(int index, JavaJoinColumn element) {
            GenericJavaJoinTable.this.moveSpecifiedInverseJoinColumn_(index, element);
        }

        @Override
        public void addContextElement(int index, JoinColumnAnnotation resourceElement) {
            GenericJavaJoinTable.this.addSpecifiedInverseJoinColumn_(index, resourceElement);
        }

        @Override
        public void removeContextElement(JavaJoinColumn element) {
            GenericJavaJoinTable.this.removeSpecifiedInverseJoinColumn_(element);
        }
    }
}

