/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.jpa.core.context.java.JavaBaseJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaNamedColumn;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaPrimaryKeyJoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaPrimaryKeyJoinColumn
extends AbstractJavaNamedColumn<PrimaryKeyJoinColumnAnnotation, JavaBaseJoinColumn.Owner>
implements JavaPrimaryKeyJoinColumn {
    protected PrimaryKeyJoinColumnAnnotation columnAnnotation;
    protected String specifiedReferencedColumnName = this.buildSpecifiedReferencedColumnName();
    protected String defaultReferencedColumnName;

    public GenericJavaPrimaryKeyJoinColumn(JavaJpaContextNode parent, JavaBaseJoinColumn.Owner owner, PrimaryKeyJoinColumnAnnotation columnAnnotation) {
        super(parent, owner, columnAnnotation);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedReferencedColumnName_(this.buildSpecifiedReferencedColumnName());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultReferencedColumnName(this.buildDefaultReferencedColumnName());
    }

    @Override
    public PrimaryKeyJoinColumnAnnotation getColumnAnnotation() {
        return this.columnAnnotation;
    }

    @Override
    protected void setColumnAnnotation(PrimaryKeyJoinColumnAnnotation columnAnnotation) {
        this.columnAnnotation = columnAnnotation;
    }

    @Override
    protected void removeColumnAnnotation() {
    }

    @Override
    public String getReferencedColumnName() {
        return this.specifiedReferencedColumnName != null ? this.specifiedReferencedColumnName : this.defaultReferencedColumnName;
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String name) {
        if (this.valuesAreDifferent(this.specifiedReferencedColumnName, name)) {
            this.columnAnnotation.setReferencedColumnName(name);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedReferencedColumnName_(name);
        }
    }

    protected void setSpecifiedReferencedColumnName_(String name) {
        String old = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = name;
        this.firePropertyChanged("specifiedReferencedColumnName", old, name);
    }

    protected String buildSpecifiedReferencedColumnName() {
        return this.columnAnnotation.getReferencedColumnName();
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String name) {
        String old = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = name;
        this.firePropertyChanged("defaultReferencedColumnName", old, name);
    }

    protected String buildDefaultReferencedColumnName() {
        return this.buildDefaultName();
    }

    @Override
    public Table getReferencedColumnDbTable() {
        return ((JavaBaseJoinColumn.Owner)this.owner).getReferencedColumnDbTable();
    }

    protected Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedColumnName());
    }

    @Override
    public boolean referencedColumnIsResolved() {
        return this.getReferencedDbColumn() != null;
    }

    @Override
    public boolean isDefault() {
        return ((JavaBaseJoinColumn.Owner)this.owner).joinColumnIsDefault(this);
    }

    @Override
    public String getTable() {
        return ((JavaBaseJoinColumn.Owner)this.owner).getDefaultTableName();
    }

    @Override
    protected Iterator<String> connectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.referencedColumnNameTouches(pos, astRoot)) {
            return this.getJavaCandidateReferencedColumnNames(filter).iterator();
        }
        return null;
    }

    public boolean referencedColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.columnAnnotation.referencedColumnNameTouches(pos, astRoot);
    }

    protected Iterable<String> getJavaCandidateReferencedColumnNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateReferencedColumnNames(filter));
    }

    protected Iterable<String> getCandidateReferencedColumnNames(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateReferencedColumnNames(), filter);
    }

    protected Iterable<String> getCandidateReferencedColumnNames() {
        Table table = ((JavaBaseJoinColumn.Owner)this.owner).getReferencedColumnDbTable();
        return table != null ? table.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    protected NamedColumnTextRangeResolver buildTextRangeResolver(CompilationUnit astRoot) {
        return new JavaPrimaryKeyJoinColumnTextRangeResolver(this, astRoot);
    }

    @Override
    public TextRange getReferencedColumnNameTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.columnAnnotation.getReferencedColumnNameTextRange(astRoot), astRoot);
    }

    @Override
    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append("=>");
        sb.append(this.getReferencedColumnName());
    }
}

