/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Attribute;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.ElementCollection2_0Annotation;
import org.eclipse.jpt.jpa.core.resource.java.FetchType;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceElementCollection2_0Annotation
extends SourceAnnotation<Attribute>
implements ElementCollection2_0Annotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.ElementCollection");
    private static final DeclarationAnnotationElementAdapter<String> TARGET_CLASS_ADAPTER = SourceElementCollection2_0Annotation.buildTargetClassAdapter();
    private final AnnotationElementAdapter<String> targetClassAdapter;
    private String targetClass;
    private String fullyQualifiedTargetClassName;
    private boolean fqTargetClassNameStale = true;
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = SourceElementCollection2_0Annotation.buildFetchAdapter();
    private final AnnotationElementAdapter<String> fetchAdapter;
    private FetchType fetch;

    public SourceElementCollection2_0Annotation(JavaResourcePersistentAttribute parent, Attribute attribute) {
        super(parent, attribute, DECLARATION_ANNOTATION_ADAPTER);
        this.targetClassAdapter = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)attribute, TARGET_CLASS_ADAPTER);
        this.fetchAdapter = new AnnotatedElementAnnotationElementAdapter((AnnotatedElement)attribute, FETCH_ADAPTER);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.ElementCollection";
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.targetClass = this.buildTargetClass(astRoot);
        this.fetch = this.buildFetch(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncTargetClass(this.buildTargetClass(astRoot));
        this.syncFetch(this.buildFetch(astRoot));
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.targetClass == null && this.fetch == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.targetClass);
    }

    @Override
    public String getTargetClass() {
        return this.targetClass;
    }

    @Override
    public void setTargetClass(String targetClass) {
        if (this.attributeValueHasChanged(this.targetClass, targetClass)) {
            this.targetClass = targetClass;
            this.fqTargetClassNameStale = true;
            this.targetClassAdapter.setValue((Object)targetClass);
        }
    }

    private void syncTargetClass(String astTargetClass) {
        if (this.attributeValueHasChanged(this.targetClass, astTargetClass)) {
            this.syncTargetClass_(astTargetClass);
        }
    }

    private void syncTargetClass_(String astTargetClass) {
        String old = this.targetClass;
        this.targetClass = astTargetClass;
        this.fqTargetClassNameStale = true;
        this.firePropertyChanged("targetClass", old, astTargetClass);
    }

    private String buildTargetClass(CompilationUnit astRoot) {
        return (String)this.targetClassAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getTargetClassTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(TARGET_CLASS_ADAPTER, astRoot);
    }

    @Override
    public String getFullyQualifiedTargetClassName() {
        if (this.fqTargetClassNameStale) {
            this.fullyQualifiedTargetClassName = this.buildFullyQualifiedTargetClassName();
            this.fqTargetClassNameStale = false;
        }
        return this.fullyQualifiedTargetClassName;
    }

    private String buildFullyQualifiedTargetClassName() {
        return this.targetClass == null ? null : this.buildFullyQualifiedTargetClassName_();
    }

    private String buildFullyQualifiedTargetClassName_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.targetClassAdapter.getExpression(this.buildASTRoot()));
    }

    @Override
    public FetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(FetchType fetch) {
        if (this.attributeValueHasChanged((Object)this.fetch, (Object)fetch)) {
            this.fetch = fetch;
            this.fetchAdapter.setValue((Object)FetchType.toJavaAnnotationValue(fetch));
        }
    }

    private void syncFetch(FetchType astFetch) {
        FetchType old = this.fetch;
        this.fetch = astFetch;
        this.firePropertyChanged("fetch", (Object)old, (Object)astFetch);
    }

    private FetchType buildFetch(CompilationUnit astRoot) {
        return FetchType.fromJavaAnnotationValue(this.fetchAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getFetchTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(FETCH_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch");
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetClassAdapter() {
        return SourceElementCollection2_0Annotation.buildTargetClassAdapter(DECLARATION_ANNOTATION_ADAPTER, "targetClass");
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetClassAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return SourceElementCollection2_0Annotation.buildAnnotationElementAdapter(annotationAdapter, elementName, (ExpressionConverter<String>)SimpleTypeStringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }
}

