/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.xml;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.XmlFile;
import org.eclipse.jpt.jpa.core.resource.xml.JpaXmlResource;

public class JpaXmlResourcePropertyTester
extends PropertyTester {
    public static final String IS_LATEST_SUPPORTED_VERSION = "isLatestSupportedVersion";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        JpaXmlResource xmlResource = null;
        if (receiver instanceof JpaXmlResource) {
            xmlResource = (JpaXmlResource)((Object)receiver);
        } else if (receiver instanceof XmlFile) {
            xmlResource = ((XmlFile)receiver).getXmlResource();
        } else {
            return false;
        }
        if (IS_LATEST_SUPPORTED_VERSION.equals(property)) {
            boolean actual;
            boolean expected = (Boolean)expectedValue;
            JpaProject jpaProject = JptJpaCorePlugin.getJpaProject(xmlResource.getProject());
            IContentType contentType = xmlResource.getContentType();
            boolean bl = actual = xmlResource.getVersion() != null && xmlResource.getVersion().equals(jpaProject.getJpaPlatform().getMostRecentSupportedResourceType(contentType).getVersion());
            return actual == expected;
        }
        return false;
    }
}

