/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.RandomAccess;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.HashBag;
import org.eclipse.jpt.common.utility.internal.Range;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayListIterator;
import org.eclipse.jpt.common.utility.internal.iterators.SingleElementIterator;
import org.eclipse.jpt.common.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.jpt.common.utility.internal.iterators.SuperIteratorWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionTools {
    public static <E> boolean addAll(Collection<? super E> collection, Iterable<? extends E> iterable) {
        return CollectionTools.addAll(collection, iterable.iterator());
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterable<? extends E> iterable, int size) {
        return CollectionTools.addAll(collection, iterable.iterator(), size);
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterator<? extends E> iterator) {
        return iterator.hasNext() ? CollectionTools.addAll_(collection, iterator) : false;
    }

    private static <E> boolean addAll_(Collection<? super E> collection, Iterator<? extends E> iterator) {
        boolean modified = false;
        while (iterator.hasNext()) {
            modified |= collection.add(iterator.next());
        }
        return modified;
    }

    public static <E> boolean addAll(Collection<? super E> collection, Iterator<? extends E> iterator, int size) {
        return iterator.hasNext() ? collection.addAll(CollectionTools.list(iterator, size)) : false;
    }

    public static <E> boolean addAll(Collection<? super E> collection, E ... array) {
        return array.length == 0 ? false : CollectionTools.addAll_(collection, array);
    }

    private static <E> boolean addAll_(Collection<? super E> collection, E ... array) {
        boolean modified = false;
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            modified |= collection.add(element);
            ++n2;
        }
        return modified;
    }

    public static <E> boolean addAll(List<? super E> list, int index, Iterable<E> iterable) {
        return CollectionTools.addAll(list, index, iterable.iterator());
    }

    public static <E> boolean addAll(List<? super E> list, int index, Iterable<E> iterable, int size) {
        return CollectionTools.addAll(list, index, iterable.iterator(), size);
    }

    public static <E> boolean addAll(List<? super E> list, int index, Iterator<? extends E> iterator) {
        return iterator.hasNext() ? list.addAll(index, CollectionTools.list(iterator)) : false;
    }

    public static <E> boolean addAll(List<? super E> list, int index, Iterator<? extends E> iterator, int size) {
        return iterator.hasNext() ? list.addAll(index, CollectionTools.list(iterator, size)) : false;
    }

    public static <E> boolean addAll(List<? super E> list, int index, E ... array) {
        return array.length == 0 ? false : list.addAll(index, Arrays.asList(array));
    }

    public static <E> HashBag<E> bag(Enumeration<? extends E> enumeration) {
        return CollectionTools.bag(enumeration, new HashBag());
    }

    public static <E> HashBag<E> bag(Enumeration<? extends E> enumeration, int enumerationSize) {
        return CollectionTools.bag(enumeration, new HashBag(enumerationSize));
    }

    private static <E> HashBag<E> bag(Enumeration<? extends E> enumeration, HashBag<E> bag) {
        while (enumeration.hasMoreElements()) {
            bag.add(enumeration.nextElement());
        }
        return bag;
    }

    public static <E> HashBag<E> bag(Iterable<? extends E> iterable) {
        return CollectionTools.bag(iterable.iterator());
    }

    public static <E> HashBag<E> bag(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.bag(iterable.iterator(), iterableSize);
    }

    public static <E> HashBag<E> bag(Iterator<? extends E> iterator) {
        return CollectionTools.bag(iterator, new HashBag());
    }

    public static <E> HashBag<E> bag(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.bag(iterator, new HashBag(iteratorSize));
    }

    private static <E> HashBag<E> bag(Iterator<? extends E> iterator, HashBag<E> bag) {
        while (iterator.hasNext()) {
            bag.add(iterator.next());
        }
        return bag;
    }

    public static <E> HashBag<E> bag(E ... array) {
        int len = array.length;
        HashBag<E> bag = new HashBag<E>(len);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            bag.add(item);
            ++n2;
        }
        return bag;
    }

    public static <E> HashBag<E> collection(Enumeration<? extends E> enumeration) {
        return CollectionTools.bag(enumeration);
    }

    public static <E> HashBag<E> collection(Enumeration<? extends E> enumeration, int enumerationSize) {
        return CollectionTools.bag(enumeration, enumerationSize);
    }

    public static <E> HashBag<E> collection(Iterable<? extends E> iterable) {
        return CollectionTools.collection(iterable.iterator());
    }

    public static <E> HashBag<E> collection(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.collection(iterable.iterator(), iterableSize);
    }

    public static <E> HashBag<E> collection(Iterator<? extends E> iterator) {
        return CollectionTools.bag(iterator);
    }

    public static <E> HashBag<E> collection(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.bag(iterator, iteratorSize);
    }

    public static <E> HashBag<E> collection(E ... array) {
        return CollectionTools.bag(array);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(Enumeration<?> enumeration, Object value) {
        block2: {
            if (value != null) ** GOTO lbl8
            while (enumeration.hasMoreElements()) {
                if (enumeration.nextElement() != null) continue;
                return true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(enumeration.nextElement())) continue;
                return true;
lbl8:
                // 2 sources

                ** while (enumeration.hasMoreElements())
            }
        }
        return false;
    }

    public static boolean contains(Iterable<?> iterable, Object value) {
        return CollectionTools.contains(iterable.iterator(), value);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(Iterator<?> iterator, Object value) {
        block2: {
            if (value != null) ** GOTO lbl8
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(iterator.next())) continue;
                return true;
lbl8:
                // 2 sources

                ** while (iterator.hasNext())
            }
        }
        return false;
    }

    public static boolean containsAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.containsAll(collection, iterable.iterator());
    }

    public static boolean containsAll(Collection<?> collection, Iterator<?> iterator) {
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Collection<?> collection, Object ... array) {
        int i = array.length;
        while (i-- > 0) {
            if (collection.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAll(Iterable<?> iterable, Collection<?> collection) {
        return CollectionTools.containsAll(iterable.iterator(), collection);
    }

    public static boolean containsAll(Iterable<?> iterable, int iterableSize, Collection<?> collection) {
        return CollectionTools.containsAll(iterable.iterator(), iterableSize, collection);
    }

    public static boolean containsAll(Iterable<?> iterable1, Iterable<?> iterable2) {
        return CollectionTools.containsAll(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean containsAll(Iterable<?> iterable1, int iterable1Size, Iterable<?> iterable2) {
        return CollectionTools.containsAll(iterable1.iterator(), iterable1Size, iterable2.iterator());
    }

    public static boolean containsAll(Iterable<?> iterable, Iterator<?> iterator) {
        return CollectionTools.containsAll(iterable.iterator(), iterator);
    }

    public static boolean containsAll(Iterable<?> iterable, int iterableSize, Iterator<?> iterator) {
        return CollectionTools.containsAll(iterable.iterator(), iterableSize, iterator);
    }

    public static boolean containsAll(Iterable<?> iterable, Object ... array) {
        return CollectionTools.containsAll(iterable.iterator(), array);
    }

    public static boolean containsAll(Iterable<?> iterable, int iterableSize, Object ... array) {
        return CollectionTools.containsAll(iterable.iterator(), iterableSize, array);
    }

    public static boolean containsAll(Iterator<?> iterator, Collection<?> collection) {
        return CollectionTools.set(iterator).containsAll(collection);
    }

    public static boolean containsAll(Iterator<?> iterator, int iteratorSize, Collection<?> collection) {
        return CollectionTools.set(iterator, iteratorSize).containsAll(collection);
    }

    public static boolean containsAll(Iterator<?> iterator, Iterable<?> iterable) {
        return CollectionTools.containsAll(CollectionTools.set(iterator), iterable);
    }

    public static boolean containsAll(Iterator<?> iterator, int iteratorSize, Iterable<?> iterable) {
        return CollectionTools.containsAll(CollectionTools.set(iterator, iteratorSize), iterable);
    }

    public static boolean containsAll(Iterator<?> iterator1, Iterator<?> iterator2) {
        return CollectionTools.containsAll(CollectionTools.set(iterator1), iterator2);
    }

    public static boolean containsAll(Iterator<?> iterator1, int iterator1Size, Iterator<?> iterator2) {
        return CollectionTools.containsAll(CollectionTools.set(iterator1, iterator1Size), iterator2);
    }

    public static boolean containsAll(Iterator<?> iterator, Object ... array) {
        return CollectionTools.containsAll(CollectionTools.set(iterator), array);
    }

    public static boolean containsAll(Iterator<?> iterator, int iteratorSize, Object ... array) {
        return CollectionTools.containsAll(CollectionTools.set(iterator, iteratorSize), array);
    }

    public static int diffEnd(List<?> list1, List<?> list2) {
        return ArrayTools.diffEnd(list1.toArray(), list2.toArray());
    }

    public static Range diffRange(List<?> list1, List<?> list2) {
        return ArrayTools.diffRange(list1.toArray(), list2.toArray());
    }

    public static int diffStart(List<?> list1, List<?> list2) {
        return ArrayTools.diffStart(list1.toArray(), list2.toArray());
    }

    public static int identityDiffEnd(List<?> list1, List<?> list2) {
        return ArrayTools.identityDiffEnd(list1.toArray(), list2.toArray());
    }

    public static Range identityDiffRange(List<?> list1, List<?> list2) {
        return ArrayTools.identityDiffRange(list1.toArray(), list2.toArray());
    }

    public static int identityDiffStart(List<?> list1, List<?> list2) {
        return ArrayTools.identityDiffStart(list1.toArray(), list2.toArray());
    }

    public static boolean elementsAreDifferent(Iterable<?> iterable1, Iterable<?> iterable2) {
        return CollectionTools.elementsAreDifferent(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean elementsAreDifferent(Iterator<?> iterator1, Iterator<?> iterator2) {
        return !CollectionTools.elementsAreEqual(iterator1, iterator2);
    }

    public static boolean elementsAreEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        return CollectionTools.elementsAreEqual(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean elementsAreEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (!Tools.valuesAreDifferent(iterator1.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static boolean elementsAreIdentical(Iterable<?> iterable1, Iterable<?> iterable2) {
        return CollectionTools.elementsAreIdentical(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean elementsAreIdentical(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (iterator1.next() == iterator2.next()) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static boolean elementsAreNotIdentical(Iterable<?> iterable1, Iterable<?> iterable2) {
        return CollectionTools.elementsAreNotIdentical(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean elementsAreNotIdentical(Iterator<?> iterator1, Iterator<?> iterator2) {
        return !CollectionTools.elementsAreIdentical(iterator1, iterator2);
    }

    public static <E> E get(Iterable<? extends E> iterable, int index) {
        return CollectionTools.get(iterable.iterator(), index);
    }

    public static <E> E get(Iterator<? extends E> iterator, int index) {
        int i = 0;
        while (iterator.hasNext()) {
            E next = iterator.next();
            if (i++ != index) continue;
            return next;
        }
        throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(index)) + ':' + String.valueOf(i));
    }

    public static int hashCode(Iterable<?> iterable) {
        if (iterable == null) {
            return 0;
        }
        int hash = 1;
        for (Object element : iterable) {
            hash = 31 * hash + (element == null ? 0 : element.hashCode());
        }
        return hash;
    }

    public static int indexOf(Iterable<?> iterable, Object value) {
        return CollectionTools.indexOf(iterable.iterator(), value);
    }

    public static int indexOf(Iterator<?> iterator, Object value) {
        if (value == null) {
            int i = 0;
            while (iterator.hasNext()) {
                if (iterator.next() == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (iterator.hasNext()) {
                if (value.equals(iterator.next())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static <E extends Comparable<? super E>> int insertionIndexOf(List<E> sortedList, Comparable<E> value) {
        if (sortedList instanceof RandomAccess) {
            int i = sortedList.size();
            while (i-- > 0) {
                if (value.compareTo((Comparable)sortedList.get(i)) < 0) continue;
                return i + 1;
            }
            return 0;
        }
        int i = 0;
        for (Comparable element : sortedList) {
            if (value.compareTo(element) <= 0) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public static <E> int insertionIndexOf(List<E> sortedList, E value, Comparator<? super E> comparator) {
        if (sortedList instanceof RandomAccess) {
            int i = sortedList.size();
            while (i-- > 0) {
                if (comparator.compare(value, sortedList.get(i)) < 0) continue;
                return i + 1;
            }
            return 0;
        }
        int i = 0;
        for (E element : sortedList) {
            if (comparator.compare(value, element) <= 0) {
                return i;
            }
            ++i;
        }
        return i;
    }

    public static <E> Iterable<E> iterable(E ... array) {
        return new ArrayIterable<E>(array);
    }

    public static <E> Iterator<E> iterator(E ... array) {
        return new ArrayIterator<E>(array);
    }

    public static <E> E last(Iterable<E> iterable) {
        return CollectionTools.last(iterable.iterator());
    }

    public static <E> E last(Iterator<E> iterator) {
        E last;
        do {
            last = iterator.next();
        } while (iterator.hasNext());
        return last;
    }

    public static int lastIndexOf(Iterable<?> iterable, Object value) {
        return CollectionTools.lastIndexOf(iterable.iterator(), value);
    }

    public static int lastIndexOf(Iterable<?> iterable, int iterableSize, Object value) {
        return CollectionTools.lastIndexOf(iterable.iterator(), iterableSize, value);
    }

    public static int lastIndexOf(Iterator<?> iterator, Object value) {
        return iterator.hasNext() ? CollectionTools.list(iterator).lastIndexOf(value) : -1;
    }

    public static int lastIndexOf(Iterator<?> iterator, int iteratorSize, Object value) {
        return iterator.hasNext() ? CollectionTools.list(iterator, iteratorSize).lastIndexOf(value) : -1;
    }

    public static <E> ArrayList<E> list(Iterable<? extends E> iterable) {
        return CollectionTools.list(iterable.iterator());
    }

    public static <E> ArrayList<E> list(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.list(iterable.iterator(), iterableSize);
    }

    public static <E> ArrayList<E> list(Iterator<? extends E> iterator) {
        return CollectionTools.list(iterator, new ArrayList());
    }

    public static <E> ArrayList<E> list(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.list(iterator, new ArrayList(iteratorSize));
    }

    private static <E> ArrayList<E> list(Iterator<? extends E> iterator, ArrayList<E> list) {
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static <E> ArrayList<E> list(E ... array) {
        return new ArrayList<E>(Arrays.asList(array));
    }

    public static <E> ListIterator<E> listIterator(E ... array) {
        return CollectionTools.listIterator(array, 0);
    }

    public static <E> ListIterator<E> listIterator(E[] array, int start) {
        return CollectionTools.listIterator(array, start, array.length - start);
    }

    public static <E> ListIterator<E> listIterator(E[] array, int start, int length) {
        return new ArrayListIterator<E>(array, start, length);
    }

    public static <E> List<E> move(List<E> list, int targetIndex, int sourceIndex) {
        return targetIndex == sourceIndex ? list : CollectionTools.move_(list, targetIndex, sourceIndex);
    }

    private static <E> List<E> move_(List<E> list, int targetIndex, int sourceIndex) {
        if (list instanceof RandomAccess) {
            E temp = list.get(sourceIndex);
            if (targetIndex < sourceIndex) {
                int i = sourceIndex;
                while (i-- > targetIndex) {
                    list.set(i + 1, list.get(i));
                }
            } else {
                int i = sourceIndex;
                while (i < targetIndex) {
                    list.set(i, list.get(i + 1));
                    ++i;
                }
            }
            list.set(targetIndex, temp);
        } else {
            list.add(targetIndex, list.remove(sourceIndex));
        }
        return list;
    }

    public static <E> List<E> move(List<E> list, int targetIndex, int sourceIndex, int length) {
        if (targetIndex == sourceIndex || length == 0) {
            return list;
        }
        if (length == 1) {
            return CollectionTools.move_(list, targetIndex, sourceIndex);
        }
        if (list instanceof RandomAccess) {
            int i;
            ArrayList<E> temp = new ArrayList<E>(list.subList(sourceIndex, sourceIndex + length));
            if (targetIndex < sourceIndex) {
                i = sourceIndex;
                while (i-- > targetIndex) {
                    list.set(i + length, list.get(i));
                }
            } else {
                i = sourceIndex;
                while (i < targetIndex) {
                    list.set(i, list.get(i + length));
                    ++i;
                }
            }
            i = 0;
            while (i < length) {
                list.set(targetIndex + i, temp.get(i));
                ++i;
            }
        } else {
            list.addAll(targetIndex, CollectionTools.removeElementsAtIndex(list, sourceIndex, length));
        }
        return list;
    }

    public static boolean removeAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.removeAll(collection, iterable.iterator());
    }

    public static boolean removeAll(Collection<?> collection, Iterable<?> iterable, int iterableSize) {
        return CollectionTools.removeAll(collection, iterable.iterator(), iterableSize);
    }

    public static boolean removeAll(Collection<?> collection, Iterator<?> iterator) {
        return iterator.hasNext() ? collection.removeAll(CollectionTools.set(iterator)) : false;
    }

    public static boolean removeAll(Collection<?> collection, Iterator<?> iterator, int iteratorSize) {
        return iterator.hasNext() ? collection.removeAll(CollectionTools.set(iterator, iteratorSize)) : false;
    }

    public static boolean removeAll(Collection<?> collection, Object ... array) {
        return array.length == 0 ? false : collection.removeAll(CollectionTools.set(array));
    }

    /*
     * Unable to fully structure code
     */
    public static boolean removeAllOccurrences(Collection<?> collection, Object value) {
        block2: {
            modified = false;
            stream = collection.iterator();
            if (value != null) ** GOTO lbl13
            while (stream.hasNext()) {
                if (stream.next() != null) continue;
                stream.remove();
                modified = true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(stream.next())) continue;
                stream.remove();
                modified = true;
lbl13:
                // 3 sources

                ** while (stream.hasNext())
            }
        }
        return modified;
    }

    public static <E> ArrayList<E> removeElementsAtIndex(List<E> list, int index, int length) {
        List<E> subList = list.subList(index, index + length);
        ArrayList<E> result = new ArrayList<E>(subList);
        subList.clear();
        return result;
    }

    public static <E> boolean removeDuplicateElements(List<E> list) {
        int size = list.size();
        if (size == 0 || size == 1) {
            return false;
        }
        return CollectionTools.removeDuplicateElements(list, size);
    }

    static <E> boolean removeDuplicateElements(List<E> list, int size) {
        LinkedHashSet<E> temp = new LinkedHashSet<E>(size);
        boolean modified = false;
        for (E item : list) {
            if (temp.add(item)) continue;
            modified = true;
        }
        if (modified) {
            int i = 0;
            for (Object e : temp) {
                list.set(i, e);
                ++i;
            }
            int tempSize = temp.size();
            i = list.size();
            while (i-- > tempSize) {
                list.remove(i);
            }
        }
        return modified;
    }

    public static boolean retainAll(Collection<?> collection, Iterable<?> iterable) {
        return CollectionTools.retainAll(collection, iterable.iterator());
    }

    public static boolean retainAll(Collection<?> collection, Iterable<?> iterable, int iterableSize) {
        return CollectionTools.retainAll(collection, iterable.iterator(), iterableSize);
    }

    public static boolean retainAll(Collection<?> collection, Iterator<?> iterator) {
        if (iterator.hasNext()) {
            return collection.retainAll(CollectionTools.set(iterator));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static boolean retainAll(Collection<?> collection, Iterator<?> iterator, int iteratorSize) {
        if (iterator.hasNext()) {
            return collection.retainAll(CollectionTools.set(iterator, iteratorSize));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static boolean retainAll(Collection<?> collection, Object ... array) {
        if (array.length > 0) {
            return collection.retainAll(CollectionTools.set(array));
        }
        if (collection.isEmpty()) {
            return false;
        }
        collection.clear();
        return true;
    }

    public static <E> ArrayList<E> reverseList(Iterable<? extends E> iterable) {
        return CollectionTools.reverseList(iterable.iterator());
    }

    public static <E> ArrayList<E> reverseList(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.reverseList(iterable.iterator(), iterableSize);
    }

    public static <E> ArrayList<E> reverseList(Iterator<? extends E> iterator) {
        return (ArrayList)CollectionTools.reverse(CollectionTools.list(iterator));
    }

    public static <E> ArrayList<E> reverseList(Iterator<? extends E> iterator, int size) {
        return (ArrayList)CollectionTools.reverse(CollectionTools.list(iterator, size));
    }

    public static <E> List<E> rotate(List<E> list) {
        return CollectionTools.rotate(list, 1);
    }

    public static <E> HashSet<E> set(Iterable<? extends E> iterable) {
        return CollectionTools.set(iterable.iterator());
    }

    public static <E> HashSet<E> set(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.set(iterable.iterator(), iterableSize);
    }

    public static <E> HashSet<E> set(Iterator<? extends E> iterator) {
        return CollectionTools.set(iterator, new HashSet());
    }

    public static <E> HashSet<E> set(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.set(iterator, new HashSet(iteratorSize));
    }

    private static <E> HashSet<E> set(Iterator<? extends E> iterator, HashSet<E> set) {
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <E> HashSet<E> set(E ... array) {
        HashSet<E> set = new HashSet<E>(array.length);
        int i = array.length;
        while (i-- > 0) {
            set.add(array[i]);
        }
        return set;
    }

    public static <E> Iterator<E> singletonIterator(E value) {
        return new SingleElementIterator<E>(value);
    }

    public static <E> ListIterator<E> singletonListIterator(E value) {
        return new SingleElementListIterator<E>(value);
    }

    public static int size(Iterable<?> iterable) {
        return CollectionTools.size(iterable.iterator());
    }

    public static int size(Iterator<?> iterator) {
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return CollectionTools.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return !iterator.hasNext();
    }

    public static <E extends Comparable<? super E>> Iterable<E> sort(Iterable<E> iterable) {
        return CollectionTools.sort(iterable, null);
    }

    public static <E extends Comparable<? super E>> Iterable<E> sort(Iterable<E> iterable, int iterableSize) {
        return CollectionTools.sort(iterable, null, iterableSize);
    }

    public static <E> Iterable<E> sort(Iterable<E> iterable, Comparator<? super E> comparator) {
        return CollectionTools.sort(CollectionTools.list(iterable), comparator);
    }

    public static <E> Iterable<E> sort(Iterable<E> iterable, Comparator<? super E> comparator, int iterableSize) {
        return CollectionTools.sort(CollectionTools.list(iterable, iterableSize), comparator);
    }

    public static <E extends Comparable<? super E>> ListIterator<E> sort(Iterator<? extends E> iterator) {
        return CollectionTools.sort(iterator, null);
    }

    public static <E extends Comparable<? super E>> ListIterator<E> sort(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.sort(iterator, null, iteratorSize);
    }

    public static <E> ListIterator<E> sort(Iterator<? extends E> iterator, Comparator<? super E> comparator) {
        return CollectionTools.sort(CollectionTools.list(iterator), comparator).listIterator();
    }

    public static <E> ListIterator<E> sort(Iterator<? extends E> iterator, Comparator<? super E> comparator, int iteratorSize) {
        return CollectionTools.sort(CollectionTools.list(iterator, iteratorSize), comparator).listIterator();
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterable<? extends E> iterable) {
        return CollectionTools.sortedSet(iterable.iterator());
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterable<? extends E> iterable, int iterableSize) {
        return CollectionTools.sortedSet(iterable.iterator(), iterableSize);
    }

    public static <E> TreeSet<E> sortedSet(Iterable<? extends E> iterable, Comparator<? super E> comparator) {
        return CollectionTools.sortedSet(iterable.iterator(), comparator);
    }

    public static <E> TreeSet<E> sortedSet(Iterable<? extends E> iterable, Comparator<? super E> comparator, int iterableSize) {
        return CollectionTools.sortedSet(iterable.iterator(), comparator, iterableSize);
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterator<? extends E> iterator) {
        return CollectionTools.sortedSet(iterator, null);
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.sortedSet(iterator, null, iteratorSize);
    }

    public static <E> TreeSet<E> sortedSet(Iterator<? extends E> iterator, Comparator<? super E> comparator) {
        return CollectionTools.sortedSet(CollectionTools.list(iterator), comparator);
    }

    public static <E> TreeSet<E> sortedSet(Iterator<? extends E> iterator, Comparator<? super E> comparator, int iteratorSize) {
        return CollectionTools.sortedSet(CollectionTools.list(iterator, iteratorSize), comparator);
    }

    private static <E> TreeSet<E> sortedSet(List<E> list, Comparator<? super E> comparator) {
        TreeSet<E> sortedSet = new TreeSet<E>(comparator);
        sortedSet.addAll(list);
        return sortedSet;
    }

    public static <E extends Comparable<? super E>> TreeSet<E> sortedSet(E ... array) {
        return CollectionTools.sortedSet(array, null);
    }

    public static <E> TreeSet<E> sortedSet(E[] array, Comparator<? super E> comparator) {
        TreeSet<E> sortedSet = new TreeSet<E>(comparator);
        sortedSet.addAll(Arrays.asList(array));
        return sortedSet;
    }

    public static <E> Vector<E> vector(Iterable<? extends E> iterable) {
        return CollectionTools.vector(iterable.iterator());
    }

    public static <E> Vector<E> vector(Iterable<? extends E> iterable, int size) {
        return CollectionTools.vector(iterable.iterator(), size);
    }

    public static <E> Vector<E> vector(Iterator<? extends E> iterator) {
        return CollectionTools.vector(iterator, new Vector());
    }

    public static <E> Vector<E> vector(Iterator<? extends E> iterator, int size) {
        return CollectionTools.vector(iterator, new Vector(size));
    }

    private static <E> Vector<E> vector(Iterator<? extends E> iterator, Vector<E> v) {
        while (iterator.hasNext()) {
            v.addElement(iterator.next());
        }
        return v;
    }

    public static <E> Vector<E> vector(E ... array) {
        Vector<E> v = new Vector<E>(array.length);
        E[] EArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            E item = EArray[n2];
            v.addElement(item);
            ++n2;
        }
        return v;
    }

    public static <E> Iterable<E> iterable(Iterator<? extends E> iterator) {
        return new SingleUseIterable<E>(iterator);
    }

    public static <E> List<E> copy(List<E> dest, List<? extends E> src) {
        Collections.copy(dest, src);
        return dest;
    }

    public static <E> List<E> fill(List<E> list, E value) {
        Collections.fill(list, value);
        return list;
    }

    public static <E> List<E> reverse(List<E> list) {
        Collections.reverse(list);
        return list;
    }

    public static <E> List<E> rotate(List<E> list, int distance) {
        Collections.rotate(list, distance);
        return list;
    }

    public static <E> List<E> shuffle(List<E> list) {
        Collections.shuffle(list);
        return list;
    }

    public static <E> List<E> shuffle(List<E> list, Random random) {
        Collections.shuffle(list, random);
        return list;
    }

    public static <E extends Comparable<? super E>> List<E> sort(List<E> list) {
        Collections.sort(list);
        return list;
    }

    public static <E> List<E> sort(List<E> list, Comparator<? super E> comparator) {
        Collections.sort(list, comparator);
        return list;
    }

    public static <E> List<E> swap(List<E> list, int i, int j) {
        Collections.swap(list, i, j);
        return list;
    }

    private CollectionTools() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SingleUseIterable<E>
    implements Iterable<E> {
        private Iterator<E> iterator;

        public SingleUseIterable(Iterator<? extends E> iterator) {
            if (iterator == null) {
                throw new NullPointerException();
            }
            this.iterator = new SuperIteratorWrapper<E>(iterator);
        }

        @Override
        public Iterator<E> iterator() {
            if (this.iterator == null) {
                throw new IllegalStateException("This method has already been called.");
            }
            Iterator<E> result = this.iterator;
            this.iterator = null;
            return result;
        }

        public String toString() {
            return StringTools.buildToStringFor(this, this.iterator);
        }
    }
}

