/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterators;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneListIterator<E>
implements ListIterator<E> {
    private final ListIterator<Object> listIterator;
    private int cursor;
    private State state;
    private final Mutator<E> mutator;

    public CloneListIterator(List<? extends E> list) {
        this(list, Mutator.ReadOnly.instance());
    }

    public CloneListIterator(E[] array) {
        this(array, Mutator.ReadOnly.instance());
    }

    public CloneListIterator(List<? extends E> list, Mutator<E> mutator) {
        this(mutator, list.toArray());
    }

    public CloneListIterator(E[] array, Mutator<E> mutator) {
        this(mutator, (Object[])array.clone());
    }

    protected CloneListIterator(Mutator<E> mutator, Object ... array) {
        this.listIterator = CollectionTools.list(array).listIterator();
        this.mutator = mutator;
        this.cursor = 0;
        this.state = State.UNKNOWN;
    }

    @Override
    public boolean hasNext() {
        return this.listIterator.hasNext();
    }

    @Override
    public E next() {
        E next = this.nestedNext();
        ++this.cursor;
        this.state = State.NEXT;
        return next;
    }

    @Override
    public void remove() {
        this.listIterator.remove();
        if (this.state == State.PREVIOUS) {
            this.remove(this.cursor);
        } else {
            --this.cursor;
            this.remove(this.cursor);
        }
    }

    @Override
    public int nextIndex() {
        return this.listIterator.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.listIterator.previousIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.listIterator.hasPrevious();
    }

    @Override
    public E previous() {
        E previous = this.nestedPrevious();
        --this.cursor;
        this.state = State.PREVIOUS;
        return previous;
    }

    @Override
    public void add(E o) {
        this.listIterator.add(o);
        this.add(this.cursor, o);
        ++this.cursor;
    }

    @Override
    public void set(E o) {
        this.listIterator.set(o);
        if (this.state == State.PREVIOUS) {
            this.set(this.cursor, o);
        } else {
            this.set(this.cursor - 1, o);
        }
    }

    protected E nestedNext() {
        return (E)this.listIterator.next();
    }

    protected E nestedPrevious() {
        return (E)this.listIterator.previous();
    }

    protected void add(int index, E o) {
        this.mutator.add(index, o);
    }

    protected void remove(int index) {
        this.mutator.remove(index);
    }

    protected void set(int index, E o) {
        this.mutator.set(index, o);
    }

    public String toString() {
        return StringTools.buildToStringFor(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Mutator<T> {
        public void add(int var1, T var2);

        public void remove(int var1);

        public void set(int var1, T var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class ReadOnly<S>
        implements Mutator<S> {
            public static final Mutator INSTANCE = new ReadOnly();
            private static final long serialVersionUID = 1L;

            public static <R> Mutator<R> instance() {
                return INSTANCE;
            }

            private ReadOnly() {
            }

            @Override
            public void add(int index, Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void remove(int index) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(int index, Object o) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "CloneListIterator.Mutator.ReadOnly";
            }

            private Object readResolve() {
                return INSTANCE;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        UNKNOWN,
        PREVIOUS,
        NEXT;

    }
}

