/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.model.value;

import java.util.Arrays;
import org.eclipse.jpt.common.utility.internal.model.value.ValueAspectAdapter;
import org.eclipse.jpt.common.utility.model.Model;
import org.eclipse.jpt.common.utility.model.event.TreeAddEvent;
import org.eclipse.jpt.common.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.common.utility.model.event.TreeClearEvent;
import org.eclipse.jpt.common.utility.model.event.TreeRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.TreeChangeListener;
import org.eclipse.jpt.common.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueTreeAdapter<V extends Model>
extends ValueAspectAdapter<V> {
    protected final String[] treeNames;
    protected final TreeChangeListener valueTreeListener;

    public ValueTreeAdapter(WritablePropertyValueModel<V> valueHolder, String ... treeNames) {
        super(valueHolder);
        this.treeNames = treeNames;
        this.valueTreeListener = this.buildValueTreeListener();
    }

    protected TreeChangeListener buildValueTreeListener() {
        return new TreeChangeListener(){

            public void nodeAdded(TreeAddEvent event) {
                ValueTreeAdapter.this.nodeAdded(event);
            }

            public void nodeRemoved(TreeRemoveEvent event) {
                ValueTreeAdapter.this.nodeRemoved(event);
            }

            public void treeCleared(TreeClearEvent event) {
                ValueTreeAdapter.this.treeCleared(event);
            }

            public void treeChanged(TreeChangeEvent event) {
                ValueTreeAdapter.this.treeChanged(event);
            }

            public String toString() {
                return "value tree listener: " + Arrays.asList(ValueTreeAdapter.this.treeNames);
            }
        };
    }

    @Override
    protected void engageValue_() {
        String[] stringArray = this.treeNames;
        int n = this.treeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String treeName = stringArray[n2];
            ((Model)this.value).addTreeChangeListener(treeName, this.valueTreeListener);
            ++n2;
        }
    }

    @Override
    protected void disengageValue_() {
        String[] stringArray = this.treeNames;
        int n = this.treeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String treeName = stringArray[n2];
            ((Model)this.value).removeTreeChangeListener(treeName, this.valueTreeListener);
            ++n2;
        }
    }

    protected void nodeAdded(TreeAddEvent event) {
        this.valueAspectChanged();
    }

    protected void nodeRemoved(TreeRemoveEvent event) {
        this.valueAspectChanged();
    }

    protected void treeCleared(TreeClearEvent event) {
        this.valueAspectChanged();
    }

    protected void treeChanged(TreeChangeEvent event) {
        this.valueAspectChanged();
    }
}

