/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.jpt.common.utility.internal.SimpleStringMatcher;
import org.eclipse.jpt.common.utility.internal.StringConverter;
import org.eclipse.jpt.common.utility.internal.StringMatcher;
import org.eclipse.jpt.common.utility.internal.swing.SimpleListCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringListPanel<T>
extends JPanel {
    private Object[] completeList;
    StringConverter<T> stringConverter;
    private JTextField textField;
    private JLabel textFieldLabel;
    private DocumentListener textFieldListener;
    private JList listBox;
    private JLabel listBoxLabel;
    private int maxListSize;
    private StringMatcher stringMatcher;
    private Object[] buffer;
    private static final Border TEXT_FIELD_LABEL_BORDER = BorderFactory.createEmptyBorder(0, 0, 5, 0);
    private static final Border LIST_BOX_LABEL_BORDER = BorderFactory.createEmptyBorder(5, 0, 5, 0);

    public FilteringListPanel(Object[] completeList, Object initialSelection) {
        this(completeList, initialSelection, StringConverter.Default.instance());
    }

    public FilteringListPanel(Object[] completeList, Object initialSelection, StringConverter<T> stringConverter) {
        super(new BorderLayout());
        this.completeList = completeList;
        this.stringConverter = stringConverter;
        this.initialize(initialSelection);
    }

    private void initialize(Object initialSelection) {
        this.maxListSize = this.defaultMaxListSize();
        this.buffer = this.buildBuffer();
        this.textFieldListener = this.buildTextFieldListener();
        this.stringMatcher = this.buildStringMatcher();
        this.initializeLayout(initialSelection);
    }

    private Object[] buildBuffer() {
        return new Object[this.max()];
    }

    private int max() {
        if (this.maxListSize == -1) {
            return this.completeList.length;
        }
        return Math.min(this.maxListSize, this.completeList.length);
    }

    private DocumentListener buildTextFieldListener() {
        return new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                FilteringListPanel.this.filterList();
            }

            public void changedUpdate(DocumentEvent e) {
                FilteringListPanel.this.filterList();
            }

            public void removeUpdate(DocumentEvent e) {
                FilteringListPanel.this.filterList();
            }

            public String toString() {
                return "text field listener";
            }
        };
    }

    private int defaultMaxListSize() {
        return -1;
    }

    private StringMatcher buildStringMatcher() {
        return new SimpleStringMatcher();
    }

    private void initializeLayout(Object initialSelection) {
        JPanel textFieldPanel = new JPanel(new BorderLayout());
        this.textFieldLabel = new JLabel();
        this.textFieldLabel.setBorder(TEXT_FIELD_LABEL_BORDER);
        textFieldPanel.add((Component)this.textFieldLabel, "North");
        this.textField = new JTextField();
        this.textField.getDocument().addDocumentListener(this.textFieldListener);
        this.textFieldLabel.setLabelFor(this.textField);
        textFieldPanel.add((Component)this.textField, "Center");
        this.add((Component)textFieldPanel, "North");
        JPanel listBoxPanel = new JPanel(new BorderLayout());
        this.listBoxLabel = new JLabel();
        this.listBoxLabel.setBorder(LIST_BOX_LABEL_BORDER);
        listBoxPanel.add((Component)this.listBoxLabel, "North");
        this.listBox = new JList();
        this.listBox.setDoubleBuffered(true);
        this.listBox.setModel(this.buildPartialArrayListModel(this.completeList, this.max()));
        this.listBox.getSelectionModel().setSelectionMode(0);
        this.listBox.setPrototypeCellValue(this.prototypeCellValue());
        this.listBox.setPrototypeCellValue(null);
        this.listBox.setCellRenderer(this.buildDefaultCellRenderer());
        this.listBoxLabel.setLabelFor(this.listBox);
        JScrollPane listBoxScrollPane = new JScrollPane(this.listBox);
        listBoxScrollPane.getHorizontalScrollBar().setFocusable(false);
        listBoxScrollPane.getVerticalScrollBar().setFocusable(false);
        listBoxPanel.add((Component)listBoxScrollPane, "Center");
        this.listBox.setSelectedValue(initialSelection, true);
        this.textField.select(0, this.textField.getText().length());
        this.add((Component)listBoxPanel, "Center");
    }

    public Object selection() {
        return this.listBox.getSelectedValue();
    }

    public void setSelection(Object selection) {
        this.listBox.setSelectedValue(selection, true);
    }

    public Object[] completeList() {
        return this.completeList;
    }

    public void setCompleteList(Object[] completeList) {
        this.completeList = completeList;
        if (this.buffer.length < this.max()) {
            this.buffer = this.buildBuffer();
        }
        this.filterList();
    }

    public int maxListSize() {
        return this.maxListSize;
    }

    public void setMaxListSize(int maxListSize) {
        this.maxListSize = maxListSize;
        if (this.buffer.length < this.max()) {
            this.buffer = this.buildBuffer();
        }
        this.filterList();
    }

    public StringConverter<T> stringConverter() {
        return this.stringConverter;
    }

    public void setStringConverter(StringConverter<T> stringConverter) {
        this.stringConverter = stringConverter;
        this.filterList();
    }

    public JTextField textField() {
        return this.textField;
    }

    public JLabel textFieldLabel() {
        return this.textFieldLabel;
    }

    public void setTextFieldLabelText(String text) {
        this.textFieldLabel.setText(text);
    }

    public JList listBox() {
        return this.listBox;
    }

    public void setListBoxCellRenderer(ListCellRenderer renderer) {
        this.listBox.setCellRenderer(renderer);
    }

    public JLabel listBoxLabel() {
        return this.listBoxLabel;
    }

    public void setListBoxLabelText(String text) {
        this.listBoxLabel.setText(text);
    }

    public void setComponentsFont(Font font) {
        this.textFieldLabel.setFont(font);
        this.textField.setFont(font);
        this.listBoxLabel.setFont(font);
        this.listBox.setFont(font);
    }

    public StringMatcher stringMatcher() {
        return this.stringMatcher;
    }

    public void setStringMatcher(StringMatcher stringMatcher) {
        this.stringMatcher = stringMatcher;
        this.filterList();
    }

    protected String prototypeCellValue() {
        return "==========> A_STRING_THAT_IS_DEFINITELY_LONGER_THAN_EVERY_STRING_IN_THE_LIST <==========";
    }

    protected ListCellRenderer buildDefaultCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object value) {
                return FilteringListPanel.this.stringConverter.convertToString(value);
            }
        };
    }

    synchronized void filterList() {
        this.filterList(this.textField.getText());
    }

    private void filterList(String pattern) {
        if (pattern.length() == 0) {
            this.listBox.setModel(this.buildPartialArrayListModel(this.completeList, this.max()));
        } else {
            this.stringMatcher.setPatternString(pattern);
            int j = 0;
            int len = this.completeList.length;
            int max = this.max();
            int i = 0;
            while (i < len) {
                if (this.stringMatcher.matches(this.stringConverter.convertToString(this.entry(i)))) {
                    this.buffer[j++] = this.completeList[i];
                }
                if (j == max) break;
                ++i;
            }
            this.listBox.setModel(this.buildPartialArrayListModel(this.buffer, j));
        }
        if (this.listBox.getModel().getSize() == 0) {
            this.listBox.getSelectionModel().clearSelection();
        } else {
            this.listBox.getSelectionModel().setAnchorSelectionIndex(0);
            this.listBox.getSelectionModel().setLeadSelectionIndex(0);
            this.listBox.ensureIndexIsVisible(0);
        }
    }

    private T entry(int index) {
        return (T)this.completeList[index];
    }

    private ListModel buildPartialArrayListModel(final Object[] array, final int size) {
        return new AbstractListModel(){

            public int getSize() {
                return size;
            }

            public Object getElementAt(int index) {
                return array[index];
            }
        };
    }
}

