/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.viewer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.mylyn.internal.wikitext.ui.util.HyperlinkDetectorDelegate;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.HyperlinkDetectorDescriptor;
import org.eclipse.ui.texteditor.HyperlinkDetectorRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTextSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    protected boolean markupHyperlinksFirst = true;
    private List<HyperlinkDetectorDescriptorFilter> hyperlinkDetectorDescriptorFilters;
    private List<IHyperlinkDetector> hyperlinkDetectors;

    public AbstractTextSourceViewerConfiguration() {
    }

    public AbstractTextSourceViewerConfiguration(IPreferenceStore preferenceStore) {
        super(preferenceStore);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        List<IHyperlinkDetector> customDetectors = this.createCustomHyperlinkDetectors(sourceViewer);
        if (sourceViewer == null || this.fPreferenceStore == null) {
            return customDetectors.toArray(new IHyperlinkDetector[customDetectors.size()]);
        }
        HyperlinkDetectorRegistry registry = EditorsUI.getHyperlinkDetectorRegistry();
        HyperlinkDetectorDescriptor[] descriptors = registry.getHyperlinkDetectorDescriptors();
        Map targets = this.getHyperlinkDetectorTargets(sourceViewer);
        ArrayList<IHyperlinkDetector> detectors = new ArrayList<IHyperlinkDetector>(8);
        if (this.markupHyperlinksFirst) {
            detectors.addAll(customDetectors);
        }
        if (this.hyperlinkDetectors != null) {
            detectors.addAll(this.hyperlinkDetectors);
        }
        for (Map.Entry target : targets.entrySet()) {
            String targetId = (String)target.getKey();
            IAdaptable context = (IAdaptable)target.getValue();
            HyperlinkDetectorDescriptor[] hyperlinkDetectorDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                HyperlinkDetectorDescriptor descriptor = hyperlinkDetectorDescriptorArray[n2];
                if (targetId.equals(descriptor.getTargetId()) && !this.filterHyperlinkDescriptor(descriptor)) {
                    HyperlinkDetectorDelegate delegate = new HyperlinkDetectorDelegate(descriptor, this.fPreferenceStore);
                    delegate.setContext(context);
                    detectors.add(delegate);
                }
                ++n2;
            }
        }
        if (!this.markupHyperlinksFirst) {
            detectors.addAll(customDetectors);
        }
        return detectors.toArray(new IHyperlinkDetector[detectors.size()]);
    }

    protected List<IHyperlinkDetector> createCustomHyperlinkDetectors(ISourceViewer sourceViewer) {
        return Collections.emptyList();
    }

    private boolean filterHyperlinkDescriptor(HyperlinkDetectorDescriptor descriptor) {
        if (this.hyperlinkDetectorDescriptorFilters == null || this.hyperlinkDetectorDescriptorFilters.isEmpty()) {
            return false;
        }
        for (HyperlinkDetectorDescriptorFilter filter : this.hyperlinkDetectorDescriptorFilters) {
            if (!filter.filter(descriptor)) continue;
            return true;
        }
        return false;
    }

    public void addHyperlinkDetectorDescriptorFilter(HyperlinkDetectorDescriptorFilter filter) {
        if (this.hyperlinkDetectorDescriptorFilters == null) {
            this.hyperlinkDetectorDescriptorFilters = new ArrayList<HyperlinkDetectorDescriptorFilter>();
        }
        this.hyperlinkDetectorDescriptorFilters.add(filter);
    }

    public void addHyperlinkDetector(IHyperlinkDetector detector) {
        if (this.hyperlinkDetectors == null) {
            this.hyperlinkDetectors = new ArrayList<IHyperlinkDetector>();
        }
        this.hyperlinkDetectors.add(detector);
    }

    public static interface HyperlinkDetectorDescriptorFilter {
        public boolean filter(HyperlinkDetectorDescriptor var1);
    }
}

