/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import org.eclipse.persistence.oxm.record.ValidatingMarshalRecord;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JAXBErrorHandler
implements ErrorHandler {
    private ValidationEventHandler eventHandler;

    public JAXBErrorHandler(ValidationEventHandler validationEventHandler) {
        this.eventHandler = validationEventHandler;
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.handleException(exception, 0);
    }

    public void error(SAXParseException exception) throws SAXException {
        this.handleException(exception, 1);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.handleException(exception, 2);
    }

    private void handleException(SAXParseException exception, int severity) throws SAXException {
        ValidationEventImpl event;
        ValidationEventLocatorImpl eventLocator = new ValidationEventLocatorImpl(exception);
        if (exception instanceof ValidatingMarshalRecord.MarshalSAXParseException) {
            eventLocator.setObject(((ValidatingMarshalRecord.MarshalSAXParseException)exception).getObject());
        }
        if (!this.eventHandler.handleEvent((ValidationEvent)(event = new ValidationEventImpl(severity, exception.getLocalizedMessage(), (ValidationEventLocator)eventLocator, (Throwable)exception)))) {
            throw exception;
        }
    }

    public ValidationEventHandler getValidationEventHandler() {
        return this.eventHandler;
    }
}

