/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntime;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatRuntimeWorkingCopy;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPlugin;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.model.RuntimeDelegate;

public class TomcatRuntime
extends RuntimeDelegate
implements ITomcatRuntime,
ITomcatRuntimeWorkingCopy {
    protected static final String PROP_VM_INSTALL_TYPE_ID = "vm-install-type-id";
    protected static final String PROP_VM_INSTALL_ID = "vm-install-id";
    protected static Map<File, Boolean> sdkMap = new HashMap<File, Boolean>(2);
    private static Map<String, Integer> javaVersionMap = new ConcurrentHashMap<String, Integer>();

    public ITomcatVersionHandler getVersionHandler() {
        IRuntimeType type = this.getRuntime().getRuntimeType();
        return TomcatPlugin.getTomcatVersionHandler(type.getId());
    }

    protected String getVMInstallTypeId() {
        return this.getAttribute(PROP_VM_INSTALL_TYPE_ID, null);
    }

    protected String getVMInstallId() {
        return this.getAttribute(PROP_VM_INSTALL_ID, null);
    }

    public boolean isUsingDefaultJRE() {
        return this.getVMInstallTypeId() == null;
    }

    public IVMInstall getVMInstall() {
        if (this.getVMInstallTypeId() == null) {
            return JavaRuntime.getDefaultVMInstall();
        }
        try {
            IVMInstallType vmInstallType = JavaRuntime.getVMInstallType((String)this.getVMInstallTypeId());
            IVMInstall[] vmInstalls = vmInstallType.getVMInstalls();
            int size = vmInstalls.length;
            String id = this.getVMInstallId();
            int i = 0;
            while (i < size) {
                if (id.equals(vmInstalls[i].getId())) {
                    return vmInstalls[i];
                }
                ++i;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public List getRuntimeClasspath(IPath configPath) {
        IPath installPath = this.getRuntime().getLocation();
        if (!installPath.isAbsolute()) {
            try {
                String installLoc = new File(installPath.toOSString()).getCanonicalPath();
                installPath = new Path(installLoc);
            }
            catch (IOException iOException) {}
        }
        return this.getVersionHandler().getRuntimeClasspath(installPath, configPath);
    }

    public IStatus verifyLocation() {
        return this.getVersionHandler().verifyInstallPath(this.getRuntime().getLocation());
    }

    public IStatus validate() {
        String javaVersion;
        IVMInstall vmInstall;
        String os;
        File toolsJar;
        IStatus status = super.validate();
        if (!status.isOK()) {
            return status;
        }
        status = this.verifyLocation();
        if (!status.isOK()) {
            return status;
        }
        if (this.getRuntime().getLocation().hasTrailingSeparator()) {
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorInstallDirTrailingSlash, null);
        }
        if (this.getVMInstall() == null) {
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorJRE, null);
        }
        boolean found = false;
        File file = this.getVMInstall().getInstallLocation();
        if (file != null && (toolsJar = new File(file, "lib" + File.separator + "tools.jar")).exists()) {
            found = true;
        }
        String id = this.getRuntime().getRuntimeType().getId();
        if (!(found || id == null || id.indexOf("55") <= 0 && id.indexOf("60") <= 0 && id.indexOf("70") <= 0)) {
            found = true;
        }
        if (!found && (os = Platform.getOS()) != null && os.toLowerCase().indexOf("mac") >= 0) {
            found = this.checkForCompiler();
        }
        if (!found) {
            return new Status(2, "org.eclipse.jst.server.tomcat.core", 0, Messages.warningJRE, null);
        }
        File f = this.getRuntime().getLocation().append("conf").toFile();
        File[] conf = f.listFiles();
        if (conf != null) {
            int size = conf.length;
            int i = 0;
            while (i < size) {
                if (!f.canRead()) {
                    return new Status(2, "org.eclipse.jst.server.tomcat.core", 0, Messages.warningCantReadConfig, null);
                }
                ++i;
            }
        }
        if (id != null && id.indexOf("60") > 0) {
            String javaVersion2;
            IVMInstall vmInstall2 = this.getVMInstall();
            if (vmInstall2 instanceof IVMInstall2 && (javaVersion2 = ((IVMInstall2)vmInstall2).getJavaVersion()) != null && !this.isVMMinimumVersion(javaVersion2, 105)) {
                return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorJRETomcat60, null);
            }
        } else if (id != null && id.indexOf("70") > 0 && (vmInstall = this.getVMInstall()) instanceof IVMInstall2 && (javaVersion = ((IVMInstall2)vmInstall).getJavaVersion()) != null && !this.isVMMinimumVersion(javaVersion, 106)) {
            return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorJRETomcat70, null);
        }
        return Status.OK_STATUS;
    }

    public void setDefaults(IProgressMonitor monitor) {
        IRuntimeType type = this.getRuntimeWorkingCopy().getRuntimeType();
        this.getRuntimeWorkingCopy().setLocation((IPath)new Path(TomcatPlugin.getPreference("location" + type.getId())));
    }

    public void setVMInstall(IVMInstall vmInstall) {
        if (vmInstall == null) {
            this.setVMInstall(null, null);
        } else {
            this.setVMInstall(vmInstall.getVMInstallType().getId(), vmInstall.getId());
        }
    }

    protected void setVMInstall(String typeId, String id) {
        if (typeId == null) {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_TYPE_ID, typeId);
        }
        if (id == null) {
            this.setAttribute(PROP_VM_INSTALL_ID, null);
        } else {
            this.setAttribute(PROP_VM_INSTALL_ID, id);
        }
    }

    /*
     * Loose catch block
     */
    protected boolean checkForCompiler() {
        File javaHome;
        block22: {
            Launch launch;
            block23: {
                boolean bl;
                javaHome = this.getVMInstall().getInstallLocation();
                try {
                    Boolean b = sdkMap.get(javaHome);
                    return b;
                }
                catch (Exception exception) {
                    File file = TomcatPlugin.getPlugin();
                    if (file == null || !file.exists()) break block22;
                    IVMRunner vmRunner = this.getVMInstall().getVMRunner("run");
                    VMRunnerConfiguration config = new VMRunnerConfiguration("org.eclipse.jst.server.tomcat.core.internal.ClassDetector", new String[]{file.getAbsolutePath()});
                    config.setProgramArguments(new String[]{"com.sun.tools.javac.Main"});
                    launch = new Launch(null, "run", null);
                    vmRunner.run(config, (ILaunch)launch, null);
                    int i = 0;
                    while (i < 600) {
                        if (launch.isTerminated()) break;
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                        ++i;
                    }
                    IStreamsProxy streamsProxy = launch.getProcesses()[0].getStreamsProxy();
                    String text = null;
                    if (streamsProxy == null || (text = streamsProxy.getOutputStreamMonitor().getContents()) == null || text.length() <= 0) break block23;
                    boolean found = false;
                    if ("true".equals(text)) {
                        found = true;
                    }
                    sdkMap.put(javaHome, new Boolean(found));
                    bl = found;
                }
                if (!launch.isTerminated()) {
                    try {
                        launch.terminate();
                    }
                    catch (Exception exception) {}
                }
                return bl;
                {
                    catch (Exception e) {
                        try {
                            Trace.trace((byte)2, "Error checking for JDK", e);
                        }
                        catch (Throwable throwable) {
                            if (!launch.isTerminated()) {
                                try {
                                    launch.terminate();
                                }
                                catch (Exception exception) {}
                            }
                            throw throwable;
                        }
                        if (!launch.isTerminated()) {
                            try {
                                launch.terminate();
                            }
                            catch (Exception exception) {}
                        }
                        break block22;
                    }
                }
            }
            if (!launch.isTerminated()) {
                try {
                    launch.terminate();
                }
                catch (Exception exception) {}
            }
        }
        TomcatPlugin.log(MessageFormat.format("Failed compiler check for {0}", javaHome.getAbsolutePath()));
        return false;
    }

    private boolean isVMMinimumVersion(String javaVersion, int minimumVersion) {
        int index;
        Integer version = javaVersionMap.get(javaVersion);
        if (version == null && (index = javaVersion.indexOf(46)) > 0) {
            try {
                int major = Integer.parseInt(javaVersion.substring(0, index)) * 100;
                int index2 = javaVersion.indexOf(46, ++index);
                if (index2 > 0) {
                    int minor = Integer.parseInt(javaVersion.substring(index, index2));
                    version = new Integer(major + minor);
                    javaVersionMap.put(javaVersion, version);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return version == null || version >= minimumVersion;
    }
}

