/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.helper.MemoryHelper;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.AlertMessage;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.io.gp.GPFormatException;

public class OpenFileAction
extends Action {
    public static final String NAME = "OPEN_FILE";

    public OpenFileAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        MemoryHelper memory = this.getEditor().getMemoryHelper();
        String[] filterNames = new String[]{"Suported Files (*.tg,*.gp3,*.gp4)"};
        String[] filterExtensions = new String[]{"*.tg;*.gp3;*.gp4"};
        FileChooser chooser = new FileChooser(this.getEditor(), filterNames, filterExtensions, memory.getLastChooserPath(), memory.getFileName());
        final String fileName = chooser.show(4098);
        if (fileName != null) {
            this.getEditor().getTablature().changeCursor(1);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        OpenFileAction.this.getEditor().getSongManager().open(fileName);
                    }
                    catch (FileNotFoundException e) {
                        OpenFileAction.this.showErrorMessage(fileName);
                        e.printStackTrace();
                    }
                    catch (GPFormatException e) {
                        OpenFileAction.this.showErrorMessage(fileName);
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        OpenFileAction.this.showErrorMessage(fileName);
                        e.printStackTrace();
                    }
                    OpenFileAction.this.getEditor().notifyMemoryHelper(fileName);
                    new SyncThread(OpenFileAction.this.getEditor(), new Runnable(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            OpenFileAction.access$0(1.access$0(this.this$1)).resetDefaults();
                            OpenFileAction.access$2(1.access$0(this.this$1));
                            OpenFileAction.access$0(1.access$0(this.this$1)).getTablature().changeCursor(0);
                        }
                    }).start();
                }

                static /* synthetic */ OpenFileAction access$0(1 var0) {
                    return var0.OpenFileAction.this;
                }
            }).start();
        }
        return true;
    }

    private void showErrorMessage(final String fileName) {
        new SyncThread(this.getEditor(), new Runnable(){

            public void run() {
                OpenFileAction.this.getEditor().getTablature().changeCursor(0);
                String name = "Error Message";
                String message = "Cannot Open file: " + fileName;
                new AlertMessage(OpenFileAction.this.getEditor(), name, message, 33).show();
            }
        }).start();
    }

    static /* synthetic */ void access$2(OpenFileAction openFileAction) {
        openFileAction.redraw();
    }
}

