/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TablatureEditor;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.tab.widgets.Caret;
import org.herac.tuxguitar.gui.tab.widgets.SilenceCoords;

public class RemoveNoteAction
extends Action {
    public static final String NAME = "REMOVE_NOTE";

    public RemoveNoteAction(TablatureEditor tablatureEditor) {
        super(NAME, tablatureEditor);
    }

    public boolean doAction(TypedEvent e) {
        Caret caret;
        if (e instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)e;
            if (keyEvent.keyCode != 127 && keyEvent.keyCode != 8) {
                return false;
            }
        }
        if ((caret = this.getEditor().getTablature().getCaret()).getSelectedComponent() instanceof SilenceCoords) {
            SilenceCoords silenceCoords = (SilenceCoords)caret.getSelectedComponent();
            caret.getMeasureCoords().removeSilence(silenceCoords.getSilence(), true);
        } else {
            long start = caret.getSelectedComponent().getStart();
            int string = caret.getSelectedString().getNumber();
            caret.getMeasureCoords().removeComponentsAt(start, string, true);
        }
        this.updateTablature();
        return true;
    }

    protected void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasureCoords().getMeasureId());
        this.redraw();
    }
}

