/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tab.widgets;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.TimeSignature;

public class TablatureUtil {
    public static final int getSpanForQuarter(Duration duration) {
        double span = 1000.0 / (double)duration.getTime() * (double)TablatureUtil.getMinSpan(duration);
        return (int)span;
    }

    public static final int getStartPosition(Measure measure, long start, int span) {
        double newStart = (double)start - (double)measure.getStart();
        double displayPosition = 0.0;
        if (newStart > 0.0) {
            double position = newStart / 1000.0;
            displayPosition = position * (double)span;
        }
        return (int)displayPosition;
    }

    public static List createDurations(long time) {
        ArrayList<Duration> durations = new ArrayList<Duration>();
        Duration tempDuration = new Duration(1);
        tempDuration.setDotted(true);
        long tempTime = time;
        boolean finish = false;
        while (!finish) {
            long currentDurationTime = tempDuration.getTime();
            if (currentDurationTime <= tempTime) {
                durations.add((Duration)tempDuration.clone());
                tempTime -= currentDurationTime;
            } else if (tempDuration.isDotted()) {
                tempDuration.setDotted(false);
            } else {
                tempDuration.setValue(tempDuration.getValue() * 2);
                tempDuration.setDotted(true);
            }
            if (tempDuration.getValue() <= 64) continue;
            finish = true;
        }
        return durations;
    }

    private static final int getMinSpan(Duration duration) {
        int minSpan = 0;
        switch (duration.getValue()) {
            case 1: {
                minSpan = 50;
                break;
            }
            case 2: {
                minSpan = 30;
                break;
            }
            case 4: {
                minSpan = 25;
                break;
            }
            case 8: {
                minSpan = 20;
                break;
            }
            default: {
                minSpan = 15;
            }
        }
        return minSpan;
    }

    public static long getBeatLength(TimeSignature timeSignature) {
        long defaultLenght = 1000L;
        int denominator = timeSignature.getDenominator().getValue();
        switch (denominator) {
            case 8: {
                if (timeSignature.getNumerator() % 3 != 0) break;
                defaultLenght += 500L;
            }
        }
        return defaultLenght;
    }
}

