/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.undo;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.undo.CannotRedoException;
import org.herac.tuxguitar.gui.undo.CannotUndoException;
import org.herac.tuxguitar.gui.undo.UndoableEdit;

public class UndoManager {
    private static final int LIMIT = 5;
    private int indexOfNextAdd;
    private List edits;

    public UndoManager() {
        this.init();
    }

    public void discardAllEdits() {
        this.reset();
    }

    public synchronized void undo() throws CannotUndoException {
        UndoableEdit edit = this.editToBeUndone();
        if (edit == null) {
            throw new CannotUndoException();
        }
        edit.undo();
        --this.indexOfNextAdd;
    }

    public synchronized void redo() throws CannotRedoException {
        UndoableEdit edit = this.editToBeRedone();
        if (edit == null) {
            throw new CannotRedoException();
        }
        edit.redo();
        ++this.indexOfNextAdd;
    }

    public synchronized boolean canUndo() {
        boolean canUndo = false;
        UndoableEdit edit = this.editToBeUndone();
        if (edit != null) {
            canUndo = edit.canUndo();
        }
        return canUndo;
    }

    public synchronized boolean canRedo() {
        boolean canRedo = false;
        UndoableEdit edit = this.editToBeRedone();
        if (edit != null) {
            canRedo = edit.canRedo();
        }
        return canRedo;
    }

    public synchronized void addEdit(UndoableEdit anEdit) {
        this.checkForUnused();
        this.checkForLimit();
        this.edits.add(this.indexOfNextAdd, anEdit);
        ++this.indexOfNextAdd;
    }

    public boolean shift() {
        if (!this.edits.isEmpty()) {
            UndoableEdit edit = (UndoableEdit)this.edits.get(0);
            this.remove(edit);
            --this.indexOfNextAdd;
            return true;
        }
        return false;
    }

    private void checkForUnused() {
        while (this.edits.size() > this.indexOfNextAdd) {
            UndoableEdit edit = (UndoableEdit)this.edits.get(this.indexOfNextAdd);
            this.remove(edit);
        }
    }

    private void checkForLimit() {
        while (this.edits.size() >= 5) {
            UndoableEdit edit = (UndoableEdit)this.edits.get(0);
            this.remove(edit);
            --this.indexOfNextAdd;
        }
    }

    private void remove(UndoableEdit edit) {
        this.edits.remove(edit);
    }

    private UndoableEdit editToBeUndone() {
        int index = this.indexOfNextAdd - 1;
        if (index >= 0 && index < this.edits.size()) {
            return (UndoableEdit)this.edits.get(index);
        }
        return null;
    }

    private UndoableEdit editToBeRedone() {
        int index = this.indexOfNextAdd;
        if (index >= 0 && index < this.edits.size()) {
            return (UndoableEdit)this.edits.get(index);
        }
        return null;
    }

    private void init() {
        this.indexOfNextAdd = 0;
        this.edits = new ArrayList();
    }

    private void reset() {
        this.indexOfNextAdd = 0;
        this.edits.clear();
    }
}

