/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.play.models.midiplayer;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import org.herac.tuxguitar.play.models.Player;
import org.herac.tuxguitar.play.models.midiplayer.MeasureStartMetaEventListener;
import org.herac.tuxguitar.play.models.midiplayer.SongSequence;
import org.herac.tuxguitar.song.managers.SongManager;

public class SongPlayer
implements Player {
    private SongManager songManager;
    private Synthesizer synth;
    private Sequencer sequencer;
    private MeasureStartMetaEventListener controller;
    private boolean running;
    private boolean changeTickPosition;
    private long tickPosition;

    public SongPlayer(SongManager songManager) {
        this.songManager = songManager;
        this.controller = new MeasureStartMetaEventListener();
        this.init();
        this.reset();
    }

    public void init() {
        try {
            this.synth = MidiSystem.getSynthesizer();
            this.synth.open();
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
            this.sequencer.addMetaEventListener(this.controller);
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void reset() {
        if (this.sequencer.isOpen()) {
            this.stop();
        }
        this.running = false;
        this.tickPosition = 1000L;
        this.changeTickPosition = false;
        this.controller.reset();
    }

    public void close() {
        this.running = false;
        this.sequencer.close();
        this.synth.close();
    }

    public void stop() {
        if (this.sequencer != null && this.sequencer.isRunning()) {
            this.running = false;
            this.sequencer.stop();
        }
    }

    public void play() {
        try {
            this.running = true;
            this.createSecuence();
            this.sequencer.start();
            this.sequencer.setTickPosition(this.tickPosition - 500L);
            this.changeTickPosition = false;
            while (this.sequencer.isRunning()) {
                if (this.changeTickPosition) {
                    this.sequencer.setTickPosition(this.tickPosition - 500L);
                    this.changeTickPosition = false;
                }
                Thread.sleep(10L);
            }
            this.reset();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setTickPosition(long position) {
        this.tickPosition = position;
        this.changeTickPosition = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getTickPosition() {
        return this.controller.getTickPosition();
    }

    public void createSecuence() {
        SongSequence songSequence = new SongSequence(this.songManager.getSong());
        songSequence.createSongSecuence();
        try {
            this.sequencer.setSequence(songSequence.getSongSecuence());
        }
        catch (InvalidMidiDataException e) {
            this.sequencer.stop();
            this.sequencer.close();
            this.init();
            e.printStackTrace();
        }
    }
}

