/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.song.util;

import java.util.ArrayList;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Measure;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.Silence;
import org.herac.tuxguitar.song.models.Song;
import org.herac.tuxguitar.song.models.SongTrack;
import org.herac.tuxguitar.song.models.Tempo;
import org.herac.tuxguitar.song.models.TimeSignature;

public class UndoableUtil {
    public static Song cloneSong(Song song) {
        ArrayList<SongTrack> tracks = new ArrayList<SongTrack>();
        int tIdx = 0;
        while (tIdx < song.getTracks().size()) {
            SongTrack track = (SongTrack)song.getTracks().get(tIdx);
            ArrayList<Measure> measures = new ArrayList<Measure>();
            int mIdx = 0;
            while (mIdx < track.getMeasures().size()) {
                Measure measure = (Measure)track.getMeasures().get(mIdx);
                TimeSignature timeSignature = (TimeSignature)measure.getTimeSignature().clone();
                Tempo tempo = (Tempo)measure.getTempo().clone();
                ArrayList<Note> notes = new ArrayList<Note>();
                int nIdx = 0;
                while (nIdx < measure.getNotes().size()) {
                    Note note = (Note)measure.getNotes().get(nIdx);
                    notes.add((Note)note.clone());
                    ++nIdx;
                }
                ArrayList<Silence> silences = new ArrayList<Silence>();
                int sIdx = 0;
                while (sIdx < measure.getSilences().size()) {
                    Silence silence = (Silence)measure.getSilences().get(sIdx);
                    silences.add((Silence)silence.clone());
                    ++sIdx;
                }
                measures.add(new Measure(measure.getStart(), notes, silences, timeSignature, tempo, measure.isRepeatStart(), measure.getNumberOfRepetitions()));
                ++mIdx;
            }
            ArrayList<InstrumentString> strings = new ArrayList<InstrumentString>();
            int sIdx = 0;
            while (sIdx < track.getStrings().size()) {
                InstrumentString string = (InstrumentString)track.getStrings().get(sIdx);
                strings.add((InstrumentString)string.clone());
                ++sIdx;
            }
            tracks.add(new SongTrack(track.getChannel(), track.getInstrument(), measures, strings));
            ++tIdx;
        }
        return new Song(song.getName(), tracks);
    }
}

