/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.custom.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.herac.tuxguitar.gui.tools.custom.converter.TGConverterListener;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGSongExporter;
import org.herac.tuxguitar.io.base.TGSongImporter;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGSong;

public class TGConverter {
    public static final int SLEEP_TIME = 20;
    public static final int FILE_OK = 250;
    public static final int FILE_BAD = 403;
    public static final int FILE_COULDNT_WRITE = 401;
    public static final int FILE_NOT_FOUND = 404;
    public static final int OUT_OF_MEMORY = 500;
    public static final int EXPORTER_NOT_FOUND = 590;
    public static final int UNKNOWN_ERROR = 666;
    private String sourceFolder;
    private String destinationFolder;
    private String extension = null;
    private TGConverterListener listener;
    private boolean cancelled;

    public TGConverter(String string, String string2) {
        this.sourceFolder = string;
        this.destinationFolder = string2;
    }

    public void convert(String string, String string2) {
        block14: {
            try {
                this.getListener().notifyFileProcess(string2);
                TGSongManager tGSongManager = new TGSongManager();
                TGSong tGSong = null;
                try {
                    tGSong = TGFileFormatManager.instance().getLoader().load(tGSongManager.getFactory(), (InputStream)new FileInputStream(string));
                }
                catch (TGFileFormatException tGFileFormatException) {
                    tGSong = this.importSong(tGSongManager.getFactory(), string);
                }
                if (tGSong != null) {
                    tGSongManager.setSong(tGSong);
                    tGSongManager.autoCompleteSilences();
                    tGSongManager.orderBeats();
                    new File(new File(string2).getParent()).mkdirs();
                    boolean bl = false;
                    try {
                        TGFileFormatManager.instance().getWriter().write(tGSongManager.getFactory(), tGSongManager.getSong(), string2);
                    }
                    catch (TGFileFormatException tGFileFormatException) {
                        bl = true;
                    }
                    if (bl) {
                        TGSongExporter tGSongExporter = this.findExporter();
                        if (tGSongExporter == null) {
                            this.getListener().notifyFileResult(this.extension, 590);
                        } else {
                            tGSongExporter.configure(true);
                            try {
                                tGSongExporter.exportSong((OutputStream)new FileOutputStream(string2), tGSongManager.getSong());
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                this.getListener().notifyFileResult(string2, 401);
                            }
                        }
                    }
                    this.getListener().notifyFileResult(string2, 250);
                    break block14;
                }
                this.getListener().notifyFileResult(string, 403);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.getListener().notifyFileResult(string, 404);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.getListener().notifyFileResult(string2, 500);
            }
            catch (Throwable throwable) {
                this.getListener().notifyFileResult(string2, 666);
            }
        }
    }

    private String checkIfExists(String string, int n) {
        if (new File(string).exists()) {
            String string2 = string;
            String string3 = "";
            String string4 = "(" + (n + 1) + ")";
            String string5 = "(" + n + ")";
            int n2 = string.lastIndexOf(n == 0 ? "." : string5 + ".");
            if (n2 != -1) {
                string3 = string2.substring(n2 + (n == 0 ? 0 : string5.length()), string2.length());
                string2 = string2.substring(0, n2);
            }
            return this.checkIfExists(string2 + string4 + string3, n + 1);
        }
        return string;
    }

    public void process() {
        this.getListener().notifyStart();
        this.process(new File(this.sourceFolder));
        this.getListener().notifyFinish();
    }

    private void process(File file) {
        String[] stringArray;
        if (!this.isCancelled() && (stringArray = file.list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file.getPath() + "/" + stringArray[i]);
                if (file2.isDirectory()) {
                    this.process(file2);
                } else if (!this.isCancelled()) {
                    String string = file2.getAbsolutePath();
                    String string2 = this.getConvertFileName(string);
                    this.convert(string, string2);
                    this.sleep();
                }
                stringArray[i] = null;
            }
        }
    }

    private String getConvertFileName(String string) {
        String string2 = this.destinationFolder + File.separator + string.substring(this.sourceFolder.length());
        int n = string2.lastIndexOf(".");
        if (n != -1) {
            string2 = string2.substring(0, n) + this.extension;
        }
        return this.checkIfExists(new File(string2).getAbsolutePath(), 0);
    }

    private TGSongExporter findExporter() {
        Iterator iterator = TGFileFormatManager.instance().getExporters();
        String string = "*" + this.extension;
        while (iterator.hasNext()) {
            TGSongExporter tGSongExporter = (TGSongExporter)iterator.next();
            if (!tGSongExporter.getFileFormat().getSupportedFormats().startsWith(string)) continue;
            return tGSongExporter;
        }
        return null;
    }

    private TGSong importSong(TGFactory tGFactory, String string) {
        Iterator iterator = TGFileFormatManager.instance().getImporters();
        while (iterator.hasNext()) {
            TGSongImporter tGSongImporter = (TGSongImporter)iterator.next();
            try {
                tGSongImporter.configure(true);
                if (!this.isSupportedExtension(string, tGSongImporter)) continue;
                FileInputStream fileInputStream = new FileInputStream(string);
                return tGSongImporter.importSong(tGFactory, (InputStream)fileInputStream);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }

    private boolean isSupportedExtension(String string, TGSongImporter tGSongImporter) {
        try {
            String string2 = string.substring(string.lastIndexOf("."), string.length());
            string2 = "*" + string2.toLowerCase();
            String[] stringArray = tGSongImporter.getFileFormat().getSupportedFormats().split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].toLowerCase().equals(string2)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    private void sleep() {
        try {
            Thread.sleep(20L);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String string) {
        this.extension = string;
    }

    public TGConverterListener getListener() {
        return this.listener;
    }

    public void setListener(TGConverterListener tGConverterListener) {
        this.listener = tGConverterListener;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }
}

