/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.coreaudio;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.herac.tuxguitar.player.base.MidiOut;
import org.herac.tuxguitar.player.impl.midiport.coreaudio.MidiPortImpl;
import org.herac.tuxguitar.player.impl.midiport.coreaudio.MidiReceiverJNI;

public class MidiOutImpl
extends MidiReceiverJNI
implements MidiOut {
    private boolean open;
    private boolean connected = false;
    private List ports = new ArrayList();

    public void open() {
        super.open();
        this.open = true;
    }

    public void close() {
        if (this.isOpen()) {
            this.disconnect();
            super.close();
            this.open = false;
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isConnected() {
        return this.isOpen() && this.connected;
    }

    public void connect() {
        if (this.isOpen() && !this.isConnected()) {
            this.connected = true;
            this.openDevice();
        }
    }

    public void disconnect() {
        if (this.isConnected()) {
            this.closeDevice();
            this.connected = false;
        }
    }

    public List listPorts() {
        if (this.isOpen()) {
            this.ports.clear();
            this.ports.add(new MidiPortImpl(this, "Core Audio midi playback", "coreaudio"));
            return this.ports;
        }
        return Collections.EMPTY_LIST;
    }

    public void sendSystemReset() {
        if (this.isOpen()) {
            // empty if block
        }
    }

    public void sendAllNotesOff() {
        for (int i = 0; i < 16; ++i) {
            this.sendControlChange(i, 123, 0);
        }
    }

    public void sendControlChange(int n, int n2, int n3) {
        if (this.isOpen()) {
            super.controlChange(n, n2, n3);
        }
    }

    public void sendNoteOff(int n, int n2, int n3) {
        if (this.isOpen()) {
            super.noteOff(n, n2, n3);
        }
    }

    public void sendNoteOn(int n, int n2, int n3) {
        if (this.isOpen()) {
            super.noteOn(n, n2, n3);
        }
    }

    public void sendPitchBend(int n, int n2) {
        if (this.isOpen()) {
            super.pitchBend(n, n2);
        }
    }

    public void sendProgramChange(int n, int n2) {
        if (this.isOpen()) {
            super.programChange(n, n2);
        }
    }
}

