/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.carbon.ATSFontMetrics;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.ControlFontStyleRec;
import org.eclipse.swt.internal.carbon.HIThemeFrameDrawInfo;
import org.eclipse.swt.internal.carbon.HIThemeTextInfo;
import org.eclipse.swt.internal.carbon.HMHelpContentRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    public int handle;
    Composite parent;
    String toolTipText;
    Object layoutData;
    int drawCount;
    int visibleRgn;
    Menu menu;
    float[] foreground;
    float[] background;
    Image backgroundImage;
    Font font;
    Cursor cursor;
    Region region;
    GCData[] gcs;
    Accessible accessible;
    static final String RESET_VISIBLE_REGION = "org.eclipse.swt.internal.resetVisibleRegion";

    Control() {
    }

    public Control(Composite composite, int n) {
        super(composite, n);
        this.parent = composite;
        this.createWidget();
    }

    int actionProc(int n, int n2) {
        int n3 = super.actionProc(n, n2);
        if (n3 == 0) {
            return n3;
        }
        if (this.isDisposed()) {
            return 0;
        }
        this.sendTrackEvents();
        return n3;
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(dragDetectListener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(focusListener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseListener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseTrackListener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseMoveListener);
        this.addListener(5, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseWheelListener);
        this.addListener(37, typedListener);
    }

    void addRelation(Control control) {
    }

    public void addPaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(paintListener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(traverseListener);
        this.addListener(31, typedListener);
    }

    int colorProc(int n, int n2, int n3, int n4) {
        switch (n2) {
            case 30: {
                if (this.foreground != null) {
                    OS.RGBForeColor(this.toRGBColor(this.foreground));
                } else {
                    OS.SetThemeTextColor((short)1, (short)n3, n4 != 0);
                }
                return 0;
            }
            case 23: {
                float[] fArray;
                float[] fArray2 = fArray = this.background != null ? this.background : this.getParentBackground();
                if (fArray != null) {
                    OS.RGBBackColor(this.toRGBColor(fArray));
                } else {
                    OS.SetThemeBackground((short)1, (short)n3, n4 != 0);
                }
                return 0;
            }
        }
        return -9874;
    }

    int callFocusEventHandler(int n, int n2) {
        return OS.CallNextEventHandler(n, n2);
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFFFBFF;
        Composite composite = this.parent;
        while (true) {
            int n;
            if ((n = composite.backgroundMode) != 0) {
                if (n == 1) {
                    Control control = this;
                    do {
                        if ((control.state & 0x800) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x400;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkBuffered() {
        this.style |= 0x20000000;
    }

    public org.eclipse.swt.graphics.Point computeSize(int n, int n2) {
        return this.computeSize(n, n2, true);
    }

    public org.eclipse.swt.graphics.Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 64;
        int n4 = 64;
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n5 = this.getBorderWidth();
        return new org.eclipse.swt.graphics.Point(n3 += n5 * 2, n4 += n5 * 2);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    Control computeTabRoot() {
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            int n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) break;
                ++n;
            }
            if (n == controlArray.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    boolean contains(String[] stringArray, String string) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void createWidget() {
        this.state |= 0x40000;
        this.checkOrientation(this.parent);
        super.createWidget();
        this.checkBackground();
        this.checkBuffered();
        this.setDefaultFont();
        this.setZOrder();
        this.setRelations();
    }

    Color defaultBackground() {
        return this.display.getSystemColor(22);
    }

    Font defaultFont() {
        byte[] byArray = new byte[256];
        short[] sArray = new short[1];
        byte[] byArray2 = new byte[1];
        OS.GetThemeFont((short)this.defaultThemeFont(), (short)-1, byArray, sArray, byArray2);
        short s = OS.FMGetFontFamilyFromName(byArray);
        int[] nArray = new int[1];
        OS.FMGetFontFromFontFamilyInstance(s, byArray2[0], nArray, null);
        return Font.carbon_new(this.display, OS.FMGetATSFontRefFromFont(nArray[0]), byArray2[0], sArray[0]);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(21);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 0;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        Display display = this.display;
        int n = this.topHandle();
        this.releaseHandle();
        if (n != 0) {
            if (display.delayDispose) {
                display.addToDisposeWindow(n);
            } else {
                OS.DisposeControl(n);
            }
        }
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent mouseEvent) {
        this.checkWidget();
        if (mouseEvent == null) {
            this.error(4);
        }
        return this.dragDetect(mouseEvent.button, mouseEvent.count, mouseEvent.stateMask, mouseEvent.x, mouseEvent.y);
    }

    boolean dragDetect(int n, int n2, int n3, int n4, int n5) {
        if (n != 1 || n2 != 1) {
            return false;
        }
        if (!this.dragDetect(n4, n5, false, null)) {
            return false;
        }
        return this.sendDragEvent(n, n3, n4, n5);
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        Rect rect = new Rect();
        int n3 = OS.GetControlOwner(this.handle);
        CGPoint cGPoint = new CGPoint();
        OS.HIViewConvertPoint(cGPoint, this.handle, 0);
        n += (int)cGPoint.x;
        n2 += (int)cGPoint.y;
        OS.GetWindowBounds(n3, (short)32, rect);
        Point point = new Point();
        point.h = (short)(n += rect.left);
        point.v = (short)(n2 += rect.top);
        return OS.WaitMouseMoved(point);
    }

    void drawFocus(int n, int n2, boolean bl, boolean bl2, boolean bl3, Rect rect) {
        int n3;
        if (bl3) {
            this.fillBackground(n, n2, null);
        }
        CGRect cGRect = new CGRect();
        OS.HIViewGetBounds(n, cGRect);
        cGRect.x += (float)rect.left;
        cGRect.y += (float)rect.top;
        cGRect.width -= (float)(rect.right + rect.left);
        cGRect.height -= (float)(rect.bottom + rect.top);
        if (OS.IsControlEnabled(n)) {
            n3 = OS.IsControlActive(n) ? 1 : 0;
        } else {
            int n4 = n3 = OS.IsControlActive(n) ? 7 : 8;
        }
        if (bl2) {
            HIThemeFrameDrawInfo hIThemeFrameDrawInfo = new HIThemeFrameDrawInfo();
            hIThemeFrameDrawInfo.state = n3;
            hIThemeFrameDrawInfo.kind = 0;
            hIThemeFrameDrawInfo.isFocused = bl;
            OS.HIThemeDrawFrame(cGRect, hIThemeFrameDrawInfo, n2, 0);
        } else {
            OS.HIThemeDrawFocusRect(cGRect, bl, n2, 0);
        }
    }

    boolean drawFocusRing() {
        return this.hasBorder();
    }

    boolean drawGripper(int n, int n2, int n3, int n4, boolean bl) {
        return false;
    }

    void drawWidget(int n, int n2, int n3, int n4, int n5) {
        if (n != this.handle) {
            return;
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return;
        }
        Rect rect = new Rect();
        OS.GetRegionBounds(n4, rect);
        int[] nArray = new int[1];
        OS.GetPort(nArray);
        GCData gCData = new GCData();
        gCData.port = nArray[0];
        gCData.paintEvent = n5;
        gCData.visibleRgn = n4;
        GC gC = GC.carbon_new(this, gCData);
        Event event = new Event();
        event.gc = gC;
        event.x = rect.left;
        event.y = rect.top;
        event.width = rect.right - rect.left;
        event.height = rect.bottom - rect.top;
        this.sendEvent(9, event);
        event.gc = null;
        gC.dispose();
    }

    void enableWidget(boolean bl) {
        int n = this.topHandle();
        if (bl) {
            OS.EnableControl(n);
        } else {
            OS.DisableControl(n);
        }
    }

    boolean equals(float[] fArray, float[] fArray2) {
        if (fArray == fArray2) {
            return true;
        }
        if (fArray == null) {
            return fArray2 == null;
        }
        if (fArray2 == null) {
            return fArray == null;
        }
        int n = 0;
        while (n < fArray.length) {
            if (fArray[n] != fArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    void fillBackground(int n, int n2, Rectangle rectangle) {
        OS.CGContextSaveGState(n2);
        CGRect cGRect = new CGRect();
        if (rectangle != null) {
            cGRect.x = rectangle.x;
            cGRect.y = rectangle.y;
            cGRect.width = rectangle.width;
            cGRect.height = rectangle.height;
        } else {
            OS.HIViewGetBounds(n, cGRect);
        }
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage != null) {
            CGPoint cGPoint = new CGPoint();
            OS.HIViewConvertPoint(cGPoint, n, control.handle);
            OS.CGContextTranslateCTM(n2, -cGPoint.x, -cGPoint.y);
            Pattern pattern = new Pattern(this.display, control.backgroundImage);
            GCData gCData = new GCData();
            gCData.device = this.display;
            gCData.background = control.getBackgroundColor().handle;
            GC gC = GC.carbon_new(n2, gCData);
            gC.setBackgroundPattern(pattern);
            gC.fillRectangle((int)(cGRect.x + cGPoint.x), (int)(cGRect.y + cGPoint.y), (int)cGRect.width, (int)cGRect.height);
            gC.dispose();
            pattern.dispose();
        } else if (control != null && control.background != null) {
            int n3 = OS.CGColorSpaceCreateDeviceRGB();
            OS.CGContextSetFillColorSpace(n2, n3);
            OS.CGContextSetFillColor(n2, control.background);
            OS.CGColorSpaceRelease(n3);
            OS.CGContextSetAlpha(n2, this.getThemeAlpha());
            OS.CGContextFillRect(n2, cGRect);
        } else if (OS.VERSION >= 4160) {
            OS.HIThemeSetFill(1, 0, n2, 0);
            OS.CGContextSetAlpha(n2, this.getThemeAlpha());
            OS.CGContextFillRect(n2, cGRect);
        } else {
            Rect rect = new Rect();
            rect.left = (short)cGRect.x;
            rect.top = (short)cGRect.y;
            rect.right = (short)(cGRect.x + cGRect.width);
            rect.bottom = (short)(cGRect.y + cGRect.height);
            OS.SetThemeBackground((short)1, (short)0, true);
            OS.EraseRect(rect);
        }
        OS.CGContextRestoreGState(n2);
    }

    Cursor findCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.parent.findCursor();
    }

    Control findBackgroundControl() {
        if (this.backgroundImage != null || this.background != null) {
            return this;
        }
        return (this.state & 0x400) != 0 ? this.parent.findBackgroundControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        shell2.fixShell(shell, this);
        decorations2.fixDecorations(decorations, this, menuArray);
    }

    void fixFocus(Control control) {
        Shell shell = this.getShell();
        Control control2 = this;
        while (control2 != shell && (control2 = control2.parent) != null) {
            if (!control2.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(control);
        int n = OS.GetControlOwner(this.handle);
        OS.ClearKeyboardFocus(n);
    }

    int focusHandle() {
        return this.handle;
    }

    int focusPart() {
        return -1;
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Decorations decorations = this.menuShell();
        decorations.setSavedFocus(this);
        if (!this.isEnabled() || !this.isVisible()) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        decorations.setSavedFocus(null);
        decorations.bringToTop(false);
        if (this.isDisposed()) {
            return false;
        }
        int n = this.focusHandle();
        int n2 = OS.GetControlOwner(n);
        Control control = this.display.getFocusControl(n2, true);
        if (control == this) {
            return true;
        }
        this.display.ignoreFocus = true;
        OS.SetKeyboardFocus(n2, n, (short)this.focusPart());
        this.display.ignoreFocus = false;
        Control control2 = this.display.getFocusControl();
        if (control != control2) {
            if (control != null && !control.isDisposed()) {
                control.sendFocusEvent(16, false);
            }
            if (control2 != null && !control2.isDisposed() && control2.isEnabled()) {
                control2.sendFocusEvent(15, false);
            }
        }
        if (this.isDisposed()) {
            return false;
        }
        decorations.setSavedFocus(this);
        return this.hasFocus();
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return this.accessible;
    }

    String[] getAxAttributes() {
        return null;
    }

    public Color getBackground() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.getBackgroundColor();
    }

    Color getBackgroundColor() {
        return this.background != null ? Color.carbon_new(this.display, this.background) : this.defaultBackground();
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    public int getBorderWidth() {
        this.checkWidget();
        return 0;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.getControlBounds(this.topHandle());
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x40000) != 0;
    }

    int getDrawCount(int n) {
        if (!this.isTrimHandle(n) && this.drawCount > 0) {
            return this.drawCount;
        }
        return this.parent.getDrawCount(n);
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.defaultFont();
    }

    public Color getForeground() {
        this.checkWidget();
        return this.getForegroundColor();
    }

    Color getForegroundColor() {
        return this.foreground != null ? Color.carbon_new(this.display, this.foreground) : this.defaultForeground();
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public org.eclipse.swt.graphics.Point getLocation() {
        this.checkWidget();
        Rectangle rectangle = this.getControlBounds(this.topHandle());
        return new org.eclipse.swt.graphics.Point(rectangle.x, rectangle.y);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    int getMininumHeight() {
        return 0;
    }

    public Monitor getMonitor() {
        int n;
        this.checkWidget();
        Monitor[] monitorArray = this.display.getMonitors();
        if (monitorArray.length == 1) {
            return monitorArray[0];
        }
        int n2 = -1;
        int n3 = -1;
        Rectangle rectangle = this.getBounds();
        if (this != this.getShell()) {
            rectangle = this.display.map((Control)this.parent, null, rectangle);
        }
        int n4 = 0;
        while (n4 < monitorArray.length) {
            Rectangle rectangle2 = rectangle.intersection(monitorArray[n4].getBounds());
            n = rectangle2.width * rectangle2.height;
            if (n > 0 && n > n3) {
                n2 = n4;
                n3 = n;
            }
            ++n4;
        }
        if (n2 >= 0) {
            return monitorArray[n2];
        }
        n4 = rectangle.x + rectangle.width / 2;
        int n5 = rectangle.y + rectangle.height / 2;
        n = 0;
        while (n < monitorArray.length) {
            int n6;
            Rectangle rectangle3 = monitorArray[n].getBounds();
            int n7 = n4 < rectangle3.x ? rectangle3.x - n4 : (n6 = n4 > rectangle3.x + rectangle3.width ? n4 - rectangle3.x - rectangle3.width : 0);
            int n8 = n5 < rectangle3.y ? rectangle3.y - n5 : (n5 > rectangle3.y + rectangle3.height ? n5 - rectangle3.y - rectangle3.height : 0);
            int n9 = n6 * n6 + n8 * n8;
            if (n2 == -1 || n9 < n3) {
                n2 = n;
                n3 = n9;
            }
            ++n;
        }
        return monitorArray[n2];
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    float[] getParentBackground() {
        return this.parent.background;
    }

    Control[] getPath() {
        int n = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++n;
            control = control.parent;
        }
        control = this;
        Control[] controlArray = new Control[n];
        while (control != shell) {
            controlArray[--n] = control;
            control = control.parent;
        }
        return controlArray;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public org.eclipse.swt.graphics.Point getSize() {
        this.checkWidget();
        return this.getControlSize(this.topHandle());
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    float getThemeAlpha() {
        return 1.0f * this.parent.getThemeAlpha();
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    int getVisibleRegion(int n, boolean bl) {
        if (!bl) {
            return super.getVisibleRegion(n, bl);
        }
        if (this.visibleRgn == 0) {
            this.visibleRgn = OS.NewRgn();
            this.calculateVisibleRegion(n, this.visibleRgn, bl);
        }
        int n2 = OS.NewRgn();
        OS.CopyRgn(this.visibleRgn, n2);
        return n2;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    boolean hasFocus() {
        return this == this.display.getFocusControl();
    }

    int helpProc(int n, int n2, int n3, int n4, int n5) {
        switch (n3) {
            case 0: {
                short[] sArray = new short[]{-2};
                if (this.toolTipText != null && this.toolTipText.length() != 0) {
                    char[] cArray = new char[this.toolTipText.length()];
                    this.toolTipText.getChars(0, cArray.length, cArray, 0);
                    int n6 = this.fixMnemonic(cArray);
                    if (this.display.helpString != 0) {
                        OS.CFRelease(this.display.helpString);
                    }
                    this.display.helpString = OS.CFStringCreateWithCharacters(0, cArray, n6);
                    HMHelpContentRec hMHelpContentRec = new HMHelpContentRec();
                    OS.memmove(hMHelpContentRec, n5, 534);
                    hMHelpContentRec.version = 3;
                    int n7 = 16;
                    hMHelpContentRec.tagSide = (short)23;
                    Point point = new Point();
                    OS.memmove(point, new int[]{n2}, 4);
                    int n8 = point.h;
                    int n9 = point.v;
                    if (this.display.helpWidget != this) {
                        this.display.lastHelpX = n8 + n7 / 2;
                        this.display.lastHelpY = n9 + n7 + n7 / 2;
                    }
                    int n10 = 4;
                    int n11 = Math.abs(this.display.lastHelpX - n8) + n10;
                    int n12 = Math.abs(this.display.lastHelpY - n9) + n10;
                    n8 = this.display.lastHelpX - n11;
                    n9 = this.display.lastHelpY - n12;
                    int n13 = n11 * 2;
                    int n14 = n12 * 2;
                    this.display.helpWidget = this;
                    hMHelpContentRec.absHotRect_left = (short)n8;
                    hMHelpContentRec.absHotRect_top = (short)n9;
                    hMHelpContentRec.absHotRect_right = (short)(n8 + n13);
                    hMHelpContentRec.absHotRect_bottom = (short)(n9 + n14);
                    hMHelpContentRec.content0_contentType = 1667658612;
                    hMHelpContentRec.content0_tagCFString = this.display.helpString;
                    hMHelpContentRec.content1_contentType = 1667658612;
                    hMHelpContentRec.content1_tagCFString = this.display.helpString;
                    OS.memmove(n5, hMHelpContentRec, 534);
                    sArray[0] = 0;
                }
                OS.memmove(n4, sArray, 2);
                break;
            }
            case 1: {
                if (this.display.helpString != 0) {
                    OS.CFRelease(this.display.helpString);
                }
                this.display.helpWidget = null;
                this.display.helpString = 0;
            }
        }
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.controlProc;
        int[] nArray = new int[]{1668183148, 9, 1668183148, 5, 1668183148, 154, 1668183148, 13, 1668183148, 12, 1668183148, 10, 1668183148, 4, 1668183148, 17, 1668183148, 8, 1668183148, 101, 1668183148, 1, 1668183148, 3, 1668183148, 11, 1668183148, 7, 1668183148, 51};
        int n2 = OS.GetControlEventTarget(this.handle);
        OS.InstallEventHandler(n2, n, nArray.length / 2, nArray, this.handle, null);
        int n3 = this.display.accessibilityProc;
        nArray = new int[]{1633903461, 1, 1633903461, 2, 1633903461, 21, 1633903461, 22};
        OS.InstallEventHandler(n2, n3, nArray.length / 2, nArray, this.handle, null);
        int n4 = this.display.helpProc;
        OS.HMInstallControlContentCallback(this.handle, n4);
        int n5 = this.display.colorProc;
        OS.SetControlColorProc(this.handle, n5);
        if (OS.GetControlAction(this.handle) == 0) {
            OS.SetControlAction(this.handle, this.display.actionProc);
        }
    }

    public int internal_new_GC(GCData gCData) {
        int n;
        Object object;
        boolean bl;
        int n2;
        this.checkWidget();
        int n3 = OS.GetControlOwner(this.handle);
        int n4 = n2 = gCData != null ? gCData.port : 0;
        if (n2 == 0) {
            n2 = OS.GetWindowPort(n3);
        }
        int[] nArray = new int[1];
        boolean bl2 = bl = gCData != null && gCData.paintEvent != 0;
        if (bl) {
            OS.GetEventParameter(gCData.paintEvent, 1668183160, 1668183160, null, 4, null, nArray);
        } else {
            OS.CreateCGContextForPort(n2, nArray);
        }
        int n5 = nArray[0];
        if (n5 == 0) {
            SWT.error(2);
        }
        int n6 = 0;
        n6 = gCData != null && gCData.paintEvent != 0 ? gCData.visibleRgn : (this.getDrawCount(this.handle) > 0 ? OS.NewRgn() : this.getVisibleRegion(this.handle, true));
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        OS.GetControlBounds(this.handle, rect);
        OS.GetPortBounds(n2, rect2);
        if (bl) {
            rect.right = (short)(rect.right + rect.left);
            rect.bottom = (short)(rect.bottom + rect.top);
            rect.top = 0;
            rect.left = 0;
        } else {
            int[] nArray2 = new int[1];
            OS.HIViewFindByID(OS.HIViewGetRoot(n3), OS.kHIViewWindowContentID(), nArray2);
            object = new CGPoint();
            OS.HIViewConvertPoint((CGPoint)object, OS.HIViewGetSuperview(this.handle), nArray2[0]);
            rect.left = (short)(rect.left + (int)((CGPoint)object).x);
            rect.top = (short)(rect.top + (int)((CGPoint)object).y);
            rect.right = (short)(rect.right + (int)((CGPoint)object).x);
            rect.bottom = (short)(rect.bottom + (int)((CGPoint)object).y);
            OS.ClipCGContextToRegion(n5, rect2, n6);
            n = rect2.bottom - rect2.top;
            OS.CGContextScaleCTM(n5, 1.0f, -1.0f);
            OS.CGContextTranslateCTM(n5, rect.left, -n + rect.top);
        }
        if (gCData != null) {
            int n7 = 0x6000000;
            if ((gCData.style & n7) == 0) {
                gCData.style |= this.style & (n7 | 0x8000000);
            }
            gCData.device = this.display;
            gCData.thread = this.display.thread;
            gCData.foreground = this.getForegroundColor().handle;
            object = this.findBackgroundControl();
            if (object == null) {
                object = this;
            }
            gCData.background = ((Control)object).getBackgroundColor().handle;
            gCData.font = this.font != null ? this.font : this.defaultFont();
            gCData.visibleRgn = n6;
            gCData.control = this.handle;
            gCData.portRect = rect2;
            gCData.controlRect = rect;
            gCData.insetRect = this.getInset();
            if (gCData.paintEvent == 0) {
                if (this.gcs == null) {
                    this.gcs = new GCData[4];
                }
                n = 0;
                while (n < this.gcs.length && this.gcs[n] != null) {
                    ++n;
                }
                if (n == this.gcs.length) {
                    GCData[] gCDataArray = new GCData[this.gcs.length + 4];
                    System.arraycopy(this.gcs, 0, gCDataArray, 0, this.gcs.length);
                    this.gcs = gCDataArray;
                }
                this.gcs[n] = gCData;
            }
        }
        return n5;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        this.checkWidget();
        if (gCData != null) {
            if (gCData.paintEvent == 0) {
                if (gCData.visibleRgn != 0) {
                    OS.DisposeRgn(gCData.visibleRgn);
                    gCData.visibleRgn = 0;
                }
                int n2 = 0;
                while (n2 < this.gcs.length && this.gcs[n2] != gCData) {
                    ++n2;
                }
                if (n2 < this.gcs.length) {
                    this.gcs[n2] = null;
                    n2 = 0;
                    while (n2 < this.gcs.length && this.gcs[n2] == null) {
                        ++n2;
                    }
                    if (n2 == this.gcs.length) {
                        this.gcs = null;
                    }
                }
            } else {
                return;
            }
        }
        OS.CGContextSynchronize(n);
        OS.CGContextRelease(n);
    }

    void invalidateChildrenVisibleRegion(int n) {
    }

    void invalidateVisibleRegion(int n) {
        int n2 = 0;
        Control[] controlArray = this.parent._getChildren();
        while (n2 < controlArray.length && controlArray[n2] != this) {
            ++n2;
        }
        int n3 = n2;
        while (n3 < controlArray.length) {
            Control control = controlArray[n3];
            control.resetVisibleRegion(n);
            control.invalidateChildrenVisibleRegion(n);
            ++n3;
        }
        this.parent.resetVisibleRegion(n);
    }

    void invalWindowRgn(int n, int n2) {
        this.parent.invalWindowRgn(n, n2);
    }

    boolean isDescribedByLabel() {
        return true;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isEnabledCursor() {
        return this.isEnabled();
    }

    boolean isEnabledModal() {
        Shell[] shellArray = this.display.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (shell != this && shell.isVisible()) {
                Shell shell2;
                if ((shell.style & 0x8000) != 0 && shell.parent == (shell2 = this.getShell())) {
                    return false;
                }
                int n2 = 196608;
                if ((shell.style & n2) != 0) {
                    Control control = this;
                    while (control != null) {
                        if (control == shell) break;
                        control = control.parent;
                    }
                    if (control != shell) {
                        return false;
                    }
                }
            }
            ++n;
        }
        return true;
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        Control control = this.display.focusControl;
        if (control != null && !control.isDisposed()) {
            return this == control;
        }
        return this.hasFocus();
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            org.eclipse.swt.graphics.Point point = control.getSize();
            if (point.x == 0 || point.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) {
                    return true;
                }
                ++n;
            }
        }
        if (((n = this.traversalCode(0, 0)) & 0x60) != 0) {
            return false;
        }
        return (n & 0x18) != 0;
    }

    boolean isTabItem() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) {
                    return false;
                }
                ++n;
            }
        }
        return ((n = this.traversalCode(0, 0)) & 0x60) != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    int kEventAccessibleGetChildAtPoint(int n, int n2, int n3) {
        if (this.accessible != null) {
            return this.accessible.internal_kEventAccessibleGetChildAtPoint(n, n2, n3);
        }
        return -9874;
    }

    int kEventAccessibleGetFocusedChild(int n, int n2, int n3) {
        if (this.accessible != null) {
            return this.accessible.internal_kEventAccessibleGetFocusedChild(n, n2, n3);
        }
        return -9874;
    }

    int kEventAccessibleGetAllAttributeNames(int n, int n2, int n3) {
        int n4 = -9874;
        String[] stringArray = this.getAxAttributes();
        if (stringArray != null) {
            OS.CallNextEventHandler(n, n2);
            int[] nArray = new int[1];
            OS.GetEventParameter(n2, 1635020403, 1667657057, null, 4, null, nArray);
            int n5 = nArray[0];
            int n6 = OS.CFArrayGetCount(n5);
            String[] stringArray2 = new String[n6];
            int n7 = 0;
            while (n7 < n6) {
                int n8 = OS.CFArrayGetValueAtIndex(n5, n7);
                int n9 = OS.CFStringGetLength(n8);
                char[] cArray = new char[n9];
                CFRange cFRange = new CFRange();
                cFRange.length = n9;
                OS.CFStringGetCharacters(n8, cFRange, cArray);
                stringArray2[n7] = new String(cArray);
                ++n7;
            }
            n7 = 0;
            while (n7 < stringArray.length) {
                if (!this.contains(stringArray2, stringArray[n7])) {
                    String string = stringArray[n7];
                    char[] cArray = new char[string.length()];
                    string.getChars(0, cArray.length, cArray, 0);
                    int n10 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                    OS.CFArrayAppendValue(n5, n10);
                    OS.CFRelease(n10);
                }
                ++n7;
            }
            n4 = 0;
        }
        if (this.accessible != null) {
            n4 = this.accessible.internal_kEventAccessibleGetAllAttributeNames(n, n2, n4);
        }
        return n4;
    }

    int kEventAccessibleGetNamedAttribute(int n, int n2, int n3) {
        if (this.accessible != null) {
            return this.accessible.internal_kEventAccessibleGetNamedAttribute(n, n2, -9874);
        }
        return -9874;
    }

    int kEventControlContextualMenuClick(int n, int n2, int n3) {
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 0x2D2D2D2D, 1668575852, null, 4, null, nArray);
        Widget widget = this.display.getWidget(nArray[0]);
        while (widget != null && !(widget instanceof Control)) {
            OS.GetSuperControl(nArray[0], nArray);
            widget = this.display.getWidget(nArray[0]);
        }
        if (widget == this && this.isEnabled()) {
            Rect rect = new Rect();
            int n4 = OS.GetControlOwner(this.handle);
            CGPoint cGPoint = new CGPoint();
            OS.GetEventParameter(n2, 2003660661, 1751740532, null, 8, null, cGPoint);
            int n5 = (int)cGPoint.x;
            int n6 = (int)cGPoint.y;
            OS.GetWindowBounds(n4, (short)32, rect);
            Event event = new Event();
            event.x = n5 += rect.left;
            event.y = n6 += rect.top;
            this.sendEvent(35, event);
            if (event.doit && this.menu != null && !this.menu.isDisposed()) {
                if (event.x != n5 || event.y != n6) {
                    this.menu.setLocation(event.x, event.y);
                }
                this.menu.setVisible(true);
            }
        }
        return -9874;
    }

    int kEventControlGetClickActivation(int n, int n2, int n3) {
        if ((this.getShell().style & 0x4000) != 0) {
            OS.SetEventParameter(n2, 1668047203, 1668047203, 4, new int[]{3});
            return 0;
        }
        return super.kEventControlGetClickActivation(n, n2, n3);
    }

    int kEventControlGetPartRegion(int n, int n2, int n3) {
        int n4 = super.kEventControlGetPartRegion(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if (this.region != null && this != this.getShell()) {
            short[] sArray = new short[1];
            OS.GetEventParameter(n2, 1668313716, 1668313716, null, 2, null, sArray);
            if (sArray[0] == -1 || sArray[0] == -4) {
                int[] nArray = new int[1];
                OS.GetEventParameter(n2, 1668441966, 1919381096, null, 4, null, nArray);
                OS.CopyRgn(this.region.handle, nArray[0]);
                Rect rect = this.getInset();
                OS.OffsetRgn(nArray[0], -rect.left, -rect.top);
                return 0;
            }
        }
        return n4;
    }

    int kEventControlHitTest(int n, int n2, int n3) {
        Object object;
        int n4 = super.kEventControlHitTest(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if (this.region != null && this != this.getShell()) {
            n4 = OS.CallNextEventHandler(n, n2);
            object = new CGPoint();
            OS.GetEventParameter(n2, 1835822947, 1751740532, null, 8, null, (CGPoint)object);
            if (!this.region.contains((int)((CGPoint)object).x, (int)((CGPoint)object).y)) {
                OS.SetEventParameter(n2, 1668313716, 1668313716, 2, new short[1]);
                return n4;
            }
        }
        if ((this.state & 0x20) != 0) {
            object = new CGRect();
            OS.HIViewGetBounds(this.handle, (CGRect)object);
            CGPoint cGPoint = new CGPoint();
            OS.GetEventParameter(n2, 1835822947, 1751740532, null, 8, null, cGPoint);
            if (OS.CGRectContainsPoint((CGRect)object, cGPoint) != 0) {
                OS.SetEventParameter(n2, 1668313716, 1668313716, 2, new short[]{1});
            }
            return 0;
        }
        return n4;
    }

    int kEventControlSetCursor(int n, int n2, int n3) {
        if (!this.isEnabledCursor()) {
            return 0;
        }
        Cursor cursor = null;
        if (this.isEnabledModal() && (cursor = this.findCursor()) != null) {
            this.display.setCursor(cursor.handle);
        }
        return cursor != null ? 0 : -9874;
    }

    int kEventControlSetFocusPart(int n, int n2, int n3) {
        this.display.focusCombo = null;
        int n4 = this.callFocusEventHandler(n, n2);
        if (!this.display.ignoreFocus && n4 == 0) {
            int n5 = OS.GetControlOwner(this.handle);
            if (n5 == OS.GetUserFocusWindow()) {
                int n6 = this.focusHandle();
                int[] nArray = new int[1];
                OS.GetKeyboardFocus(n5, nArray);
                short[] sArray = new short[1];
                OS.GetEventParameter(n2, 1668313716, 1668313716, null, 2, null, sArray);
                Display display = this.display;
                display.delayDispose = true;
                if (sArray[0] == 0) {
                    if (nArray[0] == n6) {
                        this.sendFocusEvent(16, false);
                    }
                } else if (nArray[0] != n6) {
                    this.sendFocusEvent(15, false);
                }
                display.delayDispose = false;
            }
            if (this.isDisposed()) {
                return 0;
            }
        }
        return n4;
    }

    int kEventControlTrack(int n, int n2, int n3) {
        Display display = this.display;
        if (this.isDisposed()) {
            return 0;
        }
        if (display.runPopups()) {
            return 0;
        }
        if (this.isDisposed()) {
            return 0;
        }
        display.lastState = OS.GetCurrentEventButtonState();
        display.lastModifiers = OS.GetCurrentEventKeyModifiers();
        display.grabControl = this;
        int n4 = 0;
        if (this.pollTrackEvent() && display.pollingTimer == 0) {
            int[] nArray = new int[1];
            int n5 = OS.GetCurrentEventLoop();
            OS.InstallEventLoopTimer(n5, 0.01, 0.01, display.pollingProc, 0, nArray);
            display.pollingTimer = n4 = nArray[0];
        }
        int n6 = super.kEventControlTrack(n, n2, n3);
        if (n4 != 0) {
            OS.RemoveEventLoopTimer(n4);
            display.pollingTimer = 0;
        }
        display.grabControl = null;
        if (this.isDisposed()) {
            return 0;
        }
        this.sendTrackEvents();
        return n6;
    }

    int kEventMouseDown(int n, int n2, int n3) {
        Shell shell = this.getShell();
        this.display.dragging = false;
        boolean[] blArray = new boolean[1];
        short[] sArray = new short[1];
        OS.GetEventParameter(n2, 1835168878, 1835168878, null, 2, null, sArray);
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1667460724, 1835100014, null, 4, null, nArray);
        if (sArray[0] == 1 && nArray[0] == 1 && (this.state & 0x40000) != 0 && this.hooks(29)) {
            CGPoint cGPoint = new CGPoint();
            OS.GetEventParameter(n2, 2003660661, 1751740532, null, 8, null, cGPoint);
            OS.HIViewConvertPoint(cGPoint, 0, this.handle);
            int n4 = (int)cGPoint.x;
            int n5 = (int)cGPoint.y;
            if (this.dragDetect(n4, n5, true, blArray)) {
                this.display.dragging = true;
                this.display.dragButton = sArray[0];
                this.display.dragX = n4;
                this.display.dragY = n5;
                int[] nArray2 = new int[1];
                OS.GetEventParameter(n2, 1667788658, 1835100014, null, 4, null, nArray2);
                this.display.dragState = nArray2[0];
                int[] nArray3 = new int[1];
                OS.GetEventParameter(n2, 1802334052, 1835100014, null, 4, null, nArray3);
                this.display.dragModifiers = nArray3[0];
            }
            if (this.isDisposed()) {
                return 0;
            }
        }
        if (!this.sendMouseEvent(3, sArray[0], this.display.clickCount, 0, false, n2)) {
            blArray[0] = true;
        }
        if (this.isDisposed()) {
            return 0;
        }
        if (this.display.clickCount == 2) {
            if (!this.sendMouseEvent(8, sArray[0], this.display.clickCount, 0, false, n2)) {
                blArray[0] = true;
            }
            if (this.isDisposed()) {
                return 0;
            }
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this);
        }
        return blArray[0] ? 0 : -9874;
    }

    int kEventMouseDragged(int n, int n2, int n3) {
        if (this.isEnabledModal()) {
            int n4;
            if (this.display.dragging) {
                this.display.dragging = false;
                this.sendDragEvent(this.display.dragButton, this.display.dragState, this.display.dragModifiers, this.display.dragX, this.display.dragY);
                if (this.isDisposed()) {
                    return 0;
                }
            }
            int n5 = n4 = this.sendMouseEvent(5, (short)0, 0, 0, false, n2) ? -9874 : 0;
            if (this.isDisposed()) {
                return 0;
            }
            return n4;
        }
        return -9874;
    }

    int kEventMouseMoved(int n, int n2, int n3) {
        if (this.isEnabledModal()) {
            return this.sendMouseEvent(5, (short)0, 0, 0, false, n2) ? -9874 : 0;
        }
        return -9874;
    }

    int kEventMouseUp(int n, int n2, int n3) {
        short[] sArray = new short[1];
        OS.GetEventParameter(n2, 1835168878, 1835168878, null, 2, null, sArray);
        return this.sendMouseEvent(4, sArray[0], this.display.clickCount, 0, false, n2) ? -9874 : 0;
    }

    int kEventMouseWheelMoved(int n, int n2, int n3) {
        Object object;
        int[] nArray;
        short[] sArray;
        if ((this.state & 0x200) != 0) {
            return -9874;
        }
        int n4 = OS.GetControlOwner(this.handle);
        if (OS.HIWindowIsDocumentModalTarget(n4, null)) {
            return 0;
        }
        int[] nArray2 = new int[1];
        OS.CreateEvent(0, 2003398244, 8, 0.0, 0, nArray2);
        if (nArray2[0] != 0) {
            sArray = new short[1];
            OS.GetEventParameter(n2, 2003853682, 2003853682, null, 2, null, sArray);
            nArray = new int[1];
            OS.GetEventParameter(n2, 1802334052, 1835100014, null, nArray.length * 4, null, nArray);
            OS.SetEventParameter(nArray2[0], 0x2D2D2D2D, 2003398244, 4, new int[]{n4});
            OS.SetEventParameter(nArray2[0], 2003853682, 2003853682, 2, sArray);
            OS.SetEventParameter(nArray2[0], 1802334052, 1835100014, 4, nArray);
            OS.SetEventParameter(nArray2[0], 1702260340, 1702261350, 4, new int[]{n2});
            OS.SendEventToEventTarget(nArray2[0], OS.GetApplicationEventTarget());
            object = new int[1];
            OS.GetEventParameter(nArray2[0], 2003657586, 2003657586, null, 4, null, (int[])object);
            OS.ReleaseEvent(nArray2[0]);
            if ((object[0] & 1) != 0 && (object[0] & 2) == 0) {
                return 0;
            }
        }
        sArray = new short[1];
        OS.GetEventParameter(n2, 1836540280, 1836540280, null, 2, null, sArray);
        nArray = new int[1];
        OS.GetEventParameter(n2, 1836541036, 1819242087, null, 4, null, nArray);
        object = this.getShell();
        Control control = this;
        while (control != null) {
            if (!control.sendMouseEvent(37, (short)0, nArray[0], 1, true, n2) || control.sendMouseWheel(sArray[0], nArray[0])) break;
            if (control == this) {
                this.state |= 0x200;
                int n5 = OS.CallNextEventHandler(n, n2);
                this.state &= 0xFFFFFDFF;
                if (n5 == 0) break;
            }
            if (control == object) break;
            control = control.parent;
        }
        return 0;
    }

    int kEventTextInputUnicodeForKeyEvent(int n, int n2, int n3) {
        Control control;
        int n4;
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1953721189, 1702261350, null, nArray.length * 4, null, nArray);
        int[] nArray2 = new int[1];
        OS.GetEventParameter(nArray[0], 1801678692, 1835100014, null, nArray2.length * 4, null, nArray2);
        boolean[] blArray = new boolean[1];
        if (this.translateTraversal(nArray2[0], nArray[0], blArray)) {
            return 0;
        }
        if (this.isDisposed()) {
            return 0;
        }
        if (nArray2[0] == 114) {
            Control control2 = this;
            while (control2 != null) {
                if (control2.hooks(28)) {
                    control2.postEvent(28);
                    break;
                }
                control2 = control2.parent;
            }
        }
        if ((n4 = this.kEventUnicodeKeyPressed(n, n2, n3)) == 0 || blArray[0]) {
            return 0;
        }
        if (!this.isDisposed() && (control = this.display.getFocusControl()) != this) {
            int n5 = OS.GetControlOwner(this.handle);
            int n6 = 0;
            if (control != null) {
                n6 = OS.GetControlOwner(control.handle);
            }
            this.display.ignoreFocus = true;
            if (n5 != n6) {
                OS.SetUserFocusWindow(n5);
            }
            OS.SetKeyboardFocus(n5, this.focusHandle(), (short)this.focusPart());
            this.display.ignoreFocus = false;
            n4 = OS.CallNextEventHandler(n, n2);
            this.display.ignoreFocus = true;
            if (n5 != n6 && n6 != 0) {
                OS.SetUserFocusWindow(n6);
            }
            if (n5 == n6 && control != null) {
                OS.SetKeyboardFocus(n5, control.focusHandle(), (short)control.focusPart());
            } else {
                OS.ClearKeyboardFocus(n5);
            }
            this.display.ignoreFocus = false;
            return 0;
        }
        return n4;
    }

    int kEventUnicodeKeyPressed(int n, int n2, int n3) {
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1953721189, 1702261350, null, nArray.length * 4, null, nArray);
        if (!this.sendKeyEvent(1, nArray[0])) {
            return 0;
        }
        return -9874;
    }

    void markLayout(boolean bl, boolean bl2) {
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, false);
    }

    Accessible new_Accessible(Control control) {
        return Accessible.internal_new_Accessible(this);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean bl) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, bl));
    }

    public boolean print(GC gC) {
        int[] nArray;
        CGRect cGRect;
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        if (OS.HIViewCreateOffscreenImage(this.handle, 0, cGRect = new CGRect(), nArray = new int[1]) == 0) {
            int n = OS.CGImageGetWidth(nArray[0]);
            int n2 = OS.CGImageGetHeight(nArray[0]);
            CGRect cGRect2 = new CGRect();
            cGRect2.width = n;
            cGRect2.height = n2;
            OS.HIViewDrawCGImage(gC.handle, cGRect2, nArray[0]);
            OS.CGImageRelease(nArray[0]);
        }
        return true;
    }

    boolean pollTrackEvent() {
        return false;
    }

    public void redraw() {
        this.checkWidget();
        this.redrawWidget(this.handle, false);
    }

    void redraw(boolean bl) {
        this.redrawWidget(this.handle, bl);
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        this.checkWidget();
        this.redrawWidget(this.handle, n, n2, n3, n4, bl);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
    }

    void release(boolean bl) {
        Control control = null;
        Control control2 = null;
        if (bl && this.parent != null) {
            Control[] controlArray = this.parent._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) break;
                ++n;
            }
            if (n > 0 && n + 1 < controlArray.length) {
                control = controlArray[n + 1];
                control2 = controlArray[n - 1];
            }
        }
        super.release(bl);
        if (bl && control2 != null) {
            control2.addRelation(control);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
        this.parent = null;
    }

    void releaseParent() {
        this.setVisible(this.topHandle(), false);
        this.parent.removeControl(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
        }
        this.visibleRgn = 0;
        this.menu = null;
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        this.region = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, dragDetectListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, focusListener);
        this.eventTable.unhook(16, focusListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, mouseListener);
        this.eventTable.unhook(4, mouseListener);
        this.eventTable.unhook(8, mouseListener);
    }

    public void removeMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, mouseMoveListener);
    }

    public void removeMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, mouseTrackListener);
        this.eventTable.unhook(7, mouseTrackListener);
        this.eventTable.unhook(32, mouseTrackListener);
    }

    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, mouseWheelListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, paintListener);
    }

    void removeRelation() {
        if (!this.isDescribedByLabel()) {
            return;
        }
        String string = "AXTitleUIElement";
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        OS.HIObjectSetAuxiliaryAccessibilityAttribute(this.handle, 0L, n, 0);
        OS.CFRelease(n);
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, traverseListener);
    }

    void resetVisibleRegion(int n) {
        Object object;
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
            this.visibleRgn = 0;
        }
        if (this.gcs != null) {
            int n2 = this.getVisibleRegion(this.handle, true);
            int n3 = 0;
            while (n3 < this.gcs.length) {
                GCData gCData = this.gcs[n3];
                if (gCData != null) {
                    gCData.updateClip = true;
                    OS.CopyRgn(n2, gCData.visibleRgn);
                }
                ++n3;
            }
            OS.DisposeRgn(n2);
        }
        if ((object = this.getData(RESET_VISIBLE_REGION)) != null && object instanceof Runnable) {
            ((Runnable)object).run();
        }
    }

    boolean sendDragEvent(int n, int n2, int n3, int n4) {
        Event event = new Event();
        event.button = n;
        event.x = n3;
        event.y = n4;
        event.stateMask = n2;
        this.postEvent(29, event);
        return event.doit;
    }

    boolean sendDragEvent(int n, int n2, int n3, int n4, int n5) {
        Event event = new Event();
        switch (n) {
            case 1: {
                event.button = 1;
                break;
            }
            case 2: {
                event.button = 3;
                break;
            }
            case 3: {
                event.button = 2;
                break;
            }
            case 4: {
                event.button = 4;
                break;
            }
            case 5: {
                event.button = 5;
            }
        }
        event.x = n4;
        event.y = n5;
        this.setInputState(event, 29, n2, n3);
        this.postEvent(29, event);
        return event.doit;
    }

    void sendFocusEvent(int n, boolean bl) {
        Display display = this.display;
        Shell shell = this.getShell();
        display.focusControl = this;
        display.focusEvent = n;
        if (bl) {
            this.postEvent(n);
        } else {
            this.sendEvent(n);
        }
        if (!shell.isDisposed()) {
            switch (n) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.getActiveShell()) break;
                    shell.setActiveControl(null);
                }
            }
        }
        display.focusEvent = 0;
        display.focusControl = null;
    }

    boolean sendMouseEvent(int n, short s, int n2, int n3, boolean bl, int n4) {
        CGPoint cGPoint = new CGPoint();
        OS.GetEventParameter(n4, 2003660661, 1751740532, null, 8, null, cGPoint);
        OS.HIViewConvertPoint(cGPoint, 0, this.handle);
        int n5 = (int)cGPoint.x;
        int n6 = (int)cGPoint.y;
        this.display.lastX = n5;
        this.display.lastY = n6;
        int[] nArray = new int[1];
        OS.GetEventParameter(n4, 1667788658, 1835100014, null, 4, null, nArray);
        int[] nArray2 = new int[1];
        OS.GetEventParameter(n4, 1802334052, 1835100014, null, 4, null, nArray2);
        return this.sendMouseEvent(n, s, n2, n3, bl, nArray[0], (short)n5, (short)n6, nArray2[0]);
    }

    boolean sendMouseEvent(int n, short s, int n2, boolean bl, int n3, short s2, short s3, int n4) {
        return this.sendMouseEvent(n, s, n2, 0, bl, n3, s2, s3, n4);
    }

    boolean sendMouseEvent(int n, short s, int n2, int n3, boolean bl, int n4, short s2, short s3, int n5) {
        if (!this.hooks(n) && !this.filters(n)) {
            return true;
        }
        if ((this.state & 0x80000) != 0) {
            switch (n) {
                case 4: 
                case 5: 
                case 8: {
                    return true;
                }
                case 3: {
                    if (s != 1) break;
                    return true;
                }
            }
        }
        Event event = new Event();
        switch (s) {
            case 1: {
                event.button = 1;
                break;
            }
            case 2: {
                event.button = 3;
                break;
            }
            case 3: {
                event.button = 2;
                break;
            }
            case 4: {
                event.button = 4;
                break;
            }
            case 5: {
                event.button = 5;
            }
        }
        event.x = s2;
        event.y = s3;
        event.count = n2;
        event.detail = n3;
        this.setInputState(event, n, n4, n5);
        if (bl) {
            this.sendEvent(n, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(n, event);
        }
        return event.doit;
    }

    boolean sendMouseWheel(short s, int n) {
        return false;
    }

    void sendTrackEvents() {
        int n;
        int n2;
        Display display = this.display;
        display.runDeferredEvents();
        if (this.isDisposed()) {
            return;
        }
        boolean bl = false;
        if (display.dragging) {
            display.dragging = false;
            this.sendDragEvent(display.dragButton, display.dragState, display.dragModifiers, display.dragX, display.dragY);
            if (this.isDisposed()) {
                return;
            }
            bl = true;
        }
        Point point = new Point();
        OS.GetGlobalMouse(point);
        Rect rect = new Rect();
        int n3 = OS.GetControlOwner(this.handle);
        CGPoint cGPoint = new CGPoint();
        cGPoint.x = point.h;
        cGPoint.y = point.v;
        OS.HIViewConvertPoint(cGPoint, 0, this.handle);
        int n4 = (int)cGPoint.x;
        int n5 = (int)cGPoint.y;
        OS.GetWindowBounds(n3, (short)32, rect);
        n4 -= rect.left;
        n5 -= rect.top;
        int n6 = OS.GetCurrentEventKeyModifiers();
        int n7 = OS.GetCurrentEventButtonState();
        int n8 = display.lastX;
        int n9 = display.lastY;
        int n10 = display.lastState;
        int n11 = display.lastModifiers;
        display.lastX = n4;
        display.lastY = n5;
        display.lastModifiers = n6;
        display.lastState = n7;
        if (n7 != n10) {
            n2 = 0;
            n = 3;
            if ((n10 & 1) == 0 && (n7 & 1) != 0) {
                n2 = 1;
            }
            if ((n10 & 2) == 0 && (n7 & 2) != 0) {
                n2 = 2;
            }
            if ((n10 & 4) == 0 && (n7 & 4) != 0) {
                n2 = 3;
            }
            if ((n10 & 8) == 0 && (n7 & 8) != 0) {
                n2 = 4;
            }
            if ((n10 & 0x10) == 0 && (n7 & 0x10) != 0) {
                n2 = 5;
            }
            if (n2 == 0) {
                n = 4;
                if ((n10 & 1) != 0 && (n7 & 1) == 0) {
                    n2 = 1;
                }
                if ((n10 & 2) != 0 && (n7 & 2) == 0) {
                    n2 = 2;
                }
                if ((n10 & 4) != 0 && (n7 & 4) == 0) {
                    n2 = 3;
                }
                if ((n10 & 8) != 0 && (n7 & 8) == 0) {
                    n2 = 4;
                }
                if ((n10 & 0x10) != 0 && (n7 & 0x10) == 0) {
                    n2 = 5;
                }
            }
            if (n2 != 0) {
                this.sendMouseEvent(n, (short)n2, 1, false, n7, (short)n4, (short)n5, n6);
                bl = true;
            }
        }
        if (n6 != n11 && !this.isDisposed()) {
            n2 = 0;
            n = 1;
            if ((n6 & 0x400) != 0 && (n11 & 0x400) == 0) {
                n2 = 16777298;
            }
            if ((n6 & 0x200) != 0 && (n11 & 0x200) == 0) {
                n2 = 131072;
            }
            if ((n6 & 0x1000) != 0 && (n11 & 0x1000) == 0) {
                n2 = 262144;
            }
            if ((n6 & 0x100) != 0 && (n11 & 0x100) == 0) {
                n2 = 0x400000;
            }
            if ((n6 & 0x800) != 0 && (n11 & 0x800) == 0) {
                n2 = 65536;
            }
            if (n2 == 0) {
                n = 2;
                if ((n6 & 0x400) == 0 && (n11 & 0x400) != 0) {
                    n2 = 16777298;
                }
                if ((n6 & 0x200) == 0 && (n11 & 0x200) != 0) {
                    n2 = 131072;
                }
                if ((n6 & 0x1000) == 0 && (n11 & 0x1000) != 0) {
                    n2 = 262144;
                }
                if ((n6 & 0x100) == 0 && (n11 & 0x100) != 0) {
                    n2 = 0x400000;
                }
                if ((n6 & 0x800) == 0 && (n11 & 0x800) != 0) {
                    n2 = 65536;
                }
            }
            if (n2 != 0) {
                Event event = new Event();
                event.keyCode = n2;
                this.setInputState(event, n, n7, n6);
                this.sendKeyEvent(n, event);
                bl = true;
            }
        }
        if (n4 != n8 || n5 != n9 && !this.isDisposed()) {
            display.mouseMoved = true;
            this.sendMouseEvent(5, (short)0, 0, false, n7, (short)n4, (short)n5, n6);
            bl = true;
        }
        if (bl) {
            display.runDeferredEvents();
        }
    }

    void setBackground() {
        this.redrawWidget(this.handle, false);
    }

    public void setBackground(Color color) {
        float[] fArray;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        float[] fArray2 = fArray = color != null ? color.handle : null;
        if (this.equals(fArray, this.background)) {
            return;
        }
        this.background = fArray;
        this.setBackground(fArray);
        this.redrawWidget(this.handle, false);
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        if (image == this.backgroundImage) {
            return;
        }
        this.backgroundImage = image;
        this.redrawWidget(this.handle, false);
    }

    void setBackground(float[] fArray) {
        this.setBackground(this.handle, fArray);
    }

    void setBackground(int n, float[] fArray) {
        ControlFontStyleRec controlFontStyleRec = new ControlFontStyleRec();
        OS.GetControlData(n, (short)0, 1718578804, 24, controlFontStyleRec, null);
        if (fArray != null) {
            controlFontStyleRec.backColor_red = (short)(fArray[0] * 65535.0f);
            controlFontStyleRec.backColor_green = (short)(fArray[1] * 65535.0f);
            controlFontStyleRec.backColor_blue = (short)(fArray[2] * 65535.0f);
            controlFontStyleRec.flags = (short)(controlFontStyleRec.flags | 0x10);
        } else {
            controlFontStyleRec.flags = (short)(controlFontStyleRec.flags & 0xFFFFFFEF);
        }
        OS.SetControlFontStyle(n, controlFontStyleRec);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.setBounds(n, n2, Math.max(0, n3), Math.max(0, n4), true, true, true);
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        return this.setBounds(this.topHandle(), n, n2, n3, n4, bl, bl2, bl3);
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, Math.max(0, rectangle.width), Math.max(0, rectangle.height), true, true, true);
    }

    public void setCapture(boolean bl) {
        this.checkWidget();
    }

    public void setCursor(Cursor cursor) {
        CGPoint cGPoint;
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        if (!this.isEnabled()) {
            return;
        }
        Point point = new Point();
        OS.GetGlobalMouse(point);
        int[] nArray = new int[1];
        if (this.display.grabControl == this) {
            nArray[0] = OS.GetControlOwner(this.handle);
        } else {
            if (OS.FindWindow(point, nArray) != 3) {
                return;
            }
            if (nArray[0] == 0) {
                return;
            }
        }
        Rect rect = new Rect();
        OS.GetWindowBounds(nArray[0], (short)33, rect);
        int[] nArray2 = new int[1];
        if (this.display.grabControl == this) {
            nArray2[0] = this.handle;
        } else {
            Control control;
            Widget widget;
            cGPoint = new CGPoint();
            cGPoint.x = point.h - rect.left;
            cGPoint.y = point.v - rect.top;
            int[] nArray3 = new int[1];
            OS.GetRootControl(nArray[0], nArray3);
            OS.HIViewGetSubviewHit(nArray3[0], cGPoint, true, nArray2);
            int n = nArray2[0];
            while (nArray2[0] != 0 && nArray2[0] != this.handle) {
                OS.GetSuperControl(nArray2[0], nArray2);
            }
            if (nArray2[0] == 0) {
                return;
            }
            nArray2[0] = n;
            while ((widget = this.display.getWidget(nArray2[0])) == null || !(widget instanceof Control) || !(control = (Control)widget).isEnabled()) {
                OS.GetSuperControl(nArray2[0], nArray2);
                if (nArray2[0] != 0) continue;
            }
            if (nArray2[0] == 0) {
                nArray2[0] = nArray3[0];
                widget = this.display.getWidget(nArray2[0]);
                if (widget != null && widget instanceof Control) {
                    control = (Control)widget;
                    nArray2[0] = control.handle;
                }
            }
        }
        cGPoint = new CGPoint();
        OS.HIViewConvertPoint(cGPoint, nArray2[0], 0);
        point.h = (short)(point.h - (int)cGPoint.x);
        point.v = (short)(point.v - (int)cGPoint.y);
        OS.GetWindowBounds(nArray[0], (short)32, rect);
        point.h = (short)(point.h - rect.left);
        point.v = (short)(point.v - rect.top);
        int n = OS.GetCurrentEventKeyModifiers();
        boolean[] blArray = new boolean[1];
        OS.HandleControlSetCursor(nArray2[0], point, (short)n, blArray);
        if (!blArray[0]) {
            OS.SetThemeCursor(0);
        }
    }

    void setDefaultFont() {
        if (this.display.smallFonts) {
            this.setFontStyle(this.defaultFont());
        }
    }

    public void setDragDetect(boolean bl) {
        this.checkWidget();
        this.state = bl ? (this.state |= 0x40000) : (this.state &= 0xFFFBFFFF);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 8) == 0 == bl) {
            return;
        }
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.state = bl ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.enableWidget(bl);
        if (bl2) {
            this.fixFocus(control);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.font = font;
        this.setFontStyle(this.display.smallFonts ? (font != null ? font : this.defaultFont()) : font);
        this.redrawWidget(this.handle, false);
    }

    void setFontStyle(Font font) {
        this.setFontStyle(this.handle, font);
    }

    void setFontStyle(int n, Font font) {
        ControlFontStyleRec controlFontStyleRec = new ControlFontStyleRec();
        OS.GetControlData(n, (short)0, 1718578804, 24, controlFontStyleRec, null);
        controlFontStyleRec.flags = (short)(controlFontStyleRec.flags & 0xFFFFFF78);
        if (font != null) {
            short[] sArray = new short[1];
            short[] sArray2 = new short[1];
            OS.FMGetFontFamilyInstanceFromFont(font.handle, sArray, sArray2);
            controlFontStyleRec.flags = (short)(controlFontStyleRec.flags | 7);
            controlFontStyleRec.font = sArray[0];
            controlFontStyleRec.style = (short)(sArray2[0] | font.style);
            controlFontStyleRec.size = (short)font.size;
        }
        OS.SetControlFontStyle(n, controlFontStyleRec);
    }

    public void setForeground(Color color) {
        float[] fArray;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        float[] fArray2 = fArray = color != null ? color.handle : null;
        if (this.equals(fArray, this.foreground)) {
            return;
        }
        this.foreground = fArray;
        this.setForeground(fArray);
        this.redrawWidget(this.handle, false);
    }

    void setForeground(float[] fArray) {
        this.setForeground(this.handle, fArray);
    }

    void setForeground(int n, float[] fArray) {
        ControlFontStyleRec controlFontStyleRec = new ControlFontStyleRec();
        OS.GetControlData(n, (short)0, 1718578804, 24, controlFontStyleRec, null);
        if (fArray != null) {
            controlFontStyleRec.foreColor_red = (short)(fArray[0] * 65535.0f);
            controlFontStyleRec.foreColor_green = (short)(fArray[1] * 65535.0f);
            controlFontStyleRec.foreColor_blue = (short)(fArray[2] * 65535.0f);
            controlFontStyleRec.flags = (short)(controlFontStyleRec.flags | 8);
        } else {
            controlFontStyleRec.flags = (short)(controlFontStyleRec.flags & 0xFFFFFFF7);
        }
        OS.SetControlFontStyle(n, controlFontStyleRec);
    }

    public void setLayoutData(Object object) {
        this.checkWidget();
        this.layoutData = object;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setBounds(n, n2, 0, 0, true, false, true);
    }

    public void setLocation(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(point.x, point.y, 0, 0, true, false, true);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    public boolean setParent(Composite composite) {
        this.checkWidget();
        if (composite == null) {
            this.error(4);
        }
        if (composite.isDisposed()) {
            SWT.error(5);
        }
        if (this.parent == composite) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        this.releaseParent();
        Shell shell = composite.getShell();
        Shell shell2 = this.getShell();
        Decorations decorations = composite.menuShell();
        Decorations decorations2 = this.menuShell();
        if (shell2 != shell || decorations2 != decorations) {
            Menu[] menuArray = shell2.findMenus(this);
            this.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        }
        int n = this.topHandle();
        OS.HIViewAddSubview(composite.handle, n);
        OS.HIViewSetVisible(n, (this.state & 0x10) == 0);
        OS.HIViewSetZOrder(n, 2, 0);
        this.parent = composite;
        return true;
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        if (bl) {
            if (--this.drawCount == 0) {
                OS.HIViewSetDrawingEnabled(this.handle, true);
                this.invalidateVisibleRegion(this.handle);
                this.redrawWidget(this.handle, true);
            }
        } else {
            if (this.drawCount == 0) {
                OS.HIViewSetDrawingEnabled(this.handle, false);
                this.invalidateVisibleRegion(this.handle);
            }
            ++this.drawCount;
        }
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        this.region = region;
        OS.HIViewRegionChanged(this.handle, -1);
        this.redrawWidget(this.handle, true);
    }

    boolean setRadioSelection(boolean bl) {
        return false;
    }

    void setRelations() {
        Control control;
        if (this.parent == null) {
            return;
        }
        Control[] controlArray = this.parent._getChildren();
        int n = controlArray.length;
        if (n > 1 && (control = controlArray[n - 2]) != this) {
            control.addRelation(this);
        }
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, n), Math.max(0, n2), false, true, true);
    }

    public void setSize(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(0, 0, Math.max(0, point.x), Math.max(0, point.y), false, true, true);
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        if (this.display.helpWidget == this) {
            this.display.helpWidget = null;
            OS.HMInstallControlContentCallback(this.handle, 0);
            OS.HMInstallControlContentCallback(this.handle, this.display.helpProc);
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.setVisible(this.topHandle(), bl);
        if (!bl) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (bl2) {
            this.fixFocus(control);
        }
    }

    void setZOrder() {
        int n = this.topHandle();
        int n2 = this.parent.handle;
        OS.HIViewAddSubview(n2, n);
        OS.HIViewSetZOrder(n, 2, 0);
        Rect rect = this.getInset();
        Rect rect2 = new Rect();
        rect2.left = rect2.right = rect.left;
        rect2.top = rect2.bottom = rect.top;
        OS.SetControlBounds(n, rect2);
    }

    void setZOrder(Control control, boolean bl) {
        int n = control == null ? 0 : control.topHandle();
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        Control[] controlArray = null;
        controlArray = this.parent._getChildren();
        while (n2 < controlArray.length) {
            if (controlArray[n2] == this) break;
            ++n2;
        }
        if (control != null) {
            while (n3 < controlArray.length) {
                if (controlArray[n3] == control) break;
                ++n3;
            }
        }
        this.removeRelation();
        if (n2 + 1 < controlArray.length) {
            n4 = n2 + 1;
            controlArray[n4].removeRelation();
        }
        if (control != null) {
            if (bl) {
                control.removeRelation();
            } else if (n3 + 1 < controlArray.length) {
                controlArray[n3 + 1].removeRelation();
            }
        }
        this.setZOrder(this.topHandle(), n, bl);
        n2 = control != null ? (bl ? n3 - (n2 < n3 ? 1 : 0) : n3 + (n3 < n2 ? 1 : 0)) : (bl ? 0 : controlArray.length - 1);
        controlArray = this.parent._getChildren();
        if (n2 > 0) {
            controlArray[n2 - 1].addRelation(this);
        }
        if (n2 + 1 < controlArray.length) {
            this.addRelation(controlArray[n2 + 1]);
        }
        if (n4 != -1) {
            if (n4 <= n2) {
                --n4;
            }
            if (n4 > 0 && n4 != n2 && n4 != n2 + 1) {
                controlArray[n4 - 1].addRelation(controlArray[n4]);
            }
        }
    }

    void sort(int[] nArray) {
        int n = nArray.length;
        int n2 = n / 2;
        while (n2 > 0) {
            int n3 = n2;
            while (n3 < n) {
                int n4 = n3 - n2;
                while (n4 >= 0) {
                    if (nArray[n4] <= nArray[n4 + n2]) {
                        int n5 = nArray[n4];
                        nArray[n4] = nArray[n4 + n2];
                        nArray[n4 + n2] = n5;
                    }
                    n4 -= n2;
                }
                ++n3;
            }
            n2 /= 2;
        }
    }

    org.eclipse.swt.graphics.Point textExtent(int n, int n2) {
        if (n != 0 && OS.CFStringGetLength(n) > 0) {
            float[] fArray = new float[1];
            float[] fArray2 = new float[1];
            HIThemeTextInfo hIThemeTextInfo = new HIThemeTextInfo();
            hIThemeTextInfo.state = 1;
            if (this.font != null) {
                short[] sArray = new short[1];
                short[] sArray2 = new short[1];
                OS.FMGetFontFamilyInstanceFromFont(this.font.handle, sArray, sArray2);
                OS.TextFont(sArray[0]);
                OS.TextFace((short)(sArray2[0] | this.font.style));
                OS.TextSize((short)this.font.size);
                hIThemeTextInfo.fontID = (short)200;
            } else {
                hIThemeTextInfo.fontID = (short)this.defaultThemeFont();
            }
            OS.HIThemeGetTextDimensions(n, n2 == -1 ? 0 : n2, hIThemeTextInfo, fArray, fArray2, null);
            return new org.eclipse.swt.graphics.Point((int)fArray[0], (int)fArray2[0]);
        }
        Font font = this.getFont();
        ATSFontMetrics aTSFontMetrics = new ATSFontMetrics();
        OS.ATSFontGetVerticalMetrics(font.handle, 0, aTSFontMetrics);
        OS.ATSFontGetHorizontalMetrics(font.handle, 0, aTSFontMetrics);
        return new org.eclipse.swt.graphics.Point(0, (int)(0.5f + (aTSFontMetrics.ascent - aTSFontMetrics.descent + aTSFontMetrics.leading) * font.size));
    }

    org.eclipse.swt.graphics.Point textExtent(char[] cArray, int n) {
        int n2 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        org.eclipse.swt.graphics.Point point = this.textExtent(n2, n);
        if (n2 != 0) {
            OS.CFRelease(n2);
        }
        return point;
    }

    public org.eclipse.swt.graphics.Point toControl(int n, int n2) {
        this.checkWidget();
        Rect rect = new Rect();
        int n3 = OS.GetControlOwner(this.handle);
        CGPoint cGPoint = new CGPoint();
        OS.HIViewConvertPoint(cGPoint, this.handle, 0);
        n -= (int)cGPoint.x;
        n2 -= (int)cGPoint.y;
        OS.GetWindowBounds(n3, (short)32, rect);
        n -= rect.left;
        n2 -= rect.top;
        Rect rect2 = this.getInset();
        return new org.eclipse.swt.graphics.Point(n += rect2.left, n2 += rect2.top);
    }

    public org.eclipse.swt.graphics.Point toControl(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public org.eclipse.swt.graphics.Point toDisplay(int n, int n2) {
        this.checkWidget();
        Rect rect = new Rect();
        int n3 = OS.GetControlOwner(this.handle);
        CGPoint cGPoint = new CGPoint();
        OS.HIViewConvertPoint(cGPoint, this.handle, 0);
        n += (int)cGPoint.x;
        n2 += (int)cGPoint.y;
        OS.GetWindowBounds(n3, (short)32, rect);
        n += rect.left;
        n2 += rect.top;
        Rect rect2 = this.getInset();
        return new org.eclipse.swt.graphics.Point(n -= rect2.left, n2 -= rect2.top);
    }

    public org.eclipse.swt.graphics.Point toDisplay(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    int topHandle() {
        return this.handle;
    }

    boolean translateTraversal(int n, int n2, boolean[] blArray) {
        Object object;
        int n3 = 0;
        int n4 = this.traversalCode(n, n2);
        boolean bl = false;
        switch (n) {
            case 53: {
                bl = true;
                n3 = 2;
                break;
            }
            case 36: 
            case 76: {
                bl = true;
                n3 = 4;
                break;
            }
            case 48: {
                object = new int[1];
                OS.GetEventParameter(n2, 1802334052, 1835100014, null, 4, null, object);
                boolean bl2 = (object[0] & 0x200) == 0;
                n3 = bl2 ? 16 : 8;
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                boolean bl3 = n == 125 || n == 124;
                n3 = bl3 ? 64 : 32;
                break;
            }
            case 116: 
            case 121: {
                bl = true;
                object = new int[1];
                OS.GetEventParameter(n2, 1802334052, 1835100014, null, 4, null, object);
                if ((object[0] & 0x1000) == 0) {
                    return false;
                }
                n3 = n == 121 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        object = new Event();
        blArray[0] = (n4 & n3) != 0;
        object.doit = blArray[0];
        object.detail = n3;
        if (!this.setKeyState((Event)object, 31, n2)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse((Event)object)) {
                return true;
            }
            if (!object.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl && control != null);
        return false;
    }

    int traversalCode(int n, int n2) {
        int n3 = 28;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            n3 |= 2;
        }
        return n3;
    }

    boolean traverseMnemonic(char c) {
        return false;
    }

    public boolean traverse(int n) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = n;
        return this.traverse(event);
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean bl) {
        Control control = this.computeTabRoot();
        Control control2 = this.computeTabGroup();
        Control[] controlArray = control.computeTabList();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (controlArray[n2] == control2) break;
            ++n2;
        }
        if (n2 == n) {
            return false;
        }
        int n3 = n2;
        int n4 = bl ? 1 : -1;
        while ((n2 = (n2 + n4 + n) % n) != n3) {
            Control control3 = controlArray[n2];
            if (control3.isDisposed() || !control3.setTabGroupFocus()) continue;
            return true;
        }
        if (control2.isDisposed()) {
            return false;
        }
        return control2.setTabGroupFocus();
    }

    boolean traverseItem(boolean bl) {
        Control[] controlArray = this.parent._getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (controlArray[n2] == this) break;
            ++n2;
        }
        if (n2 == n) {
            return false;
        }
        int n3 = n2;
        int n4 = bl ? 1 : -1;
        while ((n2 = (n2 + n4 + n) % n) != n3) {
            Control control = controlArray[n2];
            if (control.isDisposed() || !control.isTabItem() || !control.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean bl) {
        return false;
    }

    boolean traverseMnemonic(Event event) {
        return false;
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean bl) {
        if (this.display.inPaint) {
            return;
        }
        OS.HIViewRender(this.handle);
        if (this.isDisposed()) {
            return;
        }
        OS.HIWindowFlush(OS.GetControlOwner(this.handle));
    }

    void updateBackgroundMode() {
        int n = this.state & 0x400;
        this.checkBackground();
        if (n != (this.state & 0x400)) {
            this.setBackground();
        }
    }

    void updateLayout(boolean bl) {
    }
}

