/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.DataBrowserAccessibilityItemInfo;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserCustomCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserListViewColumnDesc;
import org.eclipse.swt.internal.carbon.DataBrowserListViewHeaderDesc;
import org.eclipse.swt.internal.carbon.HMHelpContentRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    TreeItem[] items;
    TreeColumn[] columns;
    TreeColumn sortColumn;
    int[] childIds;
    GC paintGC;
    int sortDirection;
    int columnCount;
    int column_id;
    int idCount;
    int anchorFirst;
    int anchorLast;
    int headerHeight;
    boolean ignoreRedraw;
    boolean ignoreSelect;
    boolean wasSelected;
    boolean ignoreExpand;
    boolean wasExpanded;
    boolean inClearAll;
    boolean drawBackground;
    Rectangle imageBounds;
    TreeItem showItem;
    TreeItem insertItem;
    boolean insertBefore;
    int lastHittest;
    int lastHittestColumn;
    int visibleCount;
    static final int CHECK_COLUMN_ID = 1024;
    static final int COLUMN_ID = 1025;
    static final int GRID_WIDTH = 1;
    static final int ICON_AND_TEXT_GAP = 4;
    static final int CELL_CONTENT_INSET = 12;
    static final int BORDER_INSET = 1;
    static final int DISCLOSURE_COLUMN_EDGE_INSET = 8;
    static final int DISCLOSURE_COLUMN_LEVEL_INDENT = 24;
    static final int DISCLOSURE_TRIANGLE_AND_CONTENT_GAP = 8;
    static final String[] AX_ATTRIBUTES = new String[]{"AXTitle"};

    public Tree(Composite composite, int n) {
        super(composite, Tree.checkStyle(n));
    }

    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        int n2 = 0;
        while (n2 < this.items.length) {
            if (this.items[n2] != null) {
                this.items[n2].width = -1;
            }
            ++n2;
        }
    }

    int _getId() {
        return this._getIds(1)[0];
    }

    int[] _getIds(int n) {
        int n2;
        int[] nArray = new int[n];
        int n3 = 0;
        if ((this.style & 0x10000000) == 0) {
            int n4 = 0;
            while (n4 < this.items.length) {
                if (this.items[n4] == null) {
                    nArray[n3++] = n4 + 1;
                    if (n3 == n) {
                        return nArray;
                    }
                }
                ++n4;
            }
            n4 = this.items.length;
            while (n3 < n) {
                nArray[n3++] = n4 + 1;
                ++n4;
            }
            return nArray;
        }
        boolean[] blArray = new boolean[this.items.length];
        if (this.childIds != null) {
            n2 = 0;
            while (n2 < this.childIds.length) {
                int n5 = this.childIds[n2];
                if (n5 != 0) {
                    if (n5 > blArray.length) {
                        boolean[] blArray2 = new boolean[n5 + 4];
                        System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
                        blArray = blArray2;
                    }
                    blArray[n5 - 1] = true;
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.items.length) {
            if (this.items[n2] != null) {
                blArray[n2] = true;
                int[] nArray2 = this.items[n2].childIds;
                if (nArray2 != null) {
                    int n6 = 0;
                    while (n6 < nArray2.length) {
                        int n7 = nArray2[n6];
                        if (n7 != 0) {
                            if (n7 > blArray.length) {
                                boolean[] blArray3 = new boolean[n7 + 4];
                                System.arraycopy(blArray, 0, blArray3, 0, blArray.length);
                                blArray = blArray3;
                            }
                            blArray[n7 - 1] = true;
                        }
                        ++n6;
                    }
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < blArray.length) {
            if (!blArray[n2]) {
                nArray[n3++] = n2 + 1;
                if (n3 == n) {
                    return nArray;
                }
            }
            ++n2;
        }
        n2 = blArray.length;
        while (n3 < n) {
            nArray[n3++] = n2 + 1;
            ++n2;
        }
        return nArray;
    }

    TreeItem _getItem(int n, boolean bl) {
        int n2;
        TreeItem treeItem;
        if (n < 1) {
            return null;
        }
        TreeItem treeItem2 = treeItem = n - 1 < this.items.length ? this.items[n - 1] : null;
        if (treeItem != null || (this.style & 0x10000000) == 0 || !bl) {
            return treeItem;
        }
        if (this.childIds != null) {
            n2 = 0;
            while (n2 < this.childIds.length) {
                if (this.childIds[n2] == n) {
                    return this._getItem(null, n2);
                }
                ++n2;
            }
        }
        n2 = 0;
        while (n2 < this.items.length) {
            TreeItem treeItem3 = this.items[n2];
            if (treeItem3 != null && treeItem3.childIds != null) {
                int[] nArray = treeItem3.childIds;
                int n3 = 0;
                while (n3 < nArray.length) {
                    if (nArray[n3] == n) {
                        return this._getItem(treeItem3, n3);
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return null;
    }

    TreeItem _getItem(TreeItem treeItem, int n) {
        Object object;
        int n2 = this.getItemCount(treeItem);
        if (n < 0 || n >= n2) {
            return null;
        }
        int[] nArray = treeItem == null ? this.childIds : treeItem.childIds;
        int n3 = nArray[n];
        if (n3 == 0) {
            nArray[n] = n3 = this._getId();
        }
        if (n3 > this.items.length) {
            object = new TreeItem[n3 + 4];
            System.arraycopy(this.items, 0, object, 0, this.items.length);
            this.items = object;
        }
        if ((object = this.items[n3 - 1]) != null || (this.style & 0x10000000) == 0) {
            return object;
        }
        object = new TreeItem(this, treeItem, 0, n, false);
        object.id = n3;
        this.items[n3 - 1] = object;
        return object;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(treeListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int calculateWidth(int[] nArray, GC gC, boolean bl, int n, int n2) {
        if (nArray == null) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            TreeItem treeItem = this._getItem(nArray[n4], false);
            if (treeItem != null) {
                int n5 = treeItem.calculateWidth(0, gC);
                n3 = Math.max(n3, n5 += n * n2);
                if (bl && treeItem._getExpanded()) {
                    n3 = Math.max(n3, this.calculateWidth(treeItem.childIds, gC, bl, n + 1, n2));
                }
            }
            ++n4;
        }
        return n3;
    }

    int callPaintEventHandler(int n, int n2, int n3, int n4, int n5) {
        Rectangle rectangle;
        Object object;
        if (this.columnCount == 0 && (this.hooks(41) || this.hooks(40) || this.hooks(42))) {
            object = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short[])object);
            if (object[0] == false) {
                OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)1);
            }
        }
        if ((object = this.paintGC) == null) {
            GCData gCData = new GCData();
            gCData.paintEvent = n4;
            gCData.visibleRgn = n3;
            this.paintGC = GC.carbon_new(this, gCData);
        }
        this.drawBackground = this.findBackgroundControl() != null;
        int n6 = super.callPaintEventHandler(n, n2, n3, n4, n5);
        if (this.getItemCount() == 0 && this.drawBackground) {
            this.drawBackground = false;
            rectangle = this.getClientArea();
            int n7 = this.getHeaderHeight();
            rectangle.y += n7;
            rectangle.height -= n7;
            this.fillBackground(this.handle, this.paintGC.handle, rectangle);
        }
        if (this.insertItem != null && !this.insertItem.isDisposed()) {
            rectangle = this.insertItem.getImageBounds(0).union(this.insertItem.getBounds());
            Rectangle rectangle2 = this.getClientArea();
            int n8 = rectangle2.x + rectangle2.width;
            int n9 = this.insertBefore ? rectangle.y : rectangle.y + rectangle.height - 1;
            this.paintGC.drawLine(rectangle.x, n9, n8, n9);
        }
        if (object == null) {
            this.paintGC.dispose();
            this.paintGC = null;
        }
        return n6;
    }

    boolean checkData(TreeItem treeItem, boolean bl) {
        if (treeItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            treeItem.cached = true;
            Event event = new Event();
            TreeItem treeItem2 = treeItem.getParentItem();
            event.item = treeItem;
            event.index = treeItem2 == null ? this.indexOf(treeItem) : treeItem2.indexOf(treeItem);
            this.ignoreRedraw = true;
            this.sendEvent(36, event);
            this.ignoreRedraw = false;
            if (this.isDisposed() || treeItem.isDisposed()) {
                return false;
            }
            if (bl && !this.setScrollWidth(treeItem)) {
                treeItem.redraw(0);
            }
        }
        return true;
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Tree.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear(TreeItem treeItem, int n, boolean bl) {
        int[] nArray = treeItem == null ? this.childIds : treeItem.childIds;
        TreeItem treeItem2 = this._getItem(nArray[n], false);
        if (treeItem2 != null) {
            treeItem2.clear();
            if (bl) {
                this.clearAll(treeItem2, true);
            } else {
                int n2 = treeItem == null ? 0 : treeItem.id;
                OS.UpdateDataBrowserItems(this.handle, n2, 1, new int[]{treeItem2.id}, 0, 0);
            }
        }
    }

    void clearAll(TreeItem treeItem, boolean bl) {
        boolean bl2 = !this.inClearAll;
        int n = this.getItemCount(treeItem);
        if (n == 0) {
            return;
        }
        this.inClearAll = true;
        int[] nArray = treeItem == null ? this.childIds : treeItem.childIds;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem2 = this._getItem(nArray[n2], false);
            if (treeItem2 != null) {
                treeItem2.clear();
                if (bl) {
                    this.clearAll(treeItem2, true);
                }
            }
            ++n2;
        }
        if (bl2) {
            OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
            this.inClearAll = false;
        }
    }

    public void clear(int n, boolean bl) {
        this.checkWidget();
        int n2 = this.getItemCount(null);
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        this.clear(null, n, bl);
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        this.clearAll(null, bl);
    }

    public org.eclipse.swt.graphics.Point computeSize(int n, int n2, boolean bl) {
        Object object;
        int n3;
        this.checkWidget();
        int n4 = 0;
        if (n == -1) {
            if (this.columnCount != 0) {
                n3 = 0;
                while (n3 < this.columnCount) {
                    n4 += this.columns[n3].getWidth();
                    ++n3;
                }
            } else {
                n3 = 24;
                if (OS.VERSION >= 4160) {
                    object = new float[1];
                    OS.DataBrowserGetMetric(this.handle, 5, null, (float[])object);
                    n3 = (int)object[0];
                }
                object = new GC(this);
                n4 = this.calculateWidth(this.childIds, (GC)object, true, 0, n3);
                ((Resource)object).dispose();
                n4 += this.getInsetWidth(this.column_id, true);
            }
            if ((this.style & 0x20) != 0) {
                n4 += this.getCheckColumnWidth();
            }
        } else {
            n4 = n;
        }
        if (n4 <= 0) {
            n4 = 64;
        }
        n3 = 0;
        n3 = n2 == -1 ? this.visibleCount * this.getItemHeight() + this.getHeaderHeight() : n2;
        if (n3 <= 0) {
            n3 = 64;
        }
        object = this.computeTrim(0, 0, n4, n3);
        return new org.eclipse.swt.graphics.Point(((Rectangle)object).width, ((Rectangle)object).height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = this.getBorderWidth();
        Rect rect = new Rect();
        OS.GetDataBrowserScrollBarInset(this.handle, rect);
        return new Rectangle(n -= rect.left + n5, n2 -= rect.top + n5, n3 += rect.left + rect.right + n5 + n5, n4 += rect.top + rect.bottom + n5 + n5);
    }

    boolean contains(int n, int n2) {
        CGPoint cGPoint = new CGPoint();
        int[] nArray = new int[1];
        OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.handle)), OS.kHIViewWindowContentID(), nArray);
        OS.HIViewConvertPoint(cGPoint, this.handle, nArray[0]);
        int n3 = n - (int)cGPoint.x;
        int n4 = n2 - (int)cGPoint.y;
        if (n4 < this.getHeaderHeight()) {
            return false;
        }
        return this.getClientArea().contains(n3, n4);
    }

    void createHandle() {
        int n;
        DataBrowserListViewColumnDesc dataBrowserListViewColumnDesc;
        int n2;
        this.column_id = 1025;
        int[] nArray = new int[1];
        int n3 = OS.GetControlOwner(this.parent.handle);
        OS.CreateDataBrowserControl(n3, null, 1819505782, nArray);
        OS.SetAutomaticControlDragTrackingEnabledForWindow(n3, true);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
        if (!this.drawFocusRing()) {
            OS.SetControlData(this.handle, 0, 1651663986, 1, new byte[1]);
        }
        int n4 = (this.style & 4) != 0 ? 66 : 8;
        OS.SetDataBrowserSelectionFlags(this.handle, n4);
        short[] sArray = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, sArray);
        this.headerHeight = sArray[0];
        OS.SetDataBrowserListViewHeaderBtnHeight(this.handle, (short)0);
        OS.SetDataBrowserHasScrollBars(this.handle, (this.style & 0x100) != 0, (this.style & 0x200) != 0);
        if (OS.VERSION >= 4160) {
            n2 = 4;
            OS.DataBrowserSetMetric(this.handle, 1, false, n2);
            OS.DataBrowserSetMetric(this.handle, 3, false, n2);
            OS.DataBrowserSetMetric(this.handle, 4, false, n2);
            OS.DataBrowserSetMetric(this.handle, 2, false, n2);
        }
        n2 = 0;
        if ((this.style & 0x20) != 0) {
            dataBrowserListViewColumnDesc = new DataBrowserListViewColumnDesc();
            dataBrowserListViewColumnDesc.headerBtnDesc_version = 0;
            dataBrowserListViewColumnDesc.propertyDesc_propertyID = 1024;
            dataBrowserListViewColumnDesc.propertyDesc_propertyType = 1667785336;
            dataBrowserListViewColumnDesc.propertyDesc_propertyFlags = 1;
            n = this.getCheckColumnWidth();
            dataBrowserListViewColumnDesc.headerBtnDesc_minimumWidth = (short)n;
            dataBrowserListViewColumnDesc.headerBtnDesc_maximumWidth = (short)n;
            dataBrowserListViewColumnDesc.headerBtnDesc_initialOrder = 1;
            OS.AddDataBrowserListViewColumn(this.handle, dataBrowserListViewColumnDesc, n2++);
        }
        dataBrowserListViewColumnDesc = new DataBrowserListViewColumnDesc();
        dataBrowserListViewColumnDesc.headerBtnDesc_version = 0;
        dataBrowserListViewColumnDesc.propertyDesc_propertyID = this.column_id;
        dataBrowserListViewColumnDesc.propertyDesc_propertyType = 0x3F3F3F3F;
        dataBrowserListViewColumnDesc.propertyDesc_propertyFlags = 327680;
        dataBrowserListViewColumnDesc.headerBtnDesc_maximumWidth = Short.MAX_VALUE;
        dataBrowserListViewColumnDesc.headerBtnDesc_initialOrder = 1;
        OS.AddDataBrowserListViewColumn(this.handle, dataBrowserListViewColumnDesc, n2);
        OS.SetDataBrowserListViewDisclosureColumn(this.handle, this.column_id, false);
        OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)0);
        if (OS.VERSION < 4160) {
            OS.HIViewSetDrawingEnabled(this.handle, false);
            n = 50;
            Rect rect = new Rect();
            rect.right = rect.bottom = (short)n;
            OS.SetControlBounds(this.handle, rect);
            int n5 = n * 4;
            int[] nArray2 = new int[1];
            int n6 = OS.NewPtr(n5 * n);
            OS.NewGWorldFromPtr(nArray2, 32, rect, 0, 0, 0, n6, n5);
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            OS.GetGWorld(nArray3, nArray4);
            OS.SetGWorld(nArray2[0], nArray4[0]);
            OS.DrawControlInCurrentPort(this.handle);
            OS.SetGWorld(nArray3[0], nArray4[0]);
            OS.DisposeGWorld(nArray2[0]);
            OS.DisposePtr(n6);
            rect.bottom = 0;
            rect.right = 0;
            OS.SetControlBounds(this.handle, rect);
            OS.HIViewSetDrawingEnabled(this.handle, true);
        }
    }

    void createItem(TreeColumn treeColumn, int n) {
        Object[] objectArray;
        Object object;
        TreeColumn[] treeColumnArray;
        if (n < 0 || n > this.columnCount) {
            this.error(6);
        }
        if (n == 0) {
            treeColumn.style &= 0xFEFDBFFF;
            treeColumn.style |= 0x4000;
        }
        treeColumn.id = this.column_id + this.idCount++;
        int n2 = n + ((this.style & 0x20) != 0 ? 1 : 0);
        if (this.columnCount != 0) {
            treeColumnArray = new DataBrowserListViewColumnDesc();
            treeColumnArray.headerBtnDesc_version = 0;
            treeColumnArray.propertyDesc_propertyID = treeColumn.id;
            treeColumnArray.propertyDesc_propertyType = 0x3F3F3F3F;
            treeColumnArray.propertyDesc_propertyFlags = 327680;
            treeColumnArray.headerBtnDesc_maximumWidth = Short.MAX_VALUE;
            treeColumnArray.headerBtnDesc_initialOrder = 1;
            treeColumnArray.headerBtnDesc_btnFontStyle_just = (short)-2;
            if ((this.style & 0x1000000) != 0) {
                treeColumnArray.headerBtnDesc_btnFontStyle_just = 1;
            }
            if ((this.style & 0x20000) != 0) {
                treeColumnArray.headerBtnDesc_btnFontStyle_just = (short)-1;
            }
            treeColumnArray.headerBtnDesc_btnFontStyle_flags = (short)(treeColumnArray.headerBtnDesc_btnFontStyle_flags | 0x40);
            OS.AddDataBrowserListViewColumn(this.handle, (DataBrowserListViewColumnDesc)treeColumnArray, n2);
            OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, treeColumn.id, (short)0);
            if (n == 0) {
                object = new int[1];
                objectArray = new boolean[1];
                OS.GetDataBrowserListViewDisclosureColumn(this.handle, (int[])object, (boolean[])objectArray);
                OS.SetDataBrowserListViewDisclosureColumn(this.handle, treeColumn.id, (boolean)objectArray[0]);
            }
        }
        if (this.columnCount == this.columns.length) {
            treeColumnArray = new TreeColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columns.length);
            this.columns = treeColumnArray;
        }
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = treeColumn;
        if (this.columnCount > 1) {
            int n3 = 0;
            while (n3 < this.items.length) {
                object = this.items[n3];
                if (object != null) {
                    Resource[] resourceArray;
                    Color[] colorArray;
                    Resource[] resourceArray2;
                    Object[] objectArray2;
                    objectArray = ((TreeItem)object).strings;
                    if (objectArray != null) {
                        objectArray2 = new String[this.columnCount];
                        System.arraycopy(objectArray, 0, objectArray2, 0, n);
                        System.arraycopy(objectArray, n, objectArray2, n + 1, this.columnCount - n - 1);
                        objectArray2[n] = "";
                        ((TreeItem)object).strings = objectArray2;
                    }
                    if (n == 0) {
                        ((TreeItem)object).text = "";
                    }
                    if ((objectArray2 = ((TreeItem)object).images) != null) {
                        resourceArray2 = new Image[this.columnCount];
                        System.arraycopy(objectArray2, 0, resourceArray2, 0, n);
                        System.arraycopy(objectArray2, n, resourceArray2, n + 1, this.columnCount - n - 1);
                        ((TreeItem)object).images = resourceArray2;
                    }
                    if (n == 0) {
                        ((TreeItem)object).image = null;
                    }
                    if ((resourceArray2 = ((TreeItem)object).cellBackground) != null) {
                        colorArray = new Color[this.columnCount];
                        System.arraycopy(resourceArray2, 0, colorArray, 0, n);
                        System.arraycopy(resourceArray2, n, colorArray, n + 1, this.columnCount - n - 1);
                        ((TreeItem)object).cellBackground = colorArray;
                    }
                    if ((colorArray = ((TreeItem)object).cellForeground) != null) {
                        resourceArray = new Color[this.columnCount];
                        System.arraycopy(colorArray, 0, resourceArray, 0, n);
                        System.arraycopy(colorArray, n, resourceArray, n + 1, this.columnCount - n - 1);
                        ((TreeItem)object).cellForeground = resourceArray;
                    }
                    if ((resourceArray = ((TreeItem)object).cellFont) != null) {
                        Font[] fontArray = new Font[this.columnCount];
                        System.arraycopy(resourceArray, 0, fontArray, 0, n);
                        System.arraycopy(resourceArray, n, fontArray, n + 1, this.columnCount - n - 1);
                        ((TreeItem)object).cellFont = fontArray;
                    }
                }
                ++n3;
            }
        }
    }

    void createItem(TreeItem treeItem, TreeItem treeItem2, int n) {
        Object[] objectArray;
        int n2;
        int n3 = this.getItemCount(treeItem2);
        if (n == -1) {
            n = n3;
        }
        if (n < 0 || n > n3) {
            this.error(6);
        }
        if ((n2 = this._getId()) > this.items.length) {
            objectArray = new TreeItem[n2 + 4];
            System.arraycopy(this.items, 0, objectArray, 0, this.items.length);
            this.items = objectArray;
        }
        treeItem.id = n2;
        this.items[n2 - 1] = treeItem;
        objectArray = treeItem2 == null ? this.childIds : treeItem2.childIds;
        if (objectArray == null || n3 + 1 > objectArray.length) {
            int[] nArray = new int[n3 + 4];
            if (objectArray != null) {
                System.arraycopy(objectArray, 0, nArray, 0, objectArray.length);
            }
            objectArray = nArray;
            if (treeItem2 == null) {
                this.childIds = (int[])objectArray;
            } else {
                treeItem2.childIds = (int[])objectArray;
            }
        }
        System.arraycopy(objectArray, n, objectArray, n + 1, objectArray.length - n - 1);
        objectArray[n] = (TreeItem)n2;
        if (treeItem2 != null) {
            ++treeItem2.itemCount;
        }
        if (treeItem2 == null || treeItem2.getExpanded()) {
            int n4;
            int n5 = n4 = treeItem2 == null ? 0 : treeItem2.id;
            if (OS.AddDataBrowserItems(this.handle, n4, 1, new int[]{treeItem.id}, 0) != 0) {
                this.items[n2 - 1] = null;
                System.arraycopy(objectArray, n + 1, objectArray, n, objectArray.length - n - 1);
                this.error(14);
            }
            ++this.visibleCount;
        } else if (treeItem2 != null && treeItem2.itemCount == 1) {
            treeItem2.redraw(0);
        }
    }

    ScrollBar createScrollBar(int n) {
        return this.createStandardBar(n);
    }

    void createWidget() {
        super.createWidget();
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
    }

    Color defaultBackground() {
        return this.display.getSystemColor(25);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(24);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 3;
    }

    public void deselectAll() {
        this.checkWidget();
        this.ignoreSelect = true;
        int[] nArray = null;
        if ((this.style & 4) != 0) {
            nArray = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, nArray);
            OS.SetDataBrowserSelectionFlags(this.handle, nArray[0] & 0xFFFFFFBF);
        }
        OS.SetDataBrowserSelectedItems(this.handle, 0, null, 3);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, nArray[0]);
        }
        this.ignoreSelect = false;
    }

    public void deselect(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.ignoreSelect = true;
        int[] nArray = null;
        if ((this.style & 4) != 0) {
            nArray = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, nArray);
            OS.SetDataBrowserSelectionFlags(this.handle, nArray[0] & 0xFFFFFFBF);
        }
        OS.SetDataBrowserSelectedItems(this.handle, 1, new int[]{treeItem.id}, 3);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, nArray[0]);
        }
        this.ignoreSelect = false;
    }

    void destroyItem(TreeColumn treeColumn) {
        Object object;
        Object object2;
        Object object3;
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == treeColumn) break;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.items.length) {
            object3 = this.items[n2];
            if (object3 != null) {
                if (this.columnCount <= 1) {
                    ((TreeItem)object3).strings = null;
                    ((TreeItem)object3).images = null;
                    ((TreeItem)object3).cellBackground = null;
                    ((TreeItem)object3).cellForeground = null;
                    ((TreeItem)object3).cellFont = null;
                } else {
                    Object[] objectArray;
                    if (((TreeItem)object3).strings != null) {
                        object2 = ((TreeItem)object3).strings;
                        if (n == 0) {
                            ((TreeItem)object3).text = object2[1] != null ? object2[1] : "";
                        }
                        objectArray = new String[this.columnCount - 1];
                        System.arraycopy(object2, 0, objectArray, 0, n);
                        System.arraycopy(object2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TreeItem)object3).strings = objectArray;
                    } else if (n == 0) {
                        ((TreeItem)object3).text = "";
                    }
                    if (((TreeItem)object3).images != null) {
                        object2 = ((TreeItem)object3).images;
                        if (n == 0) {
                            ((TreeItem)object3).image = object2[1];
                        }
                        objectArray = new Image[this.columnCount - 1];
                        System.arraycopy(object2, 0, objectArray, 0, n);
                        System.arraycopy(object2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TreeItem)object3).images = objectArray;
                    } else if (n == 0) {
                        ((TreeItem)object3).image = null;
                    }
                    if (((TreeItem)object3).cellBackground != null) {
                        object2 = ((TreeItem)object3).cellBackground;
                        objectArray = new Color[this.columnCount - 1];
                        System.arraycopy(object2, 0, objectArray, 0, n);
                        System.arraycopy(object2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TreeItem)object3).cellBackground = objectArray;
                    }
                    if (((TreeItem)object3).cellForeground != null) {
                        object2 = ((TreeItem)object3).cellForeground;
                        objectArray = new Color[this.columnCount - 1];
                        System.arraycopy(object2, 0, objectArray, 0, n);
                        System.arraycopy(object2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TreeItem)object3).cellForeground = objectArray;
                    }
                    if (((TreeItem)object3).cellFont != null) {
                        object2 = ((TreeItem)object3).cellFont;
                        objectArray = new Font[this.columnCount - 1];
                        System.arraycopy(object2, 0, objectArray, 0, n);
                        System.arraycopy(object2, n + 1, objectArray, n, this.columnCount - 1 - n);
                        ((TreeItem)object3).cellFont = objectArray;
                    }
                }
            }
            ++n2;
        }
        if (this.columnCount == 1) {
            int n3;
            this.column_id = treeColumn.id;
            this.idCount = 0;
            object = new DataBrowserListViewHeaderDesc();
            object.version = 0;
            object3 = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short[])object3);
            Object object4 = object3[0];
            object.maximumWidth = (short)object4;
            object.minimumWidth = (short)object4;
            object.titleString = n3 = OS.CFStringCreateWithCharacters(0, null, 0);
            OS.SetDataBrowserListViewHeaderDesc(this.handle, this.column_id, (DataBrowserListViewHeaderDesc)object);
            OS.CFRelease(n3);
        } else {
            object = new int[1];
            object3 = new boolean[1];
            OS.GetDataBrowserListViewDisclosureColumn(this.handle, object, (boolean[])object3);
            if (object[0] == treeColumn.id) {
                object2 = this.columns[1];
                ((TreeColumn)object2).style &= 0xFEFDBFFF;
                ((TreeColumn)object2).style |= 0x4000;
                ((TreeColumn)object2).updateHeader();
                OS.SetDataBrowserListViewDisclosureColumn(this.handle, ((TreeColumn)object2).id, (boolean)object3[0]);
            }
            if (OS.RemoveDataBrowserTableViewColumn(this.handle, treeColumn.id) != 0) {
                this.error(15);
            }
        }
        System.arraycopy(this.columns, n + 1, this.columns, n, --this.columnCount - n);
        this.columns[this.columnCount] = null;
        int n4 = n;
        while (n4 < this.columnCount) {
            this.columns[n4].sendEvent(10);
            ++n4;
        }
    }

    void destroyItem(TreeItem treeItem) {
        TreeItem treeItem2 = treeItem.parentItem;
        if (treeItem2 == null || treeItem2.getExpanded()) {
            int n = treeItem2 == null ? 0 : treeItem2.id;
            this.ignoreExpand = true;
            if (OS.RemoveDataBrowserItems(this.handle, n, 1, new int[]{treeItem.id}, 0) != 0) {
                this.error(15);
            }
            --this.visibleCount;
            this.ignoreExpand = false;
        }
        if (treeItem2 != null && !treeItem2.getExpanded() && treeItem2.itemCount > 0) {
            treeItem2.redraw(0);
        }
        this.releaseItem(treeItem, false);
        this.setScrollWidth(true);
        this.fixScrollBar();
    }

    void destroyScrollBar(ScrollBar scrollBar) {
        if ((scrollBar.style & 0x100) != 0) {
            this.style &= 0xFFFFFEFF;
        }
        if ((scrollBar.style & 0x200) != 0) {
            this.style &= 0xFFFFFDFF;
        }
        OS.SetDataBrowserHasScrollBars(this.handle, (this.style & 0x100) != 0, (this.style & 0x200) != 0);
    }

    int drawItemProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object;
        boolean bl;
        if (n2 < 0) {
            return 0;
        }
        int n8 = 0;
        if (this.columnCount > 0) {
            n8 = 0;
            while (n8 < this.columnCount) {
                if (this.columns[n8].id == n3) break;
                ++n8;
            }
            if (n8 == this.columnCount) {
                return 0;
            }
        }
        Rect rect = new Rect();
        TreeItem treeItem = this._getItem(n2, true);
        if ((this.style & 0x10000000) != 0 && !treeItem.cached) {
            if (!this.checkData(treeItem, false)) {
                return 0;
            }
            if (this.setScrollWidth(treeItem)) {
                if (OS.GetDataBrowserItemPartBounds(this.handle, n2, n3, 0, rect) == 0) {
                    short s = rect.left;
                    short s2 = rect.top;
                    int n9 = rect.right - rect.left;
                    int n10 = rect.bottom - rect.top;
                    this.redrawWidget(this.handle, s, s2, n9, n10, false);
                }
                return 0;
            }
        }
        OS.memmove(rect, n5, 8);
        int n11 = rect.left;
        short s = rect.top;
        int n12 = rect.right - rect.left;
        int n13 = rect.bottom - rect.top;
        GC gC = this.paintGC;
        if (gC == null) {
            GCData gCData = new GCData();
            int[] nArray = new int[1];
            OS.GetPort(nArray);
            gCData.port = nArray[0];
            gC = GC.carbon_new(this, gCData);
        }
        OS.GetDataBrowserItemPartBounds(this.handle, n2, n3, 0, rect);
        short s3 = this.getLinesVisible() ? (short)1 : 0;
        int n14 = rect.left + s3;
        short s4 = rect.top;
        int n15 = rect.right - rect.left - s3;
        int n16 = rect.bottom - rect.top + 1;
        if (this.drawBackground) {
            this.drawBackground = false;
            Region region = new Region(this.display);
            Rectangle rectangle = this.getClientArea();
            int n17 = this.getHeaderHeight();
            rectangle.y += n17;
            rectangle.height -= n17;
            if (rectangle.height < 0) {
                rectangle.height = 0;
            }
            region.add(rectangle);
            if ((this.style & 0x20) != 0 || s3 != 0) {
                int n18 = OS.NewRgn();
                if ((this.style & 0x20) != 0 && OS.GetDataBrowserItemPartBounds(this.handle, n2, 1024, 0, rect) == 0) {
                    OS.SetRectRgn(n18, rect.left, (short)rectangle.y, (short)(rect.right + s3), (short)(rectangle.y + rectangle.height));
                    OS.DiffRgn(region.handle, n18, region.handle);
                }
                if (s3 != 0) {
                    if (this.columnCount == 0) {
                        if (OS.GetDataBrowserItemPartBounds(this.handle, n2, 1025, 0, rect) == 0) {
                            OS.SetRectRgn(n18, rect.right, (short)rectangle.y, (short)(rect.right + s3), (short)(rectangle.y + rectangle.height));
                            OS.DiffRgn(region.handle, n18, region.handle);
                        }
                    } else {
                        int n19 = 0;
                        while (n19 < this.columnCount) {
                            if (OS.GetDataBrowserItemPartBounds(this.handle, n2, this.columns[n19].id, 0, rect) == 0) {
                                OS.SetRectRgn(n18, rect.right, (short)rectangle.y, (short)(rect.right + s3), (short)(rectangle.y + rectangle.height));
                                OS.DiffRgn(region.handle, n18, region.handle);
                            }
                            ++n19;
                        }
                    }
                }
                OS.DisposeRgn(n18);
            }
            if (region != null) {
                gC.setClipping(region);
            }
            this.fillBackground(this.handle, gC.handle, null);
            if (region != null) {
                gC.setClipping((Rectangle)null);
                region.dispose();
            }
        }
        OS.CGContextSaveGState(gC.handle);
        int n20 = OS.NewRgn();
        OS.SetRectRgn(n20, (short)n14, s4, (short)(n14 + n15), (short)(s4 + n16));
        int n21 = OS.NewRgn();
        OS.GetClip(n21);
        OS.SectRgn(n21, n20, n20);
        OS.DisposeRgn(n21);
        Region region = Region.carbon_new(this.display, n20);
        Font font = treeItem.getFont(n8);
        Color color = treeItem.getBackground(n8);
        Color color2 = treeItem.getForeground(n8);
        Image image = treeItem.getImage(n8);
        String string = treeItem.getText(n8);
        gC.setClipping(region);
        gC.setFont(font);
        org.eclipse.swt.graphics.Point point = gC.stringExtent(string);
        int n22 = point.x;
        Rectangle rectangle = null;
        int n23 = 0;
        if (image != null) {
            n23 = this.getGap();
            rectangle = image.getBounds();
            n22 += this.imageBounds.width + n23;
        }
        int n24 = n22;
        if (this.hooks(41)) {
            Event event = new Event();
            event.item = treeItem;
            event.index = n8;
            event.gc = gC;
            event.width = n22;
            event.height = n16;
            this.sendEvent(41, event);
            if (n16 < event.height) {
                n16 = event.height;
                OS.SetDataBrowserTableViewRowHeight(this.handle, (short)event.height);
                this.redrawWidget(this.handle, false);
            }
            if (this.setScrollWidth(treeItem)) {
                this.redrawWidget(this.handle, false);
            }
            n22 = event.width;
            gC.setClipping(region);
            gC.setFont(font);
        }
        int n25 = 16;
        if (treeItem.background != null || treeItem.cellBackground != null && treeItem.cellBackground[n8] != null) {
            n25 |= 8;
        }
        if ((n4 & 5) != 0) {
            n25 |= 2;
        }
        boolean bl2 = bl = (n25 & 2) != 0;
        if ((n25 & 2) != 0 && ((this.style & 0x10000) != 0 || n8 == 0)) {
            gC.setBackground(this.display.getSystemColor(26));
            gC.setForeground(this.display.getSystemColor(27));
        } else {
            gC.setBackground(color);
            gC.setForeground(color2);
        }
        if (this.hooks(40)) {
            object = new Event();
            ((Event)object).item = treeItem;
            ((Event)object).index = n8;
            ((Event)object).gc = gC;
            ((Event)object).x = n14;
            ((Event)object).y = s4;
            ((Event)object).width = n15;
            ((Event)object).height = n16;
            ((Event)object).detail = n25;
            this.sendEvent(40, (Event)object);
            n25 = ((Event)object).doit ? ((Event)object).detail : 0;
            gC.setClipping(region);
            gC.setFont(font);
            if ((n25 & 2) != 0 && ((this.style & 0x10000) != 0 || n8 == 0)) {
                gC.setBackground(this.display.getSystemColor(26));
                gC.setForeground(this.display.getSystemColor(27));
            } else {
                gC.setBackground(color);
                if (!bl) {
                    gC.setForeground(color2);
                }
            }
        }
        if (this.columnCount != 0 && n8 != 0) {
            object = this.columns[n8];
            if ((((TreeColumn)object).style & 0x1000000) != 0) {
                n11 += (n12 - n22) / 2;
            }
            if ((((TreeColumn)object).style & 0x20000) != 0) {
                n11 += n12 - n22;
            }
        }
        int n26 = n11;
        int n27 = 0;
        if (image != null) {
            n27 = this.imageBounds.width + n23;
            n26 += n27;
        }
        if ((n25 & 2) != 0 && ((this.style & 0x10000) != 0 || n8 == 0)) {
            if ((this.style & 0x8000) == 0 || this.hasFocus()) {
                if ((this.style & 0x10000) != 0) {
                    gC.fillRectangle(n14, s4, n15, n16 - 1);
                    n25 &= 0xFFFFFFF7;
                } else if (n8 == 0) {
                    gC.fillRectangle(n26 - 1, s, n22 - n27 + 2, n16 - 1);
                    n25 &= 0xFFFFFFF7;
                }
            } else if ((n25 & 8) != 0) {
                gC.setBackground(color);
            }
        }
        if ((n25 & 8) != 0) {
            if (this.columnCount == 0) {
                gC.fillRectangle(n26 - 1, s, n22 - n27 + 2, n16 - 1);
            } else {
                gC.fillRectangle(n14, s4, n15, n16);
            }
        }
        if ((n25 & 0x10) != 0) {
            if (image != null) {
                int n28 = n11;
                int n29 = s + (n13 - this.imageBounds.height) / 2;
                gC.drawImage(image, 0, 0, rectangle.width, rectangle.height, n28, n29, this.imageBounds.width, this.imageBounds.height);
            }
            gC.drawString(string, n26, s + (n13 - point.y) / 2, true);
        }
        if (this.hooks(42)) {
            Event event = new Event();
            event.item = treeItem;
            event.index = n8;
            event.gc = gC;
            event.x = n11;
            event.y = s;
            event.width = n24;
            event.height = n16;
            event.detail = n25;
            this.sendEvent(42, event);
        }
        OS.CGContextRestoreGState(gC.handle);
        OS.DisposeRgn(n20);
        if (gC != this.paintGC) {
            gC.dispose();
        }
        return 0;
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        this.redrawWidget(this.handle, false);
    }

    void fixScrollBar() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, nArray, nArray2);
        int n = Math.max(0, this.getItemHeight() * this.visibleCount - this.getClientArea().height);
        if (nArray[0] > n) {
            OS.SetDataBrowserScrollPosition(this.handle, n, nArray2[0]);
        }
    }

    String[] getAxAttributes() {
        return AX_ATTRIBUTES;
    }

    public int getBorderWidth() {
        this.checkWidget();
        int n = 0;
        byte[] byArray = new byte[1];
        OS.GetControlData(this.handle, (short)0, 1651663986, 1, byArray, null);
        if (byArray[0] != 0) {
            int[] nArray = new int[1];
            OS.GetThemeMetric(7, nArray);
            n += nArray[0] - 1;
        }
        return n;
    }

    int getCheckColumnWidth() {
        Object[] objectArray;
        int n = 0;
        if (OS.VERSION >= 4160) {
            objectArray = new float[1];
            OS.DataBrowserGetMetric(this.handle, 1, null, objectArray);
            n = (int)objectArray[0];
        } else {
            n = 12;
        }
        objectArray = new int[1];
        OS.GetThemeMetric(50, (int[])objectArray);
        return (int)(objectArray[0] + n * 2);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int n = this.getBorderWidth();
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        OS.GetControlBounds(this.handle, rect);
        OS.GetDataBrowserScrollBarInset(this.handle, rect2);
        int n2 = Math.max(0, rect.right - rect.left - rect2.right - n - n);
        int n3 = Math.max(0, rect.bottom - rect.top - rect2.bottom - n - n);
        return new Rectangle(rect2.left + n, rect2.top + n, n2, n3);
    }

    public TreeColumn getColumn(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] nArray = new int[this.columnCount];
        int[] nArray2 = new int[1];
        int n = 0;
        while (n < this.columnCount) {
            TreeColumn treeColumn = this.columns[n];
            OS.GetDataBrowserTableViewColumnPosition(this.handle, treeColumn.id, nArray2);
            if ((this.style & 0x20) != 0) {
                nArray2[0] = nArray2[0] - 1;
            }
            nArray[nArray2[0]] = n++;
        }
        return nArray;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] treeColumnArray = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columnCount);
        return treeColumnArray;
    }

    int getGap() {
        if (OS.VERSION >= 4160) {
            float[] fArray = new float[1];
            OS.DataBrowserGetMetric(this.handle, 2, null, fArray);
            return (int)fArray[0];
        }
        return 4;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        short[] sArray = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, sArray);
        return sArray[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        short[] sArray = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, sArray);
        return sArray[0] != 0;
    }

    int getLeftDisclosureInset(int n) {
        int[] nArray = new int[1];
        OS.GetDataBrowserListViewDisclosureColumn(this.handle, nArray, new boolean[1]);
        if (nArray[0] == n) {
            int n2 = 0;
            int[] nArray2 = new int[1];
            OS.GetThemeMetric(26, nArray2);
            n2 += nArray2[0];
            if (OS.VERSION >= 4160) {
                float[] fArray = new float[1];
                OS.DataBrowserGetMetric(this.handle, 3, null, fArray);
                n2 += (int)fArray[0];
                OS.DataBrowserGetMetric(this.handle, 4, null, fArray);
                n2 += (int)fArray[0];
            } else {
                n2 += 16;
            }
            return n2;
        }
        return 0;
    }

    int getInsetWidth(int n, boolean bl) {
        int n2 = 0;
        if (OS.VERSION >= 4160) {
            float[] fArray = new float[1];
            OS.DataBrowserGetMetric(this.handle, 1, null, fArray);
            n2 = (int)fArray[0];
        } else {
            n2 = 12;
        }
        int n3 = 0;
        int[] nArray = new int[1];
        OS.GetDataBrowserListViewDisclosureColumn(this.handle, nArray, new boolean[1]);
        if (nArray[0] != n) {
            n3 += n2 * 2;
        } else {
            n3 += n2;
            if (bl) {
                n3 += this.getLeftDisclosureInset(n);
            }
        }
        return n3;
    }

    public TreeItem getItem(int n) {
        this.checkWidget();
        int n2 = this.getItemCount(null);
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        return this._getItem(null, n);
    }

    public TreeItem getItem(org.eclipse.swt.graphics.Point point) {
        Object object;
        Object object2;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int[] nArray = new int[1];
        OS.GetDataBrowserListViewDisclosureColumn(this.handle, nArray, new boolean[1]);
        short[] sArray = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight(this.handle, sArray) != 0) {
            this.error(11);
        }
        Rect rect = new Rect();
        Point point2 = new Point();
        OS.SetPt(point2, (short)point.x, (short)point.y);
        if (this.lastHittest > 0 && this.lastHittest <= this.items.length && this.lastHittestColumn != 0 && (object2 = (Object)this._getItem(this.lastHittest, false)) != null) {
            int n = this.column_id;
            int n2 = 0;
            while (n2 < this.columnCount) {
                object = this.columns[n2];
                int[] nArray2 = new int[1];
                OS.GetDataBrowserTableViewColumnPosition(this.handle, object.id, nArray2);
                if ((this.style & 0x20) != 0) {
                    nArray2[0] = nArray2[0] - 1;
                }
                if (nArray2[0] == this.columnCount - 1) {
                    n = object.id;
                    break;
                }
                ++n2;
            }
            if (OS.GetDataBrowserItemPartBounds(this.handle, object2.id, n, 0, rect) == 0 && point2.h > rect.right) {
                return null;
            }
            if (OS.GetDataBrowserItemPartBounds(this.handle, object2.id, nArray[0], 1684632419, rect) == 0 && OS.PtInRect(point2, rect)) {
                return null;
            }
            if (OS.GetDataBrowserItemPartBounds(this.handle, object2.id, this.lastHittestColumn, 0, rect) == 0) {
                rect.bottom = (short)(rect.top + sArray[0]);
                if (OS.PtInRect(point2, rect)) {
                    return object2;
                }
                if (rect.top <= point2.v && point2.v < rect.bottom) {
                    n2 = 0;
                    while (n2 < this.columnCount) {
                        if (OS.GetDataBrowserItemPartBounds(this.handle, object2.id, this.columns[n2].id, 0, rect) == 0) {
                            rect.bottom = (short)(rect.top + sArray[0]);
                            if (OS.PtInRect(point2, rect)) {
                                return object2;
                            }
                        }
                        ++n2;
                    }
                    return null;
                }
            }
        }
        object2 = new int[1];
        int[] nArray3 = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, object2, nArray3);
        short[] sArray2 = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, sArray2);
        int[] nArray4 = new int[3];
        nArray4[1] = 1;
        nArray4[2] = -1;
        object = nArray4;
        int n = 0;
        while (n < ((int[])object).length) {
            int n3 = (object2[0] - sArray2[0] + point.y) / sArray[0] + object[n];
            if (n3 >= 0) {
                int n4;
                int[] nArray5 = new int[1];
                int n5 = OS.GetDataBrowserTableViewItemID(this.handle, n3, nArray5);
                if (n5 != 0) {
                    return null;
                }
                TreeItem treeItem = this._getItem(nArray5[0], false);
                if (treeItem == null) {
                    return null;
                }
                if (OS.GetDataBrowserItemPartBounds(this.handle, treeItem.id, nArray[0], 1684632419, rect) == 0 && OS.PtInRect(point2, rect)) {
                    return null;
                }
                int n6 = n4 = this.columnCount == 0 ? this.column_id : this.columns[0].id;
                if (OS.GetDataBrowserItemPartBounds(this.handle, treeItem.id, n4, 0, rect) == 0) {
                    rect.bottom = (short)(rect.top + sArray[0]);
                    if (rect.top <= point2.v && point2.v < rect.bottom) {
                        if (this.columnCount == 0) {
                            if (OS.PtInRect(point2, rect)) {
                                return treeItem;
                            }
                        } else {
                            int n7 = 0;
                            while (n7 < this.columnCount) {
                                if (OS.GetDataBrowserItemPartBounds(this.handle, treeItem.id, this.columns[n7].id, 0, rect) == 0) {
                                    rect.bottom = (short)(rect.top + sArray[0]);
                                    if (OS.PtInRect(point2, rect)) {
                                        return treeItem;
                                    }
                                }
                                ++n7;
                            }
                        }
                        return null;
                    }
                }
            }
            ++n;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.getItemCount(null);
    }

    int getItemCount(TreeItem treeItem) {
        if (treeItem == null) {
            int[] nArray = new int[1];
            if (OS.GetDataBrowserItemCount(this.handle, 0, false, -1, nArray) == 0) {
                return nArray[0];
            }
            return 0;
        }
        return treeItem.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        short[] sArray = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight(this.handle, sArray) != 0) {
            this.error(11);
        }
        return sArray[0];
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.getItems(null);
    }

    TreeItem[] getItems(TreeItem treeItem) {
        if (this.items == null) {
            return new TreeItem[0];
        }
        int n = this.getItemCount(treeItem);
        TreeItem[] treeItemArray = new TreeItem[n];
        int n2 = 0;
        while (n2 < n) {
            treeItemArray[n2] = this._getItem(treeItem, n2);
            ++n2;
        }
        return treeItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        if (OS.VERSION >= 4160) {
            int[] nArray = new int[1];
            OS.DataBrowserGetAttributes(this.handle, nArray);
            return (nArray[0] & 6) != 0;
        }
        return false;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        int[] nArray = new int[1];
        if (OS.GetDataBrowserItemCount(this.handle, 0, true, 1, nArray) != 0) {
            this.error(36);
        }
        TreeItem[] treeItemArray = new TreeItem[nArray[0]];
        if (nArray[0] > 0) {
            int n = OS.NewHandle(0);
            if (nArray[0] == 1) {
                if (OS.GetDataBrowserItems(this.handle, 0, true, 1, n) != 0) {
                    this.error(9);
                }
                OS.HLock(n);
                int[] nArray2 = new int[1];
                OS.memmove(nArray2, n, 4);
                OS.memmove(nArray2, nArray2[0], 4);
                treeItemArray[0] = this._getItem(nArray2[0], true);
                OS.HUnlock(n);
            } else {
                this.getSelection(treeItemArray, 0, n, 0);
            }
            OS.DisposeHandle(n);
        }
        return treeItemArray;
    }

    int getSelection(TreeItem[] treeItemArray, int n, int n2, int n3) {
        int n4;
        int[] nArray;
        int n5;
        OS.SetHandleSize(n2, 0);
        if (OS.GetDataBrowserItems(this.handle, n, false, 1, n2) != 0) {
            this.error(9);
        }
        if ((n5 = OS.GetHandleSize(n2) / 4) > 0) {
            OS.HLock(n2);
            nArray = new int[n5];
            OS.memmove(nArray, n2, 4);
            OS.memmove(nArray, nArray[0], n5 * 4);
            n4 = 0;
            while (n4 < n5) {
                treeItemArray[n3++] = this._getItem(nArray[n5 - n4 - 1], true);
                ++n4;
            }
            OS.HUnlock(n2);
            if (n3 == treeItemArray.length) {
                return n3;
            }
        }
        OS.SetHandleSize(n2, 0);
        if (OS.GetDataBrowserItems(this.handle, n, false, 2, n2) != 0) {
            this.error(9);
        }
        if ((n5 = OS.GetHandleSize(n2) / 4) > 0) {
            OS.HLock(n2);
            nArray = new int[n5];
            OS.memmove(nArray, n2, 4);
            OS.memmove(nArray, nArray[0], n5 * 4);
            n4 = 0;
            while (n4 < n5) {
                if ((n3 = this.getSelection(treeItemArray, nArray[n5 - n4 - 1], n2, n3)) == treeItemArray.length) {
                    return n3;
                }
                ++n4;
            }
            OS.HUnlock(n2);
        }
        return n3;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] nArray = new int[1];
        if (OS.GetDataBrowserItemCount(this.handle, 0, true, 1, nArray) != 0) {
            this.error(36);
        }
        return nArray[0];
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, nArray, nArray2);
        int n = nArray[0] / this.getItemHeight();
        int[] nArray3 = new int[1];
        int n2 = OS.GetDataBrowserTableViewItemID(this.handle, n, nArray3);
        if (n2 == 0) {
            return this._getItem(nArray3[0], false);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    int helpProc(int var1_1, int var2_2, int var3_3, int var4_4, int var5_5) {
        block16: {
            if (this.toolTipText != null) break block16;
            switch (var3_3) {
                case 0: {
                    if (this.toolTipText != null && this.toolTipText.length() != 0) break;
                    var6_6 = new Rect();
                    var7_7 = OS.GetControlOwner(this.handle);
                    OS.GetWindowBounds(var7_7, (short)33, var6_6);
                    var8_8 = var6_6.left;
                    var9_9 = var6_6.top;
                    var10_10 = new Point();
                    OS.memmove(var10_10, new int[]{var2_2}, 4);
                    var10_10.h = (short)(var10_10.h - var8_8);
                    var10_10.v = (short)(var10_10.v - var9_9);
                    var11_11 = null;
                    var12_12 = 23;
                    var13_13 = new CGPoint();
                    var14_14 = new int[1];
                    OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.handle)), OS.kHIViewWindowContentID(), var14_14);
                    OS.HIViewConvertPoint(var13_13, this.handle, var14_14[0]);
                    var10_10.h = (short)(var10_10.h - (int)var13_13.x);
                    var10_10.v = (short)(var10_10.v - (int)var13_13.y);
                    var8_8 = (short)(var8_8 + (int)var13_13.x);
                    var9_9 = (short)(var9_9 + (int)var13_13.y);
                    var15_15 = var10_10.h;
                    var16_16 = var10_10.v;
                    var17_17 = this.getHeaderHeight();
                    if (var17_17 == 0 || var16_16 < 0 || var16_16 >= var17_17) ** GOTO lbl47
                    var18_18 = 0;
                    var19_21 = 0;
                    while (var19_21 < this.columnCount) {
                        var20_22 = this.columns[var19_21];
                        var21_23 = var20_22.lastWidth + this.getLeftDisclosureInset(var20_22.id);
                        if (var18_18 > var15_15 || var15_15 >= var18_18 + var21_23) ** GOTO lbl43
                        var11_11 = var20_22.toolTipText;
                        var6_6.left = (short)var18_18;
                        var6_6.top = 0;
                        var6_6.right = (short)(var6_6.left + var21_23);
                        var6_6.bottom = (short)(var6_6.top + var17_17);
                        var12_12 = 10;
                        ** GOTO lbl86
lbl43:
                        // 1 sources

                        var18_18 += var21_23;
                        ++var19_21;
                    }
                    ** GOTO lbl86
lbl47:
                    // 1 sources

                    var18_19 = null;
                    if (this.lastHittest > 0 && this.lastHittest <= this.items.length && this.lastHittestColumn != 0 && OS.GetDataBrowserItemPartBounds(this.handle, this.lastHittest, this.lastHittestColumn, 0x2D2D2D2D, var6_6) == 0) {
                        var18_19 = this._getItem(this.lastHittest, false);
                    }
                    if (var18_19 != null) {
                        var19_21 = 0;
                        var20_22 = null;
                        if (this.columnCount > 0) {
                            var21_24 = 0;
                            while (var21_24 < this.columnCount) {
                                if (this.columns[var21_24].id == this.lastHittestColumn) {
                                    var20_22 = this.columns[var21_24];
                                    var19_21 = var21_24;
                                    break;
                                }
                                ++var21_24;
                            }
                        }
                        var21_24 = this.lastHittestColumn;
                        var22_25 = new GC(this);
                        var23_26 = this.getInsetWidth(var21_24, false);
                        var24_27 = var18_19.calculateWidth(var19_21, var22_25) + var23_26;
                        var22_25.dispose();
                        if (this.columnCount == 0) {
                            var25_28 = this.getClientArea().width;
                        } else {
                            var26_29 = new short[1];
                            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, var21_24, (short[])var26_29);
                            var25_28 = var26_29[0];
                        }
                        if (var24_27 > var25_28) {
                            var11_11 = var18_19.getText(var19_21);
                            var26_29 = var18_19.getImage(var19_21);
                            var27_30 = var26_29 != null ? var26_29.getBounds().width + this.getGap() : 0;
                            v0 = var28_31 = var20_22 == null ? 16384 : var20_22.style;
                            if ((var28_31 & 16384) != 0) {
                                var6_6.left = (short)(var6_6.left + var27_30);
                                var6_6.right = (short)(var6_6.left + var24_27 - var27_30 - var23_26);
                            }
                            if ((var28_31 & 131072) != 0) {
                                var6_6.left = (short)(var6_6.right - var24_27 + var27_30 + var23_26);
                            }
                            if ((var28_31 & 0x1000000) != 0) {
                                var6_6.left = (short)(var6_6.left + var27_30);
                            }
                        }
                    }
lbl86:
                    // 9 sources

                    if (var11_11 == null || var11_11.length() == 0) break;
                    var18_20 = new char[var11_11.length()];
                    var11_11.getChars(0, var18_20.length, var18_20, 0);
                    var19_21 = this.fixMnemonic(var18_20);
                    if (this.display.helpString != 0) {
                        OS.CFRelease(this.display.helpString);
                    }
                    this.display.helpString = OS.CFStringCreateWithCharacters(0, var18_20, var19_21);
                    var20_22 = new HMHelpContentRec();
                    OS.memmove((HMHelpContentRec)var20_22, var5_5, 534);
                    this.display.helpWidget = this;
                    var20_22.version = 3;
                    var20_22.tagSide = (short)var12_12;
                    var20_22.absHotRect_left = (short)(var6_6.left + var8_8);
                    var20_22.absHotRect_top = (short)(var6_6.top + var9_9);
                    var20_22.absHotRect_right = (short)(var6_6.right + var8_8);
                    var20_22.absHotRect_bottom = (short)(var6_6.bottom + var9_9);
                    var20_22.content0_contentType = 1667658612;
                    var20_22.content0_tagCFString = this.display.helpString;
                    var20_22.content1_contentType = 1667658612;
                    var20_22.content1_tagCFString = this.display.helpString;
                    OS.memmove(var5_5, (HMHelpContentRec)var20_22, 534);
                    OS.memmove(var4_4, new short[1], 2);
                    return 0;
                }
            }
        }
        return super.helpProc(var1_1, var2_2, var3_3, var4_4, var5_5);
    }

    int hitTestProc(int n, int n2, int n3, int n4, int n5) {
        this.lastHittest = n2;
        this.lastHittestColumn = n3;
        return 1;
    }

    void hookEvents() {
        super.hookEvents();
        DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
        dataBrowserCallbacks.version = 0;
        OS.InitDataBrowserCallbacks(dataBrowserCallbacks);
        dataBrowserCallbacks.v1_itemDataCallback = this.display.itemDataProc;
        dataBrowserCallbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        dataBrowserCallbacks.v1_itemCompareCallback = this.display.itemCompareProc;
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        DataBrowserCustomCallbacks dataBrowserCustomCallbacks = new DataBrowserCustomCallbacks();
        dataBrowserCustomCallbacks.version = 0;
        OS.InitDataBrowserCustomCallbacks(dataBrowserCustomCallbacks);
        dataBrowserCustomCallbacks.v1_drawItemCallback = this.display.drawItemProc;
        dataBrowserCustomCallbacks.v1_hitTestCallback = this.display.hitTestProc;
        dataBrowserCustomCallbacks.v1_trackingCallback = this.display.trackingProc;
        OS.SetDataBrowserCustomCallbacks(this.handle, dataBrowserCustomCallbacks);
    }

    public int indexOf(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == treeColumn) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parentItem != null) {
            return -1;
        }
        return this._indexOf(null, treeItem);
    }

    int _indexOf(TreeItem treeItem, TreeItem treeItem2) {
        int[] nArray;
        int[] nArray2 = nArray = treeItem == null ? this.childIds : treeItem.childIds;
        if (nArray != null) {
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] == treeItem2.id) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    int itemCompareProc(int n, int n2, int n3, int n4) {
        boolean bl = (this.style & 0x10000000) != 0 && this.sortColumn != null && !this.sortColumn.isDisposed() && this.sortDirection == 1024;
        TreeItem treeItem = this._getItem(n2, bl);
        TreeItem treeItem2 = this._getItem(n3, bl);
        if (treeItem == null || treeItem2 == null) {
            return 0;
        }
        int n5 = this._indexOf(treeItem.parentItem, treeItem);
        int n6 = this._indexOf(treeItem2.parentItem, treeItem2);
        if (this.sortDirection == 1024 && this.sortColumn != null) {
            return n5 > n6 ? 1 : 0;
        }
        return n5 < n6 ? 1 : 0;
    }

    int itemDataProc(int n, int n2, int n3, int n4, int n5) {
        switch (n3) {
            case 1024: {
                TreeItem treeItem = this._getItem(n2, true);
                if (n5 != 0) {
                    boolean bl = treeItem.checked = !treeItem.checked;
                    if (treeItem.checked && treeItem.grayed) {
                        OS.SetDataBrowserItemDataButtonValue(n4, (short)2);
                    } else {
                        boolean bl2 = treeItem.checked;
                        OS.SetDataBrowserItemDataButtonValue(n4, (short)(bl2 ? 1 : 0));
                    }
                    Event event = new Event();
                    event.item = treeItem;
                    event.detail = 32;
                    this.postEvent(13, event);
                    if (treeItem.checked) break;
                    treeItem.redraw(1024);
                    break;
                }
                int n6 = 0;
                if (treeItem.checked) {
                    n6 = treeItem.grayed ? 2 : 1;
                }
                OS.SetDataBrowserItemDataButtonValue(n4, (short)n6);
                break;
            }
            case 4: {
                TreeItem treeItem = this._getItem(n2, true);
                if (treeItem.itemCount <= 0) break;
                OS.SetDataBrowserItemDataBooleanValue(n4, true);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int itemNotificationProc(int n, int n2, int n3) {
        TreeItem treeItem;
        block42: {
            int n4;
            int n5;
            int[] nArray;
            block43: {
                if (n3 == 13) {
                    block41: {
                        Object object;
                        int n6;
                        int[] nArray2;
                        boolean bl = false;
                        short[] sArray = new short[1];
                        TreeColumn[] treeColumnArray = this.getColumns();
                        int n7 = 0;
                        while (true) {
                            if (n7 >= this.columnCount) {
                                nArray2 = new int[1];
                                OS.GetDataBrowserSortProperty(this.handle, nArray2);
                                if (nArray2[0] == 0) return 0;
                                if (!bl) {
                                    n6 = 0;
                                    break;
                                }
                                break block41;
                            }
                            TreeColumn treeColumn = treeColumnArray[n7];
                            if (!treeColumn.isDisposed()) {
                                OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, treeColumn.id, sArray);
                                if (sArray[0] != treeColumn.lastWidth) {
                                    treeColumn.resized(sArray[0]);
                                    bl = true;
                                }
                            }
                            if (!treeColumn.isDisposed()) {
                                object = new int[1];
                                OS.GetDataBrowserTableViewColumnPosition(this.handle, treeColumn.id, (int[])object);
                                if (object[0] != treeColumn.lastPosition) {
                                    int n8;
                                    treeColumn.lastPosition = object[0];
                                    int n9 = n8 = (this.style & 0x20) != 0 ? object[0] - 1 : object[0];
                                    if (n8 == 0) {
                                        int[] nArray3 = new int[1];
                                        boolean[] blArray = new boolean[1];
                                        OS.GetDataBrowserListViewDisclosureColumn(this.handle, nArray3, blArray);
                                        if (nArray3[0] != treeColumn.id) {
                                            OS.SetDataBrowserListViewDisclosureColumn(this.handle, treeColumn.id, blArray[0]);
                                        }
                                    }
                                    treeColumn.sendEvent(10);
                                    bl = true;
                                }
                            }
                            ++n7;
                        }
                        while (n6 < this.columnCount) {
                            object = this.columns[n6];
                            if (nArray2[0] == ((TreeColumn)object).id) {
                                ((Widget)object).postEvent(this.display.clickCount == 2 ? 14 : 13);
                                break;
                            }
                            ++n6;
                        }
                    }
                    OS.SetDataBrowserSortProperty(this.handle, 0);
                    if (this.sortColumn == null) return 0;
                    if (this.sortColumn.isDisposed()) return 0;
                    if (this.sortDirection == 0) return 0;
                    OS.SetDataBrowserSortProperty(this.handle, this.sortColumn.id);
                    int n10 = this.sortDirection == 1024 ? 2 : 1;
                    OS.SetDataBrowserSortOrder(this.handle, (short)n10);
                    return 0;
                }
                switch (n3) {
                    case 5: 
                    case 6: {
                        int n11;
                        this.wasSelected = true;
                        if (this.ignoreSelect) {
                            return 0;
                        }
                        int[] nArray4 = new int[1];
                        int[] nArray5 = new int[1];
                        OS.GetDataBrowserSelectionAnchor(this.handle, nArray4, nArray5);
                        boolean bl = false;
                        bl = (this.style & 2) != 0 ? (((n11 = OS.GetCurrentEventKeyModifiers()) & 0x200) != 0 ? (n3 == 5 ? nArray4[0] == n2 || nArray5[0] == n2 : n2 == this.anchorFirst || n2 == this.anchorLast) : ((n11 & 0x100) != 0 ? true : nArray4[0] == nArray5[0])) : n3 == 5;
                        if (!bl) return 0;
                        this.anchorFirst = nArray4[0];
                        this.anchorLast = nArray5[0];
                        Event event = new Event();
                        event.item = this._getItem(n2, true);
                        this.postEvent(13, event);
                        return 0;
                    }
                    case 7: {
                        this.wasSelected = true;
                        if (this.display.clickCount != 2) return 0;
                        Event event = new Event();
                        event.item = this._getItem(n2, true);
                        this.postEvent(14, event);
                        return 0;
                    }
                    case 9: {
                        int n12;
                        int n13 = OS.NewHandle(0);
                        if (OS.GetDataBrowserItems(this.handle, n2, false, -1, n13) == 0) {
                            n12 = OS.GetHandleSize(n13) / 4;
                            this.visibleCount -= n12;
                        }
                        OS.DisposeHandle(n13);
                        n13 = OS.NewHandle(0);
                        if (OS.GetDataBrowserItems(this.handle, n2, true, 1, n13) == 0 && (n12 = OS.GetHandleSize(n13) / 4) > 0) {
                            int[] nArray6 = new int[n12];
                            OS.HLock(n13);
                            int[] nArray7 = new int[1];
                            OS.memmove(nArray7, n13, 4);
                            OS.memmove(nArray6, nArray7[0], n12 * 4);
                            OS.HUnlock(n13);
                            boolean bl = this.ignoreSelect;
                            this.ignoreSelect = true;
                            int[] nArray8 = null;
                            if ((this.style & 4) != 0) {
                                nArray8 = new int[1];
                                OS.GetDataBrowserSelectionFlags(this.handle, nArray8);
                                OS.SetDataBrowserSelectionFlags(this.handle, nArray8[0] & 0xFFFFFFBF);
                            }
                            OS.SetDataBrowserSelectedItems(this.handle, nArray6.length, nArray6, 3);
                            if ((this.style & 4) != 0) {
                                OS.SetDataBrowserSelectionFlags(this.handle, nArray8[0]);
                            }
                            this.ignoreSelect = bl;
                            if (!this.ignoreSelect) {
                                Event event = new Event();
                                event.item = this._getItem(n2, true);
                                this.sendEvent(13, event);
                            }
                        }
                        OS.DisposeHandle(n13);
                        return 0;
                    }
                    case 10: {
                        TreeItem treeItem2 = this._getItem(n2, true);
                        if (treeItem2 == null) {
                            return 0;
                        }
                        int[] nArray9 = treeItem2.childIds;
                        if (nArray9 != null) {
                            int n14 = 0;
                            while (n14 < treeItem2.itemCount) {
                                TreeItem treeItem3 = this._getItem(nArray9[n14], false);
                                if (treeItem3 == null) {
                                    nArray9[n14] = 0;
                                }
                                ++n14;
                            }
                        }
                        this.wasExpanded = true;
                        if (this.ignoreExpand) return 0;
                        Event event = new Event();
                        event.item = treeItem2;
                        this.sendEvent(18, event);
                        if (this.isDisposed()) {
                            return 0;
                        }
                        this.setScrollWidth(true);
                        this.fixScrollBar();
                        return 0;
                    }
                    case 8: {
                        treeItem = this._getItem(n2, true);
                        this.wasExpanded = true;
                        if (!this.ignoreExpand) {
                            Event event = new Event();
                            event.item = treeItem;
                            try {
                                treeItem.state |= 0x100;
                                this.sendEvent(17, event);
                                if (this.isDisposed()) {
                                    Object var6_21 = null;
                                    treeItem.state &= 0xFFFFFEFF;
                                    return 0;
                                }
                                break;
                            }
                            catch (Throwable throwable) {
                                Object var6_22 = null;
                                treeItem.state &= 0xFFFFFEFF;
                                throw throwable;
                            }
                        }
                        break block43;
                    }
                    default: {
                        return 0;
                    }
                }
                {
                    Object var6_23 = null;
                    treeItem.state &= 0xFFFFFEFF;
                }
            }
            int n15 = 0;
            int n16 = 0;
            while (true) {
                if (n16 >= treeItem.itemCount) {
                    if (n15 > 0) {
                        nArray = this._getIds(n15);
                        n5 = 0;
                        n4 = 0;
                        break;
                    }
                    break block42;
                }
                if (treeItem.childIds[n16] == 0) {
                    ++n15;
                }
                ++n16;
            }
            while (n4 < treeItem.itemCount) {
                if (treeItem.childIds[n4] == 0) {
                    treeItem.childIds[n4] = nArray[n5++];
                }
                ++n4;
            }
        }
        OS.AddDataBrowserItems(this.handle, n2, treeItem.itemCount, treeItem.childIds, 0);
        this.visibleCount += treeItem.itemCount;
        if (this.ignoreExpand) return 0;
        this.setScrollWidth(false, treeItem.childIds, false);
        return 0;
    }

    int kEventAccessibleGetNamedAttribute(int n, int n2, int n3) {
        int n4 = -9874;
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1635020397, 1667658612, null, 4, null, nArray);
        int n5 = 0;
        if (nArray[0] != 0) {
            n5 = OS.CFStringGetLength(nArray[0]);
        }
        char[] cArray = new char[n5];
        CFRange cFRange = new CFRange();
        cFRange.length = n5;
        OS.CFStringGetCharacters(nArray[0], cFRange, cArray);
        String string = new String(cArray);
        if (string.equals("AXHeader")) {
            short[] sArray = new short[1];
            OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, sArray);
            if (sArray[0] == 0) {
                n4 = 0;
            }
        } else {
            int[] nArray2 = new int[1];
            OS.GetEventParameter(n2, 1634689642, 1667658873, null, 4, null, nArray2);
            int n6 = nArray2[0];
            DataBrowserAccessibilityItemInfo dataBrowserAccessibilityItemInfo = new DataBrowserAccessibilityItemInfo();
            int n7 = OS.AXUIElementGetDataBrowserItemInfo(n6, this.handle, 0, dataBrowserAccessibilityItemInfo);
            if (n7 == 0 && dataBrowserAccessibilityItemInfo.v0_columnProperty != 0 && dataBrowserAccessibilityItemInfo.v0_item != 0 && dataBrowserAccessibilityItemInfo.v0_propertyPart == 0) {
                int n8 = 0;
                n8 = 0;
                while (n8 < this.columnCount) {
                    if (this.columns[n8].id == dataBrowserAccessibilityItemInfo.v0_columnProperty) break;
                    ++n8;
                }
                if (n8 != this.columnCount || this.columnCount == 0) {
                    int n9 = dataBrowserAccessibilityItemInfo.v0_item;
                    TreeItem treeItem = this._getItem(n9, false);
                    if (string.equals("AXRole") || string.equals("AXRoleDescription")) {
                        String string2 = "AXStaticText";
                        cArray = new char[string2.length()];
                        string2.getChars(0, cArray.length, cArray, 0);
                        nArray[0] = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                        if (nArray[0] != 0) {
                            if (string.equals("AXRole")) {
                                OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray);
                            } else {
                                int n10 = OS.HICopyAccessibilityRoleDescription(nArray[0], 0);
                                OS.SetEventParameter(n2, 1635022444, 1667658612, 4, new int[]{n10});
                                OS.CFRelease(n10);
                            }
                            OS.CFRelease(nArray[0]);
                            n4 = 0;
                        }
                    } else if (string.equals("AXChildren")) {
                        int n11 = OS.CFArrayCreateMutable(0, 0, 0);
                        OS.SetEventParameter(n2, 1635022444, 1667657057, 4, new int[]{n11});
                        OS.CFRelease(n11);
                        n4 = 0;
                    } else if (string.equals("AXTitle") || string.equals("AXDescription")) {
                        String string3 = treeItem.getText(n8);
                        cArray = new char[string3.length()];
                        string3.getChars(0, cArray.length, cArray, 0);
                        nArray[0] = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                        if (nArray[0] != 0) {
                            OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray);
                            OS.CFRelease(nArray[0]);
                            n4 = 0;
                        }
                    }
                }
            }
        }
        if (this.accessible != null) {
            n4 = this.accessible.internal_kEventAccessibleGetNamedAttribute(n, n2, n4);
        }
        return n4;
    }

    int kEventControlGetClickActivation(int n, int n2, int n3) {
        OS.SetEventParameter(n2, 1668047203, 1668047203, 4, new int[]{3});
        return 0;
    }

    int kEventControlSetCursor(int n, int n2, int n3) {
        if (!this.isEnabledCursor()) {
            return 0;
        }
        if (this.isEnabledModal()) {
            Point point = new Point();
            int n4 = 4;
            OS.GetEventParameter(n2, 1835822947, 1363439732, null, n4, null, point);
            if (!this.contains(point.h, point.v)) {
                return -9874;
            }
        }
        return super.kEventControlSetCursor(n, n2, n3);
    }

    int kEventUnicodeKeyPressed(int n, int n2, int n3) {
        int n4 = super.kEventUnicodeKeyPressed(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1953721189, 1702261350, null, nArray.length * 4, null, nArray);
        int[] nArray2 = new int[1];
        OS.GetEventParameter(nArray[0], 1801678692, 1835100014, null, nArray2.length * 4, null, nArray2);
        switch (nArray2[0]) {
            case 49: {
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                if (OS.GetDataBrowserSelectionAnchor(this.handle, nArray3, nArray4) != 0 || nArray3[0] == 0) break;
                TreeItem treeItem = this._getItem(nArray3[0], true);
                if ((this.style & 0x20) == 0) break;
                treeItem.setChecked(!treeItem.getChecked(), true);
                break;
            }
            case 36: 
            case 76: {
                this.postEvent(14);
                break;
            }
            case 125: 
            case 126: {
                int[] nArray5 = new int[1];
                int[] nArray6 = new int[1];
                OS.GetDataBrowserScrollPosition(this.handle, nArray5, nArray6);
                n4 = OS.CallNextEventHandler(n, n2);
                OS.GetDataBrowserScrollPosition(this.handle, nArray5, null);
                OS.SetDataBrowserScrollPosition(this.handle, nArray5[0], nArray6[0]);
                this.redrawBackgroundImage();
            }
        }
        return n4;
    }

    int kEventMouseDown(int n, int n2, int n3) {
        int n4 = super.kEventMouseDown(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        this.wasExpanded = false;
        this.wasSelected = false;
        n4 = OS.CallNextEventHandler(n, n2);
        if (this.isDisposed()) {
            return 0;
        }
        if (!this.wasSelected && !this.wasExpanded && OS.IsDataBrowserItemSelected(this.handle, this.lastHittest) && this.lastHittest > 0 && this.lastHittest <= this.items.length) {
            Event event = new Event();
            event.item = this._getItem(this.lastHittest, true);
            this.postEvent(13, event);
        }
        this.wasExpanded = false;
        this.wasSelected = false;
        return n4;
    }

    void releaseItem(TreeItem treeItem, boolean bl) {
        int n = treeItem.id;
        if (bl) {
            treeItem.release(false);
        }
        this.items[n - 1] = null;
        TreeItem treeItem2 = treeItem.parentItem;
        int[] nArray = treeItem2 == null ? this.childIds : treeItem2.childIds;
        int n2 = -1;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] == n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (n2 != -1) {
            System.arraycopy(nArray, 0, nArray, 0, n2);
            System.arraycopy(nArray, n2 + 1, nArray, n2, nArray.length - n2 - 1);
            nArray[nArray.length - 1] = 0;
        }
        if (treeItem2 != null) {
            --treeItem2.itemCount;
            if (treeItem2.itemCount == 0) {
                treeItem2.childIds = null;
            }
        }
    }

    void releaseItems(int[] nArray) {
        if (nArray == null) {
            return;
        }
        int n = nArray.length - 1;
        while (n >= 0) {
            TreeItem treeItem = this._getItem(nArray[n], false);
            if (treeItem != null) {
                this.releaseItems(treeItem.childIds);
                if (!this.isDisposed()) {
                    this.releaseItem(treeItem, true);
                }
            }
            --n;
        }
    }

    void releaseChildren(boolean bl) {
        Item item;
        int n = 0;
        while (n < this.items.length) {
            item = this.items[n];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++n;
        }
        this.items = null;
        this.childIds = null;
        if (this.columns != null) {
            n = 0;
            while (n < this.columnCount) {
                item = this.columns[n];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n;
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.sortColumn = null;
        this.paintGC = null;
        this.imageBounds = null;
        this.showItem = null;
        DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        dataBrowserCallbacks.v1_itemNotificationCallback = 0;
        dataBrowserCallbacks.v1_itemCompareCallback = 0;
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
    }

    public void removeAll() {
        this.checkWidget();
        int n = 0;
        while (n < this.items.length) {
            TreeItem treeItem = this.items[n];
            if (treeItem != null && !treeItem.isDisposed()) {
                treeItem.release(false);
            }
            ++n;
        }
        this.items = new TreeItem[4];
        this.childIds = null;
        DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        dataBrowserCallbacks.v1_itemNotificationCallback = 0;
        dataBrowserCallbacks.v1_itemCompareCallback = 0;
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        this.ignoreSelect = true;
        this.ignoreExpand = true;
        int n2 = OS.RemoveDataBrowserItems(this.handle, 0, 0, null, 0);
        this.ignoreSelect = false;
        this.ignoreExpand = false;
        dataBrowserCallbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        dataBrowserCallbacks.v1_itemCompareCallback = this.display.itemCompareProc;
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        if (n2 != 0) {
            this.error(15);
        }
        OS.SetDataBrowserScrollPosition(this.handle, 0, 0);
        this.anchorLast = 0;
        this.anchorFirst = 0;
        this.visibleCount = 0;
        this.setScrollWidth(true);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, treeListener);
        this.eventTable.unhook(18, treeListener);
    }

    void resetVisibleRegion(int n) {
        super.resetVisibleRegion(n);
        if (this.showItem != null && !this.showItem.isDisposed()) {
            this.showItem(this.showItem, true);
        }
    }

    public void setInsertMark(TreeItem treeItem, boolean bl) {
        this.checkWidget();
        if (treeItem != null && treeItem.isDisposed()) {
            this.error(5);
        }
        TreeItem treeItem2 = this.insertItem;
        this.insertItem = treeItem;
        this.insertBefore = bl;
        if (treeItem2 != null && !treeItem2.isDisposed()) {
            treeItem2.redraw(0);
        }
        if (treeItem != null) {
            treeItem.redraw(0);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.ignoreSelect = true;
        OS.SetDataBrowserSelectedItems(this.handle, 0, null, 1);
        this.ignoreSelect = false;
    }

    public void select(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.showItem(treeItem, false);
        this.ignoreSelect = true;
        int[] nArray = null;
        if ((this.style & 4) != 0) {
            nArray = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, nArray);
            OS.SetDataBrowserSelectionFlags(this.handle, nArray[0] & 0xFFFFFFBF);
        }
        OS.SetDataBrowserSelectedItems(this.handle, 1, new int[]{treeItem.id}, 1);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, nArray[0]);
        }
        this.ignoreSelect = false;
    }

    void setBackground(float[] fArray) {
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2, bl3);
        if (this.showItem != null && !this.showItem.isDisposed()) {
            this.showItem(this.showItem, true);
        }
        return n5;
    }

    public void setColumnOrder(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length != 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        int[] nArray2 = this.getColumnOrder();
        boolean bl = false;
        boolean[] blArray = new boolean[this.columnCount];
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 < 0 || n2 >= this.columnCount) {
                this.error(5);
            }
            if (blArray[n2]) {
                this.error(5);
            }
            blArray[n2] = true;
            if (nArray[n] != nArray2[n]) {
                bl = true;
            }
            ++n;
        }
        if (bl) {
            TreeColumn treeColumn;
            int n3;
            int[] nArray3 = new int[1];
            boolean[] blArray2 = new boolean[1];
            OS.GetDataBrowserListViewDisclosureColumn(this.handle, nArray3, blArray2);
            TreeColumn treeColumn2 = this.columns[nArray[0]];
            if (nArray3[0] != treeColumn2.id) {
                OS.SetDataBrowserListViewDisclosureColumn(this.handle, treeColumn2.id, blArray2[0]);
            }
            int n4 = 0;
            short[] sArray = new short[1];
            int[] nArray4 = new int[nArray2.length];
            int n5 = 0;
            while (n5 < nArray2.length) {
                n3 = nArray2[n5];
                TreeColumn treeColumn3 = this.columns[n3];
                nArray4[n3] = n4;
                OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, treeColumn3.id, sArray);
                n4 += sArray[0];
                ++n5;
            }
            n4 = 0;
            int[] nArray5 = new int[nArray.length];
            n3 = 0;
            while (n3 < nArray.length) {
                int n6 = nArray[n3];
                treeColumn = this.columns[n6];
                int n7 = (this.style & 0x20) != 0 ? n3 + 1 : n3;
                OS.SetDataBrowserTableViewColumnPosition(this.handle, treeColumn.id, n7);
                treeColumn.lastPosition = n7;
                nArray5[n6] = n4;
                OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, treeColumn.id, sArray);
                n4 += sArray[0];
                ++n3;
            }
            TreeColumn[] treeColumnArray = new TreeColumn[this.columnCount];
            System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columnCount);
            int n8 = 0;
            while (n8 < this.columnCount) {
                treeColumn = treeColumnArray[n8];
                if (!treeColumn.isDisposed() && nArray5[n8] != nArray4[n8]) {
                    treeColumn.sendEvent(10);
                }
                ++n8;
            }
        }
    }

    void setFontStyle(Font font) {
        super.setFontStyle(font);
        if (this.items == null) {
            return;
        }
        int n = 0;
        while (n < this.items.length) {
            TreeItem treeItem = this.items[n];
            if (treeItem != null) {
                treeItem.width = -1;
            }
            ++n;
        }
        this.setScrollWidth(true);
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        short[] sArray = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, sArray);
        if (sArray[0] != 0 != bl) {
            OS.SetDataBrowserListViewHeaderBtnHeight(this.handle, (short)(bl ? this.headerHeight : 0));
            this.invalidateVisibleRegion(this.handle);
        }
    }

    public void setItemCount(int n) {
        this.checkWidget();
        n = Math.max(0, n);
        this.setItemCount(null, n);
    }

    void setItemCount(TreeItem treeItem, int n) {
        int n2;
        int[] nArray;
        int n3 = this.getItemCount(treeItem);
        if (n == n3) {
            return;
        }
        this.setRedraw(false);
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, nArray2, nArray3);
        DataBrowserCallbacks dataBrowserCallbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        dataBrowserCallbacks.v1_itemNotificationCallback = 0;
        dataBrowserCallbacks.v1_itemCompareCallback = 0;
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        int[] nArray4 = nArray = treeItem == null ? this.childIds : treeItem.childIds;
        if (n < n3) {
            TreeItem[] treeItemArray;
            int n4;
            int[] nArray5 = new int[n3 - n];
            int n5 = 0;
            int n6 = nArray.length - 1;
            while (n6 >= n) {
                n4 = nArray[n6];
                if (n4 != 0) {
                    treeItemArray = this._getItem(n4, false);
                    if (treeItemArray != null && !treeItemArray.isDisposed()) {
                        treeItemArray.dispose();
                    } else if (treeItem == null || treeItem.getExpanded()) {
                        nArray5[nArray5.length - n5] = n4;
                        ++n5;
                        --this.visibleCount;
                    }
                }
                --n6;
            }
            if (n5 != 0 && n5 != nArray5.length) {
                int[] nArray6 = new int[n5];
                System.arraycopy(nArray5, nArray5.length - n5, nArray6, 0, n5);
                nArray5 = nArray6;
            }
            if (n5 != 0 && OS.RemoveDataBrowserItems(this.handle, 0, n5, nArray5, 0) != 0) {
                this.error(15);
            }
            n2 = this.items.length;
            n4 = this.items.length;
            while (n4 > 0) {
                if (this.items[n4 - 1] != null) {
                    n2 = n4;
                    break;
                }
                --n4;
            }
            if (n2 < this.items.length - 4) {
                n4 = Math.max(4, (n2 + 3) / 4 * 4);
                treeItemArray = new TreeItem[n4];
                System.arraycopy(this.items, 0, treeItemArray, 0, Math.min(this.items.length, n2));
                this.items = treeItemArray;
            }
        }
        if (treeItem != null) {
            treeItem.itemCount = n;
        }
        int n7 = Math.max(4, (n + 3) / 4 * 4);
        int[] nArray7 = new int[n7];
        if (nArray != null) {
            System.arraycopy(nArray, 0, nArray7, 0, Math.min(n, n3));
        }
        nArray = nArray7;
        if (treeItem == null) {
            this.childIds = nArray7;
        } else {
            treeItem.childIds = nArray7;
        }
        if (n > n3) {
            if ((this.getStyle() & 0x10000000) == 0) {
                n2 = Math.max(4, (n - n3 + 3) / 4 * 4);
                TreeItem[] treeItemArray = new TreeItem[this.items.length + n2];
                System.arraycopy(this.items, 0, treeItemArray, 0, this.items.length);
                this.items = treeItemArray;
                int n8 = n3;
                while (n8 < n) {
                    this.items[n8] = new TreeItem(this, treeItem, 0, n8, true);
                    ++n8;
                }
            } else if (treeItem == null || treeItem.getExpanded()) {
                int[] nArray8;
                n2 = treeItem == null ? 0 : treeItem.id;
                if (OS.AddDataBrowserItems(this.handle, n2, (nArray8 = this._getIds(n - n3)).length, nArray8, 0) != 0) {
                    this.error(14);
                }
                this.visibleCount += n - n3;
                System.arraycopy(nArray8, 0, nArray, n3, nArray8.length);
            }
        }
        dataBrowserCallbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        dataBrowserCallbacks.v1_itemCompareCallback = this.display.itemCompareProc;
        OS.SetDataBrowserCallbacks(this.handle, dataBrowserCallbacks);
        if ((this.style & 0x10000000) != 0 && this.sortColumn != null && !this.sortColumn.isDisposed() && this.sortDirection == 1024) {
            OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
        }
        this.setRedraw(true);
        if (n3 == 0 && treeItem != null) {
            treeItem.redraw(0);
        }
    }

    void setItemHeight(int n) {
        this.checkWidget();
        if (n < -1) {
            this.error(5);
        }
        if (n != -1) {
            OS.SetDataBrowserTableViewRowHeight(this.handle, (short)n);
        }
    }

    void setItemHeight(Image image) {
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = image != null ? image.getBounds() : this.imageBounds;
        if (rectangle == null) {
            return;
        }
        this.imageBounds = rectangle;
        short[] sArray = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight(this.handle, sArray) == 0 && sArray[0] < rectangle.height) {
            OS.SetDataBrowserTableViewRowHeight(this.handle, (short)rectangle.height);
        }
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        if (OS.VERSION >= 4160) {
            int n = 6;
            OS.DataBrowserChangeAttributes(this.handle, bl ? n : 0, !bl ? n : 0);
            this.redraw();
        }
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0) {
            this.setScrollWidth(true);
        }
    }

    boolean setScrollWidth(TreeItem treeItem) {
        if (this.ignoreRedraw || this.drawCount != 0) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        TreeItem treeItem2 = treeItem.parentItem;
        if (treeItem2 != null && !treeItem2._getExpanded()) {
            return false;
        }
        GC gC = new GC(this);
        int n = treeItem.calculateWidth(0, gC);
        gC.dispose();
        short[] sArray = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, sArray);
        if (sArray[0] < (n += this.getInsetWidth(this.column_id, false))) {
            OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)n);
            return true;
        }
        return false;
    }

    boolean setScrollBarVisible(ScrollBar scrollBar, boolean bl) {
        boolean[] blArray = new boolean[1];
        boolean[] blArray2 = new boolean[1];
        OS.GetDataBrowserHasScrollBars(this.handle, blArray, blArray2);
        if ((scrollBar.style & 0x100) != 0) {
            blArray[0] = bl;
        }
        if ((scrollBar.style & 0x200) != 0) {
            blArray2[0] = bl;
        }
        if (!bl) {
            scrollBar.redraw();
            scrollBar.deregister();
        }
        if (OS.SetDataBrowserHasScrollBars(this.handle, blArray[0], blArray2[0]) == 0) {
            if (bl) {
                scrollBar.handle = this.findStandardBar(scrollBar.style);
                scrollBar.register();
                scrollBar.hookEvents();
                scrollBar.redraw();
            } else {
                scrollBar.handle = 0;
            }
            return true;
        }
        if (!bl) {
            scrollBar.register();
        }
        return false;
    }

    boolean setScrollWidth(boolean bl) {
        return this.setScrollWidth(bl, this.childIds, true);
    }

    boolean setScrollWidth(boolean bl, int[] nArray, boolean bl2) {
        if (this.ignoreRedraw || this.drawCount != 0) {
            return false;
        }
        if (this.columnCount != 0 || nArray == null) {
            return false;
        }
        GC gC = new GC(this);
        int n = this.calculateWidth(nArray, gC, bl2, 0, 0);
        gC.dispose();
        n += this.getInsetWidth(this.column_id, false);
        if (!bl) {
            short[] sArray = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, sArray);
            if (sArray[0] >= n) {
                return false;
            }
        }
        OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)n);
        return true;
    }

    public void setSelection(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{treeItem});
    }

    public void setSelection(TreeItem[] treeItemArray) {
        this.checkWidget();
        if (treeItemArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = treeItemArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int n2 = 0;
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n) {
            if (treeItemArray[n3] != null) {
                if (treeItemArray[n3].isDisposed()) {
                    this.error(5);
                }
                nArray[n2++] = treeItemArray[n3].id;
                this.showItem(treeItemArray[n3], false);
            }
            ++n3;
        }
        this.ignoreSelect = true;
        int[] nArray2 = null;
        if ((this.style & 4) != 0) {
            nArray2 = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, nArray2);
            OS.SetDataBrowserSelectionFlags(this.handle, nArray2[0] & 0xFFFFFFBF);
        }
        OS.SetDataBrowserSelectedItems(this.handle, n2, nArray, 1);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, nArray2[0]);
        }
        this.ignoreSelect = false;
        if (n > 0) {
            int n4 = -1;
            int n5 = 0;
            while (n5 < treeItemArray.length) {
                if (treeItemArray[n5] != null) {
                    n4 = n5;
                    break;
                }
                ++n5;
            }
            if (n4 != -1) {
                this.showItem(treeItemArray[n4], true);
            }
        }
    }

    public void setSortColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn != null && treeColumn.isDisposed()) {
            this.error(5);
        }
        if (treeColumn == this.sortColumn) {
            return;
        }
        if (treeColumn == null && this.sortColumn != null && !this.sortColumn.isDisposed() && this.sortDirection != 0) {
            OS.SetDataBrowserSortOrder(this.handle, (short)1);
            this.sortColumn = null;
            OS.SetDataBrowserSortProperty(this.handle, 0);
        }
        this.sortColumn = treeColumn;
        if (this.sortColumn != null && !this.sortColumn.isDisposed() && this.sortDirection != 0) {
            OS.SetDataBrowserSortProperty(this.handle, this.sortColumn.id);
            int n = this.sortDirection == 1024 ? 2 : 1;
            OS.SetDataBrowserSortOrder(this.handle, (short)n);
        }
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        if (n == this.sortDirection) {
            return;
        }
        this.sortDirection = n;
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            if (this.sortDirection == 0) {
                OS.SetDataBrowserSortOrder(this.handle, (short)1);
                TreeColumn treeColumn = this.sortColumn;
                this.sortColumn = null;
                OS.SetDataBrowserSortProperty(this.handle, 0);
                this.sortColumn = treeColumn;
            } else {
                OS.SetDataBrowserSortProperty(this.handle, 0);
                OS.SetDataBrowserSortProperty(this.handle, this.sortColumn.id);
                int n2 = this.sortDirection == 1024 ? 2 : 1;
                OS.SetDataBrowserSortOrder(this.handle, (short)n2);
            }
        }
    }

    public void setTopItem(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.showItem(treeItem, false);
        int n = this.getItemHeight();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, nArray, nArray2);
        int[] nArray3 = new int[1];
        OS.GetDataBrowserTableViewItemRow(this.handle, treeItem.id, nArray3);
        nArray[0] = Math.max(0, Math.min(n * this.visibleCount + this.getHeaderHeight() - this.getClientArea().height, nArray3[0] * n));
        OS.SetDataBrowserScrollPosition(this.handle, nArray[0], treeItem.parentItem != null ? nArray2[0] : 0);
    }

    public void showColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        if (treeColumn.parent != this) {
            return;
        }
        int n = this.indexOf(treeColumn);
        if (this.columnCount <= 1 || n < 0 || n >= this.columnCount) {
            return;
        }
        short[] sArray = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, treeColumn.id, sArray);
        int n2 = sArray[0];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            sArray = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.columns[n4].id, sArray);
            n3 += sArray[0];
            ++n4;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, nArray, nArray2);
        if (n3 < nArray2[0]) {
            OS.SetDataBrowserScrollPosition(this.handle, nArray[0], n3);
        } else {
            Rectangle rectangle = this.getClientArea();
            int n5 = rectangle.width;
            if (n3 + (n2 = Math.min(n2, n5)) > nArray2[0] + n5) {
                nArray2[0] = n3 + n2 - n5;
                OS.SetDataBrowserScrollPosition(this.handle, nArray[0], nArray2[0]);
            }
        }
    }

    public void showItem(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.showItem(treeItem, true);
    }

    void showItem(TreeItem treeItem, boolean bl) {
        int n = 0;
        TreeItem treeItem2 = treeItem.parentItem;
        while (treeItem2 != null && !treeItem2._getExpanded()) {
            ++n;
            treeItem2 = treeItem2.parentItem;
        }
        int n2 = 0;
        treeItem2 = treeItem.parentItem;
        TreeItem[] treeItemArray = new TreeItem[n];
        while (treeItem2 != null && !treeItem2._getExpanded()) {
            treeItemArray[n2++] = treeItem2;
            treeItem2 = treeItem2.parentItem;
        }
        int n3 = treeItemArray.length - 1;
        while (n3 >= 0) {
            treeItemArray[n3].setExpanded(true);
            --n3;
        }
        if (bl) {
            Rectangle rectangle = this.getClientArea();
            if (rectangle.height < this.getItemHeight() || !OS.IsControlVisible(this.handle)) {
                this.showItem = treeItem;
                return;
            }
            this.showItem = null;
            Rectangle rectangle2 = treeItem.getBounds();
            if (!rectangle2.isEmpty() && rectangle.contains(rectangle2.x, rectangle2.y) && rectangle.contains(rectangle2.x, rectangle2.y + rectangle2.height)) {
                return;
            }
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.GetDataBrowserScrollPosition(this.handle, nArray, nArray2);
            int n4 = (this.style & 0x20) != 0 ? 1024 : (this.columnCount == 0 ? this.column_id : this.columns[0].id);
            int n5 = 2;
            OS.RevealDataBrowserItem(this.handle, treeItem.id, n4, (byte)n5);
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            if (this.columnCount == 0) {
                int n6;
                boolean bl2 = false;
                Rect rect = new Rect();
                if (OS.GetDataBrowserItemPartBounds(this.handle, treeItem.id, n4, 0x2D2D2D2D, rect) == 0) {
                    boolean bl3 = bl2 = rect.left < rectangle.x || rect.left >= rectangle.x + rectangle.width;
                    if (!bl2) {
                        GC gC = new GC(this);
                        n6 = this.calculateWidth(new int[]{treeItem.id}, gC, false, 0, 0);
                        gC.dispose();
                        boolean bl4 = bl2 = rect.left + n6 > rectangle.x + rectangle.width;
                    }
                }
                if (bl2) {
                    Object object;
                    int n7 = this.getLeftDisclosureInset(n4);
                    n6 = 24;
                    if (OS.VERSION >= 4160) {
                        object = new float[1];
                        OS.DataBrowserGetMetric(this.handle, 5, null, (float[])object);
                        n6 = (int)object[0];
                    }
                    object = treeItem;
                    while (((TreeItem)object).parentItem != null) {
                        n7 += n6;
                        object = ((TreeItem)object).parentItem;
                    }
                    OS.GetDataBrowserScrollPosition(this.handle, nArray3, nArray4);
                    OS.SetDataBrowserScrollPosition(this.handle, nArray3[0], n7);
                }
            }
            OS.GetDataBrowserScrollPosition(this.handle, nArray3, nArray4);
            if (this.horizontalBar != null && nArray4[0] != nArray2[0]) {
                this.horizontalBar.redraw();
            }
            if (this.verticalBar != null && nArray3[0] != nArray[0]) {
                this.verticalBar.redraw();
            }
        }
    }

    public void showSelection() {
        this.checkWidget();
        TreeItem[] treeItemArray = this.getSelection();
        if (treeItemArray.length > 0) {
            this.showItem(treeItemArray[0], true);
        }
    }

    int trackingProc(int n, int n2, int n3, int n4, int n5, int n6) {
        return 1;
    }
}

