/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.musicxml;

import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.player.base.MidiInstrument;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGTupleto;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MusicXMLWriter {
    private static final String[] NOTE_NAMES = new String[]{"C", "D", "E", "F", "G", "A", "B"};
    private static final int[] NOTE_SHARPS = new int[]{0, 0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6};
    private static final int[] NOTE_FLATS = new int[]{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 6};
    private static final boolean[] NOTE_ALTERATIONS = new boolean[]{false, true, false, true, false, false, true, false, true, false, true, false};
    private static final String[] DURATION_NAMES = new String[]{"whole", "half", "quarter", "eighth", "16th", "32nd", "64th"};
    private static final int DURATION_DIVISIONS = 960;
    private static final int[] DURATION_VALUES = new int[]{3840, 1920, 960, 480, 240, 120, 60};
    private TGSongManager manager;
    private OutputStream stream;
    private Document document;

    public MusicXMLWriter(OutputStream outputStream) {
        this.stream = outputStream;
    }

    public void writeSong(TGSong tGSong) throws TGFileFormatException {
        try {
            this.manager = new TGSongManager();
            this.manager.setSong(tGSong);
            this.document = this.newDocument();
            Node node = this.addNode(this.document, "score-partwise");
            this.writeHeaders(node);
            this.writeSong(node);
            this.saveDocument();
            this.stream.flush();
            this.stream.close();
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException("Could not write song!.", throwable);
        }
    }

    private void writeHeaders(Node node) {
        this.writeWork(node);
        this.writeIdentification(node);
    }

    private void writeWork(Node node) {
        this.addNode(this.addNode(node, "work"), "work-title", this.manager.getSong().getName());
    }

    private void writeIdentification(Node node) {
        Node node2 = this.addNode(node, "identification");
        this.addNode(this.addNode(node2, "encoding"), "software", "TuxGuitar");
        this.addAttribute(this.addNode(node2, "creator", this.manager.getSong().getAuthor()), "type", "composer");
    }

    private void writeSong(Node node) {
        this.writePartList(node);
        this.writeParts(node);
    }

    private void writePartList(Node node) {
        Node node2 = this.addNode(node, "part-list");
        Iterator iterator = this.manager.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            Node node3 = this.addNode(node2, "score-part");
            this.addAttribute(node3, "id", "P" + tGTrack.getNumber());
            this.addNode(node3, "part-name", tGTrack.getName());
            Node node4 = this.addAttribute(this.addNode(node3, "score-instrument"), "id", "P" + tGTrack.getNumber() + "-I1");
            this.addNode(node4, "instrument-name", MidiInstrument.INSTRUMENT_LIST[tGTrack.getChannel().getInstrument()].getName());
            Node node5 = this.addAttribute(this.addNode(node3, "midi-instrument"), "id", "P" + tGTrack.getNumber() + "-I1");
            this.addNode(node5, "midi-channel", Integer.toString(tGTrack.getChannel().getChannel() + 1));
            this.addNode(node5, "midi-program", Integer.toString(tGTrack.getChannel().getInstrument() + 1));
        }
    }

    private void writeParts(Node node) {
        Iterator iterator = this.manager.getSong().getTracks();
        while (iterator.hasNext()) {
            TGTrack tGTrack = (TGTrack)iterator.next();
            Node node2 = this.addAttribute(this.addNode(node, "part"), "id", "P" + tGTrack.getNumber());
            TGMeasure tGMeasure = null;
            Iterator iterator2 = tGTrack.getMeasures();
            while (iterator2.hasNext()) {
                TGMeasure tGMeasure2 = (TGMeasure)iterator2.next();
                Node node3 = this.addAttribute(this.addNode(node2, "measure"), "number", Integer.toString(tGMeasure2.getNumber()));
                this.writeMeasureAttributes(node3, tGMeasure2, tGMeasure);
                this.writeDirection(node3, tGMeasure2, tGMeasure);
                this.writeBeats(node3, tGMeasure2);
                tGMeasure = tGMeasure2;
            }
        }
    }

    private void writeMeasureAttributes(Node node, TGMeasure tGMeasure, TGMeasure tGMeasure2) {
        boolean bl;
        boolean bl2 = tGMeasure2 == null;
        boolean bl3 = tGMeasure2 == null || tGMeasure.getKeySignature() != tGMeasure2.getKeySignature();
        boolean bl4 = tGMeasure2 == null || tGMeasure.getClef() != tGMeasure2.getClef();
        boolean bl5 = tGMeasure2 == null || !tGMeasure.getTimeSignature().isEqual(tGMeasure2.getTimeSignature());
        boolean bl6 = bl = tGMeasure.getNumber() == 1;
        if (bl2 || bl3 || bl4 || bl5) {
            Node node2 = this.addNode(node, "attributes");
            if (bl2) {
                this.addNode(node2, "divisions", Integer.toString(960));
            }
            if (bl3) {
                this.writeKeySignature(node2, tGMeasure.getKeySignature());
            }
            if (bl4) {
                this.writeClef(node2, tGMeasure.getClef());
            }
            if (bl5) {
                this.writeTimeSignature(node2, tGMeasure.getTimeSignature());
            }
            if (bl) {
                this.writeTuning(node2, tGMeasure.getTrack());
            }
        }
    }

    private void writeTuning(Node node, TGTrack tGTrack) {
        Node node2 = this.addNode(node, "staff-details");
        this.addNode(node2, "staff-lines", Integer.toString(tGTrack.stringCount()));
        for (int i = tGTrack.stringCount(); i > 0; --i) {
            TGString tGString = tGTrack.getString(i);
            Node node3 = this.addNode(node2, "staff-tuning");
            this.addAttribute(node3, "line", Integer.toString(tGTrack.stringCount() - tGString.getNumber() + 1));
            this.addNode(node3, "tuning-step", NOTE_NAMES[NOTE_SHARPS[tGString.getValue() % 12]]);
            this.addNode(node3, "tuning-octave", Integer.toString(tGString.getValue() / 12));
        }
    }

    private void writeTimeSignature(Node node, TGTimeSignature tGTimeSignature) {
        Node node2 = this.addNode(node, "time");
        this.addNode(node2, "beats", Integer.toString(tGTimeSignature.getNumerator()));
        this.addNode(node2, "beat-type", Integer.toString(tGTimeSignature.getDenominator().getValue()));
    }

    private void writeKeySignature(Node node, int n) {
        int n2 = n;
        if (n2 != 0) {
            n2 = ((n - 1) % 7 + 1) * (n > 7 ? -1 : 1);
        }
        Node node2 = this.addNode(node, "key");
        this.addNode(node2, "fifths", Integer.toString(n2));
        this.addNode(node2, "mode", "major");
    }

    private void writeClef(Node node, int n) {
        Node node2 = this.addNode(node, "clef");
        if (n == 1) {
            this.addNode(node2, "sign", "G");
            this.addNode(node2, "line", "2");
        } else if (n == 2) {
            this.addNode(node2, "sign", "F");
            this.addNode(node2, "line", "4");
        } else if (n == 3) {
            this.addNode(node2, "sign", "G");
            this.addNode(node2, "line", "2");
        } else if (n == 4) {
            this.addNode(node2, "sign", "G");
            this.addNode(node2, "line", "2");
        }
    }

    private void writeDirection(Node node, TGMeasure tGMeasure, TGMeasure tGMeasure2) {
        boolean bl;
        boolean bl2 = bl = tGMeasure2 == null || tGMeasure.getTempo().getValue() != tGMeasure2.getTempo().getValue();
        if (bl) {
            Node node2 = this.addAttribute(this.addNode(node, "direction"), "placement", "above");
            this.writeMeasureTempo(node2, tGMeasure.getTempo());
        }
    }

    private void writeMeasureTempo(Node node, TGTempo tGTempo) {
        this.addAttribute(this.addNode(node, "sound"), "tempo", Integer.toString(tGTempo.getValue()));
    }

    private void writeBeats(Node node, TGMeasure tGMeasure) {
        int n = tGMeasure.getKeySignature();
        int n2 = tGMeasure.countBeats();
        for (int i = 0; i < n2; ++i) {
            TGBeat tGBeat = tGMeasure.getBeat(i);
            if (tGBeat.isRestBeat()) {
                Node node2 = this.addNode(node, "note");
                this.addNode(node2, "rest");
                this.addNode(node2, "voice", "1");
                this.writeDuration(node2, tGBeat.getDuration());
                continue;
            }
            int n3 = tGBeat.countNotes();
            for (int j = 0; j < n3; ++j) {
                TGNote tGNote = tGBeat.getNote(j);
                Node node3 = this.addNode(node, "note");
                int n4 = tGNote.getBeat().getMeasure().getTrack().getString(tGNote.getString()).getValue() + tGNote.getValue();
                Node node4 = this.addNode(node3, "pitch");
                this.addNode(node4, "step", NOTE_NAMES[n <= 7 ? NOTE_SHARPS[n4 % 12] : NOTE_FLATS[n4 % 12]]);
                this.addNode(node4, "octave", Integer.toString(n4 / 12));
                if (NOTE_ALTERATIONS[n4 % 12]) {
                    this.addNode(node4, "alter", n <= 7 ? "1" : "-1");
                }
                Node node5 = this.addNode(this.addNode(node3, "notations"), "technical");
                this.addNode(node5, "fret", Integer.toString(tGNote.getValue()));
                this.addNode(node5, "string", Integer.toString(tGNote.getString()));
                this.addNode(node3, "voice", "1");
                this.writeDuration(node3, tGBeat.getDuration());
                if (tGNote.isTiedNote()) {
                    this.addAttribute(this.addNode(node3, "tie"), "type", "stop");
                }
                if (j <= 0) continue;
                this.addNode(node3, "chord");
            }
        }
    }

    private void writeDuration(Node node, TGDuration tGDuration) {
        int n = tGDuration.getIndex();
        if (n >= 0 && n <= 6) {
            int n2 = DURATION_VALUES[n] * tGDuration.getTupleto().getTimes() / tGDuration.getTupleto().getEnters();
            if (tGDuration.isDotted()) {
                n2 += n2 / 2;
            } else if (tGDuration.isDoubleDotted()) {
                n2 += n2 / 4 * 3;
            }
            this.addNode(node, "duration", Integer.toString(n2));
            this.addNode(node, "type", DURATION_NAMES[n]);
            if (tGDuration.isDotted()) {
                this.addNode(node, "dot");
            } else if (tGDuration.isDoubleDotted()) {
                this.addNode(node, "dot");
                this.addNode(node, "dot");
            }
            if (!tGDuration.getTupleto().isEqual(TGTupleto.NORMAL)) {
                Node node2 = this.addNode(node, "time-modification");
                this.addNode(node2, "actual-notes", Integer.toString(tGDuration.getTupleto().getEnters()));
                this.addNode(node2, "normal-notes", Integer.toString(tGDuration.getTupleto().getTimes()));
            }
        }
    }

    private Node addAttribute(Node node, String string, String string2) {
        Attr attr = this.document.createAttribute(string);
        attr.setNodeValue(string2);
        node.getAttributes().setNamedItem(attr);
        return node;
    }

    private Node addNode(Node node, String string) {
        Element element = this.document.createElement(string);
        node.appendChild(element);
        return element;
    }

    private Node addNode(Node node, String string, String string2) {
        Node node2 = this.addNode(node, string);
        node2.setTextContent(string2);
        return node2;
    }

    private Document newDocument() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            return document;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private void saveDocument() {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(this.document);
            StreamResult streamResult = new StreamResult(this.stream);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

