/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.ptb.helper;

public class TrackStartHelper {
    private int section;
    private long[][] voices;
    private boolean measureEmpty;
    private boolean measureRest;
    private long barStart;
    private long barLength;

    public void init(int n, int n2) {
        this.section = n;
        this.voices = new long[n2][2];
        this.measureEmpty = true;
        this.measureRest = false;
        this.barStart = 0L;
        this.barLength = 0L;
    }

    public int getSection() {
        return this.section;
    }

    public void initVoices(long l) {
        for (int i = 0; i < this.voices.length; ++i) {
            for (int j = 0; j < this.voices[i].length; ++j) {
                this.voices[i][j] = this.fixValue(l);
            }
        }
        this.measureEmpty = true;
        this.measureRest = false;
    }

    public long getMaxStart() {
        long l = 960L;
        for (int i = 0; i < this.voices.length; ++i) {
            for (int j = 0; j < this.voices[i].length; ++j) {
                l = Math.max(l, this.voices[i][j]);
            }
        }
        if (this.measureRest && this.measureEmpty) {
            l = Math.max(l, this.barStart + this.barLength);
        }
        return this.fixValue(l);
    }

    public long getVoiceStart(int n, int n2) {
        return this.voices[n][n2];
    }

    public void setVoiceStart(int n, int n2, long l) {
        this.voices[n][n2] = this.fixValue(l);
    }

    public long getBarStart() {
        return this.barStart;
    }

    public void setBarStart(long l) {
        this.barStart = l;
    }

    public long getBarLength() {
        return this.barLength;
    }

    public void setBarLength(long l) {
        this.barLength = l;
    }

    public void checkBeat(boolean bl) {
        this.measureEmpty = this.measureEmpty && bl;
        this.measureRest = true;
    }

    public long fixValue(long l) {
        return l % 480L + 10L > 480L ? l + (480L - l % 480L) : l;
    }
}

