/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.midi.base;

public class MidiMessage {
    public static final int TYPE_SHORT = 1;
    public static final int TYPE_META = 2;
    public static final int NOTE_OFF = 128;
    public static final int NOTE_ON = 144;
    public static final int CONTROL_CHANGE = 176;
    public static final int PROGRAM_CHANGE = 192;
    public static final int PITCH_BEND = 224;
    public static final int SYSTEM_RESET = 255;
    public static final int TEMPO_CHANGE = 81;
    public static final int TIME_SIGNATURE_CHANGE = 88;
    private int message;
    private int command;
    private byte[] data;

    public MidiMessage(int n, int n2) {
        this.message = n;
        this.command = n2;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getType() {
        return this.message;
    }

    public int getCommand() {
        return this.command;
    }

    public static MidiMessage shortMessage(int n, int n2, int n3, int n4) {
        MidiMessage midiMessage = new MidiMessage(1, n);
        midiMessage.setData(new byte[]{(byte)(n & 0xF0 | n2 & 0xF), (byte)n3, (byte)n4});
        return midiMessage;
    }

    public static MidiMessage shortMessage(int n, int n2, int n3) {
        MidiMessage midiMessage = new MidiMessage(1, n);
        midiMessage.setData(new byte[]{(byte)(n & 0xF0 | n2 & 0xF), (byte)n3});
        return midiMessage;
    }

    public static MidiMessage shortMessage(int n) {
        MidiMessage midiMessage = new MidiMessage(1, n);
        midiMessage.setData(new byte[]{(byte)n});
        return midiMessage;
    }

    public static MidiMessage metaMessage(int n, byte[] byArray) {
        MidiMessage midiMessage = new MidiMessage(2, n);
        midiMessage.setData(byArray);
        return midiMessage;
    }
}

