/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.midi.base;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.io.midi.base.MidiEvent;
import org.herac.tuxguitar.io.midi.base.MidiMessage;
import org.herac.tuxguitar.io.midi.base.MidiTrack;

public class MidiSequence {
    public static final float PPQ = 0.0f;
    public static final float SMPTE_24 = 24.0f;
    public static final float SMPTE_25 = 25.0f;
    public static final float SMPTE_30DROP = 29.97f;
    public static final float SMPTE_30 = 30.0f;
    protected float divisionType;
    protected int resolution;
    private List tracks;

    public MidiSequence(float f, int n) {
        this.divisionType = f;
        this.resolution = n;
        this.tracks = new ArrayList();
    }

    public void addTrack(MidiTrack midiTrack) {
        this.tracks.add(midiTrack);
    }

    public MidiTrack getTrack(int n) {
        return (MidiTrack)this.tracks.get(n);
    }

    public int countTracks() {
        return this.tracks.size();
    }

    public float getDivisionType() {
        return this.divisionType;
    }

    public int getResolution() {
        return this.resolution;
    }

    public void sort() {
        for (int i = 0; i < this.tracks.size(); ++i) {
            MidiTrack midiTrack = (MidiTrack)this.tracks.get(i);
            midiTrack.sort();
        }
    }

    public void finish() {
        for (int i = 0; i < this.tracks.size(); ++i) {
            MidiTrack midiTrack = (MidiTrack)this.tracks.get(i);
            midiTrack.add(new MidiEvent(MidiMessage.metaMessage(47, new byte[0]), midiTrack.ticks()));
            midiTrack.sort();
        }
    }
}

