/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.browser.ftp;

import org.herac.tuxguitar.gui.tools.browser.base.TGBrowserData;
import org.herac.tuxguitar.gui.tools.browser.ftp.utils.Base64Decoder;
import org.herac.tuxguitar.gui.tools.browser.ftp.utils.Base64Encoder;

public class TGBrowserDataImpl
implements TGBrowserData {
    private static final String STRING_SEPARATOR = ";";
    private String host;
    private String path;
    private String username;
    private String password;

    public TGBrowserDataImpl(String string, String string2, String string3, String string4) {
        this.host = string;
        this.path = string2;
        this.username = string3;
        this.password = string4;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getPassword() {
        return this.username != null && this.username.length() > 0 ? this.password : "anonymous";
    }

    public String getUsername() {
        return this.username != null && this.username.length() > 0 ? this.username : "anonymous";
    }

    public String getTitle() {
        return this.getHost() + ":" + this.getPath();
    }

    public String toString() {
        String string = new String(Base64Encoder.encode(this.getUsername().getBytes()));
        String string2 = new String(Base64Encoder.encode(this.getPassword().getBytes()));
        return this.getHost() + STRING_SEPARATOR + this.getPath() + STRING_SEPARATOR + string + STRING_SEPARATOR + string2;
    }

    public static TGBrowserData fromString(String string) {
        String[] stringArray = string.split(STRING_SEPARATOR);
        if (stringArray.length == 4) {
            String string2 = new String(Base64Decoder.decode(stringArray[2].getBytes()));
            String string3 = new String(Base64Decoder.decode(stringArray[3].getBytes()));
            return new TGBrowserDataImpl(stringArray[0], stringArray[1], string2, string3);
        }
        return null;
    }
}

