/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.tools.browser.ftp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.gui.tools.browser.TGBrowserException;
import org.herac.tuxguitar.gui.tools.browser.base.TGBrowser;
import org.herac.tuxguitar.gui.tools.browser.base.TGBrowserElement;
import org.herac.tuxguitar.gui.tools.browser.ftp.TGBrowserDataImpl;
import org.herac.tuxguitar.gui.tools.browser.ftp.TGBrowserElementImpl;
import sun.net.ftp.FtpClient;

public class TGBrowserImpl
extends TGBrowser {
    private TGBrowserDataImpl data;
    private String root;
    private String path;
    private FtpClient client;

    public TGBrowserImpl(TGBrowserDataImpl tGBrowserDataImpl) {
        this.data = tGBrowserDataImpl;
    }

    private String getRoot() {
        if (this.root == null) {
            this.root = "/";
            if (this.data.getPath() != null && this.data.getPath().length() > 0) {
                this.root = this.data.getPath();
            }
        }
        return this.root;
    }

    public void open() throws TGBrowserException {
        try {
            this.client = new FtpClient();
            this.client.openServer(this.data.getHost());
            this.client.login(this.data.getUsername(), this.data.getPassword());
            this.cdRoot();
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
    }

    public void close() throws TGBrowserException {
        try {
            this.client.closeServer();
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
    }

    public void cdElement(TGBrowserElement tGBrowserElement) throws TGBrowserException {
        try {
            this.client.cd(tGBrowserElement.getName());
            this.path = this.client.pwd();
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
    }

    public void cdRoot() throws TGBrowserException {
        try {
            this.client.cd(this.getRoot());
            this.path = this.client.pwd();
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
    }

    public void cdUp() throws TGBrowserException {
        try {
            this.client.cdUp();
            this.path = this.client.pwd();
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
    }

    public List listElements() throws TGBrowserException {
        ArrayList<TGBrowserElementImpl> arrayList = new ArrayList<TGBrowserElementImpl>();
        try {
            this.client.ascii();
            String[] stringArray = this.parseString(this.client.nameList(this.path)).split("\n");
            String[] stringArray2 = this.parseString(this.client.list()).split("\n");
            if (stringArray.length > 0 && stringArray2.length > 0) {
                block2: for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i].trim();
                    if (string.indexOf(this.path) == 0 && string.length() > this.path.length() + 2) {
                        string = string.substring(this.path.length() + 1);
                    }
                    for (int j = 0; j < stringArray2.length; ++j) {
                        String string2 = stringArray2[j].trim();
                        if (string2.indexOf(string) <= 0) continue;
                        arrayList.add(new TGBrowserElementImpl(this, string, string2, this.path));
                        continue block2;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
        return arrayList;
    }

    public InputStream getInputStream(String string, TGBrowserElement tGBrowserElement) throws TGBrowserException {
        try {
            this.client.cd(string);
            this.client.binary();
            byte[] byArray = this.getByteBuffer(this.client.get(tGBrowserElement.getName()), false);
            this.client.ascii();
            return new ByteArrayInputStream(byArray);
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
    }

    private String parseString(InputStream inputStream) throws TGBrowserException {
        try {
            byte[] byArray = this.getByteBuffer(inputStream, true);
            return new String(byArray);
        }
        catch (Throwable throwable) {
            throw new TGBrowserException(throwable);
        }
    }

    private byte[] getByteBuffer(InputStream inputStream, boolean bl) throws IOException {
        if (!bl || inputStream.available() > 0) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            inputStream.close();
            byteArrayOutputStream.close();
            byteArrayOutputStream.flush();
            return byArray;
        }
        inputStream.close();
        return new byte[0];
    }
}

