/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui;

import java.net.URL;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.actions.ActionManager;
import org.herac.tuxguitar.gui.actions.file.FileActionUtils;
import org.herac.tuxguitar.gui.editors.EditorCache;
import org.herac.tuxguitar.gui.editors.FretBoardEditor;
import org.herac.tuxguitar.gui.editors.PianoEditor;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.chord.CustomChordManager;
import org.herac.tuxguitar.gui.editors.lyric.LyricEditor;
import org.herac.tuxguitar.gui.editors.matrix.MatrixEditor;
import org.herac.tuxguitar.gui.editors.tab.TGFactoryImpl;
import org.herac.tuxguitar.gui.helper.FileHistory;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.items.ItemManager;
import org.herac.tuxguitar.gui.marker.MarkerList;
import org.herac.tuxguitar.gui.mixer.TGMixer;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.gui.system.config.TGConfigManagerImpl;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.icons.IconManager;
import org.herac.tuxguitar.gui.system.keybindings.KeyBindingActionManager;
import org.herac.tuxguitar.gui.system.language.LanguageManager;
import org.herac.tuxguitar.gui.system.plugins.TGPluginManager;
import org.herac.tuxguitar.gui.table.TGTableViewer;
import org.herac.tuxguitar.gui.tools.browser.dialog.TGBrowserDialog;
import org.herac.tuxguitar.gui.tools.scale.ScaleManager;
import org.herac.tuxguitar.gui.transport.TGTransport;
import org.herac.tuxguitar.gui.undo.UndoableManager;
import org.herac.tuxguitar.gui.util.ArgumentParser;
import org.herac.tuxguitar.gui.util.TGFileUtils;
import org.herac.tuxguitar.gui.util.TGSplash;
import org.herac.tuxguitar.gui.util.WindowTitleUtil;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.impl.sequencer.MidiSequencerProviderImpl;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.util.TGLock;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TuxGuitar {
    public static final String APPLICATION_NAME = "TuxGuitar";
    public static final int MARGIN_WIDTH = 5;
    private static TuxGuitar instance;
    private TGLock lock = new TGLock();
    private Display display;
    private Shell shell;
    private MidiPlayer player;
    private TGSongManager songManager;
    private TGConfigManager configManager;
    private LanguageManager languageManager;
    private KeyBindingActionManager keyBindingManager;
    private IconManager iconManager;
    private EditorCache editorCache;
    private TablatureEditor tablatureEditor;
    private TGTableViewer table;
    private TGMixer songMixer;
    private TGTransport songTransport;
    private FretBoardEditor fretBoardEditor;
    private PianoEditor pianoEditor;
    private MatrixEditor matrixEditor;
    private LyricEditor lyricEditor;
    private TGBrowserDialog browser;
    private UndoableManager undoableManager;
    private ScaleManager scaleManager;
    private ActionManager actionManager;
    private ItemManager itemManager;
    private CustomChordManager customChordManager;
    private FileHistory fileHistory;
    private TGPluginManager pluginManager;
    protected Sash sash;
    protected Composite sashComposite;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TuxGuitar instance() {
        if (instance == null) {
            Class clazz = TuxGuitar.class;
            synchronized (clazz) {
                instance = new TuxGuitar();
            }
        }
        return instance;
    }

    private void initSynchronizer() {
        TGSynchronizer.instance().setController(new TGSynchronizer.TGSynchronizerController(){

            public void excecute(final TGSynchronizer.TGSynchronizerTask tGSynchronizerTask) {
                Display display = TuxGuitar.this.getDisplay();
                if (display != null && !display.isDisposed()) {
                    display.syncExec(new Runnable(){

                        public void run() {
                            tGSynchronizerTask.run();
                        }
                    });
                }
            }
        });
    }

    public void displayGUI(String[] stringArray) {
        ArgumentParser argumentParser = new ArgumentParser(stringArray);
        if (argumentParser.processAndExit()) {
            return;
        }
        TGFileUtils.loadLibraries();
        TGFileUtils.loadClasspath();
        this.display = new Display();
        this.initSynchronizer();
        TGSplash.instance().init();
        this.shell = new Shell(this.getDisplay());
        this.shell.setLayout(this.getShellLayout());
        this.shell.setImage(this.getIconManager().getAppIcon());
        this.createComposites(this.getShell());
        boolean bl = this.getConfig().getBooleanConfigValue("window.maximized");
        this.shell.setMaximized(bl);
        if (!bl) {
            int n = this.getConfig().getIntConfigValue("window.width");
            int n2 = this.getConfig().getIntConfigValue("window.height");
            if (n > 0 && n2 > 0) {
                this.shell.setSize(n, n2);
            }
        }
        this.shell.setMinimumSize(640, 480);
        this.showDefaultControls();
        this.updateCache(true);
        this.showTitle();
        this.getPluginManager().openPlugins();
        TGSplash.instance().finish();
        this.shell.addShellListener(this.getAction("action.system.dispose"));
        this.shell.open();
        this.startSong(argumentParser);
        while (!this.getDisplay().isDisposed() && !this.getShell().isDisposed()) {
            if (this.getDisplay().readAndDispatch()) continue;
            this.getDisplay().sleep();
        }
        this.getDisplay().dispose();
    }

    private FormLayout getShellLayout() {
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        return formLayout;
    }

    private void startSong(ArgumentParser argumentParser) {
        final URL uRL = argumentParser.getURL();
        if (uRL != null) {
            ActionLock.lock();
            new SyncThread(new Runnable(){

                public void run() {
                    TuxGuitar.instance().loadCursor(1);
                    new Thread(new Runnable(){

                        public void run() {
                            if (!TuxGuitar.isDisposed()) {
                                FileActionUtils.open(uRL);
                                TuxGuitar.instance().loadCursor(0);
                                ActionLock.unlock();
                            }
                        }
                    }).start();
                }
            }).start();
        }
    }

    public void createComposites(Composite composite) {
        this.sashComposite = new Composite(composite, 0);
        this.sashComposite.setLayout(new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(this.getItemManager().getCoolbar(), 5);
        formData.bottom = new FormAttachment(100, 0);
        this.sashComposite.setLayoutData(formData);
        this.sash = new Sash(this.sashComposite, 256);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, -150);
        this.sash.setLayoutData(formData);
        this.getTablatureEditor().showTablature(this.sashComposite);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(this.sash, 0);
        this.getTablatureEditor().getTablature().setLayoutData(formData);
        this.getTable().init(this.sashComposite);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(this.sash, 10);
        formData.bottom = new FormAttachment(100, 0);
        this.getTable().getComposite().setLayoutData(formData);
        this.sash.addMouseListener(new MouseAdapter(){

            public void mouseUp(MouseEvent mouseEvent) {
                TuxGuitar.this.sashComposite.layout(true, true);
            }
        });
        this.sash.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = TuxGuitar.this.sashComposite.getBounds().height - TuxGuitar.this.sash.getBounds().height;
                int n2 = n - selectionEvent.y;
                n2 = Math.max(n2, 0);
                n2 = Math.min(n2, n);
                ((FormData)TuxGuitar.this.sash.getLayoutData()).bottom = new FormAttachment(100, -n2);
            }
        });
        this.sashComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                FormData formData = (FormData)TuxGuitar.this.sash.getLayoutData();
                int n = -formData.bottom.offset;
                int n2 = TuxGuitar.this.sashComposite.getBounds().height - TuxGuitar.this.sash.getBounds().height;
                if (n > n2) {
                    formData.bottom = new FormAttachment(100, -n2);
                }
            }
        });
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(this.sashComposite, 0);
        formData.bottom = new FormAttachment(100, 0);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(new FormLayout());
        composite2.setLayoutData(formData);
        this.getFretBoardEditor().showFretBoard(composite2);
    }

    public void showDefaultControls() {
        TGConfigManager tGConfigManager = this.getConfig();
        if (tGConfigManager.getBooleanConfigValue("show.fretboard")) {
            this.getFretBoardEditor().showFretBoard();
        } else {
            this.getFretBoardEditor().hideFretBoard();
        }
        if (tGConfigManager.getBooleanConfigValue("show.mixer")) {
            new SyncThread(new Runnable(){

                public void run() {
                    TuxGuitar.this.getMixer().show();
                }
            }).start();
        }
        if (tGConfigManager.getBooleanConfigValue("show.transport")) {
            new SyncThread(new Runnable(){

                public void run() {
                    TuxGuitar.this.getTransport().show();
                }
            }).start();
        }
        if (tGConfigManager.getBooleanConfigValue("show.matrix")) {
            new SyncThread(new Runnable(){

                public void run() {
                    TuxGuitar.this.getMatrixEditor().show();
                }
            }).start();
        }
        if (tGConfigManager.getBooleanConfigValue("show.piano")) {
            new SyncThread(new Runnable(){

                public void run() {
                    TuxGuitar.this.getPianoEditor().show();
                }
            }).start();
        }
        if (tGConfigManager.getBooleanConfigValue("show.markers")) {
            new SyncThread(new Runnable(){

                public void run() {
                    MarkerList.instance().show();
                }
            }).start();
        }
    }

    public void setTableHeight(int n) {
        int n2 = ((FormData)this.getTable().getComposite().getLayoutData()).top.offset;
        int n3 = this.sash.getBounds().height;
        int n4 = this.sashComposite.getBounds().height - n3;
        int n5 = n + n3 + n2;
        n5 = Math.max(n5, 0);
        n5 = Math.min(n5, n4);
        ((FormData)this.sash.getLayoutData()).bottom = new FormAttachment(100, -n5);
        this.sashComposite.layout(true, true);
    }

    public void updateShellFooter(int n, int n2, int n3) {
        FormData formData = (FormData)this.sashComposite.getLayoutData();
        formData.bottom.offset = -n;
        this.getShell().setMinimumSize(Math.max(640, n2), Math.max(480, n3));
        this.getShell().layout(true, true);
        this.getShell().redraw();
    }

    public TGTableViewer getTable() {
        if (this.table == null) {
            this.table = new TGTableViewer();
        }
        return this.table;
    }

    public TablatureEditor getTablatureEditor() {
        if (this.tablatureEditor == null) {
            this.tablatureEditor = new TablatureEditor();
        }
        return this.tablatureEditor;
    }

    public FretBoardEditor getFretBoardEditor() {
        if (this.fretBoardEditor == null) {
            this.fretBoardEditor = new FretBoardEditor();
        }
        return this.fretBoardEditor;
    }

    public PianoEditor getPianoEditor() {
        if (this.pianoEditor == null) {
            this.pianoEditor = new PianoEditor();
        }
        return this.pianoEditor;
    }

    public MatrixEditor getMatrixEditor() {
        if (this.matrixEditor == null) {
            this.matrixEditor = new MatrixEditor();
        }
        return this.matrixEditor;
    }

    public TGSongManager getSongManager() {
        if (this.songManager == null) {
            this.songManager = new TGSongManager(new TGFactoryImpl());
            this.songManager.setSong(this.songManager.newSong());
        }
        return this.songManager;
    }

    public TGMixer getMixer() {
        if (this.songMixer == null) {
            this.songMixer = new TGMixer();
        }
        return this.songMixer;
    }

    public TGTransport getTransport() {
        if (this.songTransport == null) {
            this.songTransport = new TGTransport();
        }
        return this.songTransport;
    }

    public EditorCache getEditorCache() {
        if (this.editorCache == null) {
            this.editorCache = new EditorCache();
        }
        return this.editorCache;
    }

    public LyricEditor getLyricEditor() {
        if (this.lyricEditor == null) {
            this.lyricEditor = new LyricEditor();
        }
        return this.lyricEditor;
    }

    public TGBrowserDialog getBrowser() {
        if (this.browser == null) {
            this.browser = new TGBrowserDialog();
        }
        return this.browser;
    }

    public UndoableManager getUndoableManager() {
        if (this.undoableManager == null) {
            this.undoableManager = new UndoableManager();
        }
        return this.undoableManager;
    }

    public ScaleManager getScaleManager() {
        if (this.scaleManager == null) {
            this.scaleManager = new ScaleManager();
        }
        return this.scaleManager;
    }

    public TGPluginManager getPluginManager() {
        if (this.pluginManager == null) {
            this.pluginManager = new TGPluginManager();
        }
        return this.pluginManager;
    }

    public IconManager getIconManager() {
        if (this.iconManager == null) {
            this.iconManager = new IconManager();
            this.iconManager.addLoader(new IconLoader(){

                public void loadIcons() {
                    TuxGuitar.this.getShell().setImage(TuxGuitar.this.getIconManager().getAppIcon());
                    TuxGuitar.this.getShell().layout(true);
                }
            });
        }
        return this.iconManager;
    }

    public CustomChordManager getCustomChordManager() {
        if (this.customChordManager == null) {
            this.customChordManager = new CustomChordManager();
        }
        return this.customChordManager;
    }

    public ItemManager getItemManager() {
        if (this.itemManager == null) {
            this.itemManager = new ItemManager();
        }
        return this.itemManager;
    }

    public ActionManager getActionManager() {
        if (this.actionManager == null) {
            this.actionManager = new ActionManager();
        }
        return this.actionManager;
    }

    public LanguageManager getLanguageManager() {
        if (this.languageManager == null) {
            this.languageManager = new LanguageManager();
            this.loadLanguage();
        }
        return this.languageManager;
    }

    public TGConfigManager getConfig() {
        if (this.configManager == null) {
            this.configManager = new TGConfigManagerImpl();
            this.configManager.init();
        }
        return this.configManager;
    }

    public KeyBindingActionManager getkeyBindingManager() {
        if (this.keyBindingManager == null) {
            this.keyBindingManager = new KeyBindingActionManager();
        }
        return this.keyBindingManager;
    }

    public FileHistory getFileHistory() {
        if (this.fileHistory == null) {
            this.fileHistory = new FileHistory();
        }
        return this.fileHistory;
    }

    public MidiPlayer getPlayer() {
        if (this.player == null) {
            this.player = new MidiPlayer();
            this.player.init(this.getSongManager());
            try {
                this.getPlayer().openSequencer(this.getConfig().getStringConfigValue("midi.sequencer"));
                this.getPlayer().openPort(this.getConfig().getStringConfigValue("midi.port"));
                this.getPlayer().addSequencerProvider(new MidiSequencerProviderImpl());
            }
            catch (MidiPlayerException midiPlayerException) {
                midiPlayerException.printStackTrace();
            }
        }
        return this.player;
    }

    public void showTitle() {
        new SyncThread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    TuxGuitar.this.getShell().setText(WindowTitleUtil.parseTitle());
                }
            }
        }).start();
    }

    public void updateCache(final boolean bl) {
        if (!this.isLocked()) {
            this.lock();
            this.getEditorCache().updateEditMode();
            this.unlock();
            new SyncThread(new Runnable(){

                public void run() {
                    if (!TuxGuitar.isDisposed() && !TuxGuitar.this.isLocked()) {
                        if (bl) {
                            TuxGuitar.this.lock();
                            TuxGuitar.this.getItemManager().updateItems();
                            TuxGuitar.this.getTransport().updateItems();
                            TuxGuitar.this.getMixer().updateItems();
                            TuxGuitar.this.getLyricEditor().updateItems();
                            TuxGuitar.this.getTable().updateItems();
                            TuxGuitar.this.unlock();
                        }
                        TuxGuitar.this.redraw();
                    }
                }
            }).start();
        }
    }

    protected void redraw() {
        if (!TuxGuitar.isDisposed() && !this.isLocked()) {
            this.lock();
            this.getTablatureEditor().getTablature().redraw();
            this.getFretBoardEditor().redraw();
            this.getPianoEditor().redraw();
            this.getTable().redraw();
            this.getMatrixEditor().redraw();
            this.unlock();
        }
    }

    public void redrawPayingMode() {
        if (!TuxGuitar.isDisposed() && !this.isLocked()) {
            this.lock();
            this.getEditorCache().updatePlayMode();
            if (this.getEditorCache().shouldRedraw()) {
                this.getTablatureEditor().getTablature().redrawPlayingMode();
                this.getFretBoardEditor().redrawPlayingMode();
                this.getPianoEditor().redrawPlayingMode();
                this.getTable().redrawPlayingMode();
                this.getMatrixEditor().redrawPlayingMode();
            }
            this.getTransport().redrawPlayingMode();
            this.unlock();
        }
    }

    public Display getDisplay() {
        return this.display;
    }

    public Shell getShell() {
        return this.shell;
    }

    public Action getAction(String string) {
        return this.getActionManager().getAction(string);
    }

    public static String getProperty(String string) {
        return TuxGuitar.instance().getLanguageManager().getProperty(string);
    }

    public static String getProperty(String string, String[] stringArray) {
        return TuxGuitar.instance().getLanguageManager().getProperty(string, stringArray);
    }

    public static boolean isDisposed() {
        return TuxGuitar.instance().getDisplay().isDisposed() || TuxGuitar.instance().getShell().isDisposed();
    }

    public void loadLanguage() {
        this.lock();
        this.getLanguageManager().setLanguage(this.getConfig().getStringConfigValue("language"));
        this.unlock();
    }

    public void loadToolBars() {
        this.lock();
        this.getItemManager().createCoolbar();
        this.unlock();
    }

    public void loadStyles() {
        this.lock();
        this.getTablatureEditor().getTablature().reloadStyles();
        this.unlock();
    }

    public void loadSkin() {
        this.lock();
        this.getIconManager().reloadIcons();
        this.unlock();
    }

    public void newSong() {
        TuxGuitar.instance().fireNewSong(TuxGuitar.instance().getSongManager().newSong(), null);
    }

    public void fireNewSong(TGSong tGSong, URL uRL) {
        this.lock();
        TuxGuitar.instance().getSongManager().setSong(tGSong);
        this.getFileHistory().reset(uRL);
        this.getPlayer().reset();
        this.getEditorCache().reset();
        this.getUndoableManager().discardAllEdits();
        this.getTablatureEditor().getTablature().updateTablature();
        this.getTablatureEditor().getTablature().resetScroll();
        this.getTablatureEditor().getTablature().initCaret();
        this.getTable().fireUpdate(true);
        this.getMixer().update();
        this.getLyricEditor().update();
        MarkerList.instance().update();
        this.unlock();
        this.updateCache(true);
        this.showTitle();
    }

    public void fireSaveSong(URL uRL) {
        this.lock();
        this.getFileHistory().reset(uRL);
        this.getEditorCache().reset();
        this.getUndoableManager().discardAllEdits();
        this.unlock();
        this.updateCache(true);
        this.showTitle();
    }

    public void fireUpdate() {
        this.lock();
        this.getEditorCache().reset();
        this.getTablatureEditor().getTablature().updateTablature();
        this.getTable().fireUpdate(false);
        this.getLyricEditor().update();
        this.unlock();
    }

    public void loadCursor(int n) {
        this.loadCursor(this.getShell(), n);
    }

    public void loadCursor(final Control control, final int n) {
        try {
            TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                public void run() throws Throwable {
                    if (!control.isDisposed()) {
                        control.setCursor(TuxGuitar.this.getDisplay().getSystemCursor(n));
                    }
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }
}

