/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.caret;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableAddMeasure;

public class GoRightAction
extends Action {
    public static final String NAME = "action.caret.go-right";

    public GoRightAction() {
        super(NAME, 7);
    }

    protected int execute(TypedEvent typedEvent) {
        if (TuxGuitar.instance().getPlayer().isRunning()) {
            TuxGuitar.instance().getTransport().gotoNext();
        } else {
            Caret caret = this.getEditor().getTablature().getCaret();
            if (!caret.moveRight()) {
                int n = this.getSongManager().getSong().countMeasureHeaders() + 1;
                UndoableAddMeasure undoableAddMeasure = UndoableAddMeasure.startUndo(n);
                this.getSongManager().addNewMeasure(n);
                this.fireUpdate(n);
                caret.moveRight();
                TuxGuitar.instance().getFileHistory().setUnsavedFile();
                this.addUndoableEdit(undoableAddMeasure.endUndo());
            }
        }
        return 0;
    }
}

