/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.editors.tab.TGTrackImpl;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeClef;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGTrack;

public class ChangeClefAction
extends Action {
    public static final String NAME = "action.composition.change-clef";

    public ChangeClefAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return 0;
    }

    public void showDialog(Shell shell) {
        TGMeasureImpl tGMeasureImpl = this.getEditor().getTablature().getCaret().getMeasure();
        if (tGMeasureImpl != null) {
            final Shell shell2 = DialogUtils.newDialog(shell, 67680);
            shell2.setLayout(new GridLayout());
            shell2.setText(TuxGuitar.getProperty("composition.clef"));
            Group group = new Group(shell2, 16);
            group.setLayout(new GridLayout(2, false));
            group.setLayoutData(new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("composition.clef"));
            Label label = new Label(group, 0);
            label.setText(TuxGuitar.getProperty("composition.clef") + ":");
            final Combo combo = new Combo(group, 12);
            combo.add(TuxGuitar.getProperty("composition.clef.treble"));
            combo.add(TuxGuitar.getProperty("composition.clef.bass"));
            combo.add(TuxGuitar.getProperty("composition.clef.tenor"));
            combo.add(TuxGuitar.getProperty("composition.clef.alto"));
            combo.select(tGMeasureImpl.getClef() - 1);
            combo.setLayoutData(this.getComboData());
            Group group2 = new Group(shell2, 16);
            group2.setLayout(new GridLayout());
            group2.setLayoutData(new GridData(4, 4, true, true));
            group2.setText(TuxGuitar.getProperty("options"));
            final Button button = new Button(group2, 32);
            button.setText(TuxGuitar.getProperty("composition.clef.to-the-end"));
            button.setSelection(true);
            Composite composite = new Composite(shell2, 0);
            composite.setLayout(new GridLayout(2, false));
            composite.setLayoutData(new GridData(131072, 4, true, true));
            Button button2 = new Button(composite, 8);
            button2.setText(TuxGuitar.getProperty("ok"));
            button2.setLayoutData(this.getButtonData());
            button2.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    boolean bl = button.getSelection();
                    ChangeClefAction.this.setClef(combo.getSelectionIndex() + 1, bl);
                    shell2.dispose();
                }
            });
            Button button3 = new Button(composite, 8);
            button3.setText(TuxGuitar.getProperty("cancel"));
            button3.setLayoutData(this.getButtonData());
            button3.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.setDefaultButton(button2);
            DialogUtils.openDialog(shell2, 11);
        }
    }

    private GridData getComboData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 150;
        return gridData;
    }

    protected GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected void setClef(int n, boolean bl) {
        UndoableChangeClef undoableChangeClef = UndoableChangeClef.startUndo();
        TGMeasureImpl tGMeasureImpl = this.getEditor().getTablature().getCaret().getMeasure();
        TGTrackImpl tGTrackImpl = this.getEditor().getTablature().getCaret().getTrack();
        this.getSongManager().getTrackManager().changeClef((TGTrack)tGTrackImpl, tGMeasureImpl.getStart(), n, bl);
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.updateTablature();
        this.addUndoableEdit(undoableChangeClef.endUndo(n, bl));
    }
}

