/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.composition;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeTempo;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGTempo;

public class ChangeTempoAction
extends Action {
    public static final String NAME = "action.composition.change-tempo";
    private static final int MIN_TEMPO = 30;
    private static final int MAX_TEMPO = 320;
    protected static final int[] DEFAULT_PERCENTS = new int[]{25, 50, 75, 100, 125, 150, 175, 200};

    public ChangeTempoAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        this.showDialog(this.getEditor().getTablature().getShell());
        return 0;
    }

    public void showDialog(Shell shell) {
        TGMeasureImpl tGMeasureImpl = this.getEditor().getTablature().getCaret().getMeasure();
        if (tGMeasureImpl != null) {
            final Shell shell2 = DialogUtils.newDialog(shell, 67680);
            shell2.setLayout(new GridLayout());
            shell2.setText(TuxGuitar.getProperty("composition.tempo"));
            Group group = new Group(shell2, 16);
            group.setLayout(new GridLayout(2, false));
            group.setLayoutData(new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("composition.tempo"));
            TGTempo tGTempo = tGMeasureImpl.getTempo();
            Label label = new Label(group, 0);
            label.setText(TuxGuitar.getProperty("composition.tempo"));
            final Spinner spinner = new Spinner(group, 2048);
            spinner.setLayoutData(this.getSpinnerData());
            spinner.setMinimum(30);
            spinner.setMaximum(320);
            spinner.setSelection(tGTempo.getValue());
            Group group2 = new Group(shell2, 16);
            group2.setLayout(new GridLayout());
            group2.setLayoutData(new GridData(4, 4, true, true));
            group2.setText(TuxGuitar.getProperty("options"));
            final Button button = new Button(group2, 16);
            button.setText(TuxGuitar.getProperty("composition.tempo.start-to-end"));
            final Button button2 = new Button(group2, 16);
            button2.setText(TuxGuitar.getProperty("composition.tempo.position-to-end"));
            Button button3 = new Button(group2, 16);
            button3.setText(TuxGuitar.getProperty("composition.tempo.position-to-next"));
            button.setSelection(true);
            Composite composite = new Composite(shell2, 0);
            composite.setLayout(new GridLayout(2, false));
            composite.setLayoutData(new GridData(0x1000008, 4, true, true));
            Button button4 = new Button(composite, 8);
            button4.setText(TuxGuitar.getProperty("ok"));
            button4.setLayoutData(this.getButtonData());
            button4.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    if (ChangeTempoAction.this.update(spinner, button, button2)) {
                        shell2.dispose();
                        return;
                    }
                    MessageDialog.errorMessage(shell2.getShell(), TuxGuitar.getProperty("composition.tempo.invalid"));
                }
            });
            Button button5 = new Button(composite, 8);
            button5.setText(TuxGuitar.getProperty("cancel"));
            button5.setLayoutData(this.getButtonData());
            button5.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.setDefaultButton(button4);
            DialogUtils.openDialog(shell2, 11);
        }
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private GridData getSpinnerData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 150;
        return gridData;
    }

    protected boolean update(Spinner spinner, Button button, Button button2) {
        int n = spinner.getSelection();
        if (n >= 30) {
            TGTempo tGTempo = this.getSongManager().getFactory().newTempo();
            tGTempo.setValue(n);
            long l = button.getSelection() ? 960L : this.getEditor().getTablature().getCaret().getMeasure().getStart();
            boolean bl = button.getSelection() || button2.getSelection();
            UndoableChangeTempo undoableChangeTempo = UndoableChangeTempo.startUndo();
            this.getSongManager().changeTempos(l, tGTempo, bl);
            TuxGuitar.instance().getFileHistory().setUnsavedFile();
            this.updateTablature();
            this.addUndoableEdit(undoableChangeTempo.endUndo());
            return true;
        }
        return false;
    }

    public TGSongManager getSongManager() {
        return super.getSongManager();
    }
}

