/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.FileChooser;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.io.base.TGOutputStreamBase;
import org.herac.tuxguitar.io.base.TGSongExporter;
import org.herac.tuxguitar.io.base.TGSongImporter;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGSong;

public class FileActionUtils {
    public static String getFileName() {
        if (TuxGuitar.instance().getFileHistory().isNewFile() || !TuxGuitar.instance().getFileHistory().isLocalFile()) {
            return FileActionUtils.chooseFileName();
        }
        String string = TuxGuitar.instance().getFileHistory().getCurrentFilePath();
        String string2 = TuxGuitar.instance().getFileHistory().getCurrentFileName("Untitled.tg");
        String string3 = string + File.separator + string2;
        return FileActionUtils.isSuportedFormat(string3) ? string3 : FileActionUtils.chooseFileName();
    }

    public static String chooseFileName() {
        String string = FileChooser.instance().save(TuxGuitar.instance().getShell(), TGFileFormatManager.instance().getOutputFormats());
        if (string != null) {
            if (!FileActionUtils.isSuportedFormat(string)) {
                string = string + ".tg";
            }
            if (!FileActionUtils.canWrite(string)) {
                return null;
            }
        }
        return string;
    }

    public static String chooseFileName(TGFileFormat tGFileFormat) {
        String string = FileChooser.instance().save(TuxGuitar.instance().getShell(), tGFileFormat);
        if (string != null && !FileActionUtils.canWrite(string)) {
            return null;
        }
        return string;
    }

    public static boolean isSuportedFormat(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(".")) > 0) {
            Iterator iterator = TGFileFormatManager.instance().getOutputStreams();
            while (iterator.hasNext()) {
                TGOutputStreamBase tGOutputStreamBase = (TGOutputStreamBase)iterator.next();
                if (!tGOutputStreamBase.isSupportedExtension(string.substring(n))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canWrite(String string) {
        boolean bl = true;
        File file = new File(string);
        if (file.exists()) {
            ConfirmDialog confirmDialog = new ConfirmDialog(TuxGuitar.getProperty("file.overwrite-question"));
            confirmDialog.setDefaultStatus(ConfirmDialog.STATUS_NO);
            if (confirmDialog.confirm(ConfirmDialog.BUTTON_YES | ConfirmDialog.BUTTON_NO, ConfirmDialog.BUTTON_NO) == ConfirmDialog.STATUS_NO) {
                bl = false;
            }
        }
        return bl;
    }

    public static void open(String string) {
        try {
            TGSong tGSong = TGFileFormatManager.instance().getLoader().load(TuxGuitar.instance().getSongManager().getFactory(), new FileInputStream(string));
            TuxGuitar.instance().fireNewSong(tGSong, new File(string).toURI().toURL());
        }
        catch (Throwable throwable) {
            TuxGuitar.instance().newSong();
            MessageDialog.errorMessage(new TGFileFormatException(TuxGuitar.getProperty("file.open.error", new String[]{string}), throwable));
        }
    }

    public static void save(String string) {
        try {
            TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
            TGFileFormatManager.instance().getWriter().write(tGSongManager.getFactory(), tGSongManager.getSong(), string);
            TuxGuitar.instance().fireSaveSong(new File(string).toURI().toURL());
        }
        catch (Throwable throwable) {
            MessageDialog.errorMessage(new TGFileFormatException(TuxGuitar.getProperty("file.save.error", new String[]{string}), throwable));
        }
    }

    public static void open(URL uRL) {
        try {
            InputStream inputStream = FileActionUtils.isLocalFile(uRL) ? uRL.openStream() : FileActionUtils.getInputStream(uRL.openStream());
            TGSong tGSong = TGFileFormatManager.instance().getLoader().load(TuxGuitar.instance().getSongManager().getFactory(), inputStream);
            TuxGuitar.instance().fireNewSong(tGSong, uRL);
        }
        catch (Throwable throwable) {
            TuxGuitar.instance().newSong();
            MessageDialog.errorMessage(new TGFileFormatException(TuxGuitar.getProperty("file.open.error", new String[]{uRL.toString()}), throwable));
        }
    }

    public static void exportSong(TGSongExporter tGSongExporter, String string) {
        try {
            TGSongManager tGSongManager = TuxGuitar.instance().getSongManager();
            tGSongExporter.exportSong(new FileOutputStream(new File(string)), tGSongManager.getSong());
        }
        catch (Throwable throwable) {
            MessageDialog.errorMessage(new TGFileFormatException(TuxGuitar.getProperty("file.export.error", new String[]{string}), throwable));
        }
    }

    public static void importSong(TGSongImporter tGSongImporter, String string) {
        try {
            TGSong tGSong = tGSongImporter.importSong(TuxGuitar.instance().getSongManager().getFactory(), new FileInputStream(new File(string)));
            TuxGuitar.instance().fireNewSong(tGSong, null);
        }
        catch (Throwable throwable) {
            TuxGuitar.instance().newSong();
            MessageDialog.errorMessage(new TGFileFormatException(TuxGuitar.getProperty("file.import.error", new String[]{string}), throwable));
        }
    }

    private static boolean isLocalFile(URL uRL) {
        try {
            if (uRL.getProtocol().equals(new File(uRL.getFile()).toURI().toURL().getProtocol())) {
                return true;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    private static InputStream getInputStream(InputStream inputStream) throws Throwable {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        inputStream.close();
        byteArrayOutputStream.close();
        byteArrayOutputStream.flush();
        return new ByteArrayInputStream(byArray);
    }
}

