/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.net.URL;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.actions.ActionLock;
import org.herac.tuxguitar.gui.actions.file.FileActionUtils;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.util.ConfirmDialog;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.gui.util.MessageDialog;

public class OpenURLAction
extends Action {
    public static final String NAME = "action.file.open-url";

    public OpenURLAction() {
        super(NAME, 13);
    }

    protected int execute(final TypedEvent typedEvent) {
        TuxGuitar.instance().getPlayer().reset();
        if (TuxGuitar.instance().getFileHistory().isUnsavedFile()) {
            ConfirmDialog confirmDialog = new ConfirmDialog(TuxGuitar.getProperty("file.save-changes-question"));
            confirmDialog.setDefaultStatus(ConfirmDialog.STATUS_CANCEL);
            int n = confirmDialog.confirm(ConfirmDialog.BUTTON_YES | ConfirmDialog.BUTTON_NO | ConfirmDialog.BUTTON_CANCEL, ConfirmDialog.BUTTON_YES);
            if (n == ConfirmDialog.STATUS_CANCEL) {
                return 2;
            }
            if (n == ConfirmDialog.STATUS_YES) {
                final String string = FileActionUtils.getFileName();
                if (string == null) {
                    return 2;
                }
                TuxGuitar.instance().loadCursor(1);
                new Thread(new Runnable(){

                    public void run() {
                        if (!TuxGuitar.isDisposed()) {
                            FileActionUtils.save(string);
                            new SyncThread(new Runnable(){

                                public void run() {
                                    if (!TuxGuitar.isDisposed()) {
                                        TuxGuitar.instance().loadCursor(0);
                                        OpenURLAction.this.openURL((this).typedEvent.widget.getData());
                                    }
                                }
                            }).start();
                        }
                    }
                }).start();
                return 0;
            }
        }
        this.openURL(typedEvent.widget.getData());
        return 0;
    }

    protected void openURL(Object object) {
        final URL uRL = this.getURL(object);
        if (uRL == null) {
            ActionLock.unlock();
            return;
        }
        TuxGuitar.instance().loadCursor(1);
        new Thread(new Runnable(){

            public void run() {
                if (!TuxGuitar.isDisposed()) {
                    FileActionUtils.open(uRL);
                    TuxGuitar.instance().loadCursor(0);
                    ActionLock.unlock();
                }
            }
        }).start();
    }

    protected URL getURL(Object object) {
        if (object instanceof URL) {
            return (URL)object;
        }
        return new URLDialog().openDialog();
    }

    protected class URLDialog {
        protected URL url;

        protected URLDialog() {
        }

        protected URL openDialog() {
            this.url = null;
            final Shell shell = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 67680);
            shell.setLayout(new GridLayout());
            shell.setText(TuxGuitar.getProperty("file.open-url"));
            Group group = new Group(shell, 16);
            group.setLayout(new GridLayout());
            group.setLayoutData(new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("file.open-url"));
            Composite composite = new Composite(group, 0);
            composite.setLayout(new GridLayout(2, false));
            composite.setLayoutData(this.getMainData());
            Label label = new Label(composite, 16384);
            label.setText(TuxGuitar.getProperty("url") + ":");
            label.setLayoutData(new GridData(4, 0x1000000, false, true));
            final Text text = new Text(composite, 2052);
            text.setLayoutData(new GridData(4, 4, true, true));
            Composite composite2 = new Composite(shell, 0);
            composite2.setLayout(new GridLayout(2, false));
            composite2.setLayoutData(new GridData(131072, 4, true, true));
            Button button = new Button(composite2, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData(this.getButtonData());
            button.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    try {
                        URLDialog.this.url = new URL(text.getText());
                        shell.dispose();
                    }
                    catch (Throwable throwable) {
                        MessageDialog.errorMessage(throwable);
                    }
                }
            });
            Button button2 = new Button(composite2, 8);
            button2.setText(TuxGuitar.getProperty("cancel"));
            button2.setLayoutData(this.getButtonData());
            button2.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell.dispose();
                }
            });
            shell.setDefaultButton(button);
            DialogUtils.openDialog(shell, 11);
            return this.url;
        }

        private GridData getMainData() {
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumWidth = 450;
            return gridData;
        }

        private GridData getButtonData() {
            GridData gridData = new GridData(4, 4, true, true);
            gridData.minimumWidth = 80;
            gridData.minimumHeight = 25;
            return gridData;
        }
    }
}

