/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGFactoryImpl;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintStyles;
import org.herac.tuxguitar.gui.printer.PrintStylesDialog;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.util.TGSynchronizer;

public class PrintAction
extends Action {
    public static final String NAME = "action.file.print";

    public PrintAction() {
        super(NAME, 15);
    }

    protected int execute(TypedEvent typedEvent) {
        try {
            PrintDialog printDialog;
            PrinterData printerData;
            PrintStyles printStyles = PrintStylesDialog.open(TuxGuitar.instance().getShell());
            if (printStyles != null && (printerData = (printDialog = new PrintDialog(TuxGuitar.instance().getShell(), 0)).open()) != null) {
                TuxGuitar.instance().loadCursor(1);
                this.print(printerData, printStyles);
            }
        }
        catch (Throwable throwable) {
            MessageDialog.errorMessage(throwable);
        }
        return 0;
    }

    public void print(final PrinterData printerData, final PrintStyles printStyles) {
        try {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        final TGSongManager tGSongManager = new TGSongManager();
                        tGSongManager.setFactory(new TGFactoryImpl());
                        tGSongManager.setSong(PrintAction.this.getSongManager().getSong().clone(tGSongManager.getFactory()));
                        new SyncThread(new Runnable(){

                            public void run() {
                                try {
                                    Shell shell = new Shell();
                                    Printer printer = new Printer(printerData);
                                    Tablature tablature = new Tablature(shell);
                                    tablature.setSongManager(tGSongManager);
                                    Rectangle rectangle = PrintAction.this.getPrinterArea(printer, 0.5);
                                    PrinterViewLayout printerViewLayout = new PrinterViewLayout(tablature, printStyles, PrintAction.this.getPrinterScale(printer));
                                    PrintAction.this.print(printer, printerData, printerViewLayout, rectangle);
                                }
                                catch (Throwable throwable) {
                                    MessageDialog.errorMessage(throwable);
                                }
                            }
                        }).start();
                    }
                    catch (Throwable throwable) {
                        MessageDialog.errorMessage(throwable);
                    }
                }
            }).start();
        }
        catch (Throwable throwable) {
            MessageDialog.errorMessage(throwable);
        }
    }

    protected void print(final Printer printer, final PrinterData printerData, final PrinterViewLayout printerViewLayout, final Rectangle rectangle) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    printerViewLayout.getTablature().updateTablature();
                    printerViewLayout.makeDocument(new PrintDocumentImpl(printerViewLayout, printer, printerData, rectangle));
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage(throwable);
                }
            }
        }).start();
    }

    protected Rectangle getPrinterArea(Printer printer, double d) {
        Rectangle rectangle = printer.getClientArea();
        Rectangle rectangle2 = printer.computeTrim(0, 0, 0, 0);
        Point point = printer.getDPI();
        int n = (int)(d * (double)point.x) - rectangle2.x;
        int n2 = (int)(d * (double)point.y) - rectangle2.y;
        int n3 = rectangle.width + rectangle2.width - (int)(d * (double)point.x) - rectangle2.x;
        int n4 = rectangle.height + rectangle2.height - (int)(d * (double)point.y) - rectangle2.y;
        return new Rectangle(n, n2, n3, n4);
    }

    protected float getPrinterScale(Printer printer) {
        Point point = printer.getDPI();
        if (point != null) {
            return (float)point.x / 100.0f;
        }
        return 1.0f;
    }

    private class PrintDocumentImpl
    implements PrintDocument {
        private Printer printer;
        private PrinterData printerData;
        private PrinterViewLayout layout;
        private TGPainter painter;
        private Rectangle bounds;
        private boolean started;

        public PrintDocumentImpl(PrinterViewLayout printerViewLayout, Printer printer, PrinterData printerData, Rectangle rectangle) {
            this.layout = printerViewLayout;
            this.printer = printer;
            this.printerData = printerData;
            this.bounds = rectangle;
            this.painter = new TGPainter();
        }

        public TGPainter getPainter() {
            return this.painter;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public void pageStart() {
            if (this.started) {
                this.printer.startPage();
                this.painter.init(new GC((Drawable)this.printer));
            }
        }

        public void pageFinish() {
            if (this.started) {
                this.painter.dispose();
                this.printer.endPage();
            }
        }

        public void start() {
            this.started = this.printer.startJob(this.getJobName());
        }

        public void finish() {
            if (this.started) {
                this.printer.endJob();
                this.started = false;
                try {
                    TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                        public void run() {
                            PrintDocumentImpl.this.dispose();
                        }
                    });
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                TuxGuitar.instance().loadCursor(0);
            }
        }

        public boolean isPaintable(int n) {
            if (this.printerData.scope == 1) {
                if (this.printerData.startPage > 0 && this.printerData.startPage > n) {
                    return false;
                }
                if (this.printerData.endPage > 0 && this.printerData.endPage < n) {
                    return false;
                }
            }
            return true;
        }

        public String getJobName() {
            String string = "TuxGuitar";
            String string2 = this.layout.getSongManager().getSong().getName();
            return string2 != null && string2.length() > 0 ? string + "-" + string2 : string;
        }

        public void dispose() {
            if (!this.printer.isDisposed()) {
                this.printer.dispose();
            }
            if (!this.layout.getTablature().isDisposed() && !this.layout.getTablature().getShell().isDisposed()) {
                this.layout.getTablature().getShell().dispose();
            }
            if (!this.layout.getTablature().isDisposed()) {
                this.layout.getTablature().dispose();
            }
        }
    }
}

