/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.file;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.editors.tab.TGFactoryImpl;
import org.herac.tuxguitar.gui.editors.tab.Tablature;
import org.herac.tuxguitar.gui.editors.tab.layout.PrinterViewLayout;
import org.herac.tuxguitar.gui.helper.SyncThread;
import org.herac.tuxguitar.gui.printer.PrintDocument;
import org.herac.tuxguitar.gui.printer.PrintPreview;
import org.herac.tuxguitar.gui.printer.PrintStyles;
import org.herac.tuxguitar.gui.printer.PrintStylesDialog;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.util.TGSynchronizer;

public class PrintPreviewAction
extends Action {
    public static final String NAME = "action.file.print-preview";

    public PrintPreviewAction() {
        super(NAME, 15);
    }

    protected int execute(TypedEvent typedEvent) {
        try {
            PrintStyles printStyles = PrintStylesDialog.open(TuxGuitar.instance().getShell());
            if (printStyles != null) {
                TuxGuitar.instance().loadCursor(1);
                this.printPreview(printStyles);
            }
        }
        catch (Throwable throwable) {
            MessageDialog.errorMessage(throwable);
        }
        return 0;
    }

    public void printPreview(final PrintStyles printStyles) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    TGSongManager tGSongManager = new TGSongManager();
                    tGSongManager.setFactory(new TGFactoryImpl());
                    tGSongManager.setSong(PrintPreviewAction.this.getSongManager().getSong().clone(tGSongManager.getFactory()));
                    PrintPreviewAction.this.printPreview(tGSongManager, printStyles);
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage(throwable);
                }
            }
        }).start();
    }

    public void printPreview(final TGSongManager tGSongManager, final PrintStyles printStyles) {
        new SyncThread(new Runnable(){

            public void run() {
                try {
                    Tablature tablature = new Tablature(TuxGuitar.instance().getShell());
                    tablature.setSongManager(tGSongManager);
                    PrinterViewLayout printerViewLayout = new PrinterViewLayout(tablature, printStyles, 1.0f);
                    PrintPreviewAction.this.printPreview(printerViewLayout);
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage(throwable);
                }
            }
        }).start();
    }

    public void printPreview(final PrinterViewLayout printerViewLayout) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    printerViewLayout.getTablature().updateTablature();
                    printerViewLayout.makeDocument(new PrintDocumentImpl(printerViewLayout, new Rectangle(0, 0, 850, 1050)));
                }
                catch (Throwable throwable) {
                    MessageDialog.errorMessage(throwable);
                }
            }
        }).start();
    }

    private class PrintDocumentImpl
    implements PrintDocument {
        private PrinterViewLayout layout;
        private TGPainter painter;
        private Rectangle bounds;
        private List pages;

        public PrintDocumentImpl(PrinterViewLayout printerViewLayout, Rectangle rectangle) {
            this.layout = printerViewLayout;
            this.bounds = rectangle;
            this.painter = new TGPainter();
            this.pages = new ArrayList();
        }

        public TGPainter getPainter() {
            return this.painter;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public void pageStart() {
            Image image = new Image((Device)this.layout.getTablature().getDisplay(), this.bounds.width - this.bounds.x, this.bounds.height - this.bounds.y);
            this.painter.init(image);
            this.pages.add(image);
        }

        public void pageFinish() {
            this.painter.dispose();
        }

        public void start() {
        }

        public void finish() {
            final Tablature tablature = this.layout.getTablature();
            final Rectangle rectangle = this.bounds;
            final List list = this.pages;
            try {
                TGSynchronizer.instance().addRunnable(new TGSynchronizer.TGRunnable(){

                    public void run() {
                        tablature.dispose();
                        PrintPreview printPreview = new PrintPreview(list, rectangle);
                        printPreview.showPreview(PrintPreviewAction.this.getEditor().getTablature().getShell());
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            Image image = (Image)iterator.next();
                            image.dispose();
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public boolean isPaintable(int n) {
            return true;
        }
    }
}

