/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.insert;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGText;

public class InsertTextAction
extends Action {
    public static final String NAME = "action.insert.text";

    public InsertTextAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        TGBeatImpl tGBeatImpl;
        this.showInsertDialog(tGBeatImpl, (tGBeatImpl = this.getEditor().getTablature().getCaret().getSelectedBeat()).getText() == null ? new String() : tGBeatImpl.getText().getValue());
        return 0;
    }

    public void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }

    public void showInsertDialog(final TGBeat tGBeat, String string) {
        final Shell shell = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 67680);
        shell.setLayout(new GridLayout());
        shell.setText(TuxGuitar.getProperty("text.editor"));
        Group group = new Group(shell, 16);
        group.setLayout(new GridLayout());
        group.setLayoutData(new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("text.insert"));
        Composite composite = new Composite(group, 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(this.getMainData());
        Label label = new Label(composite, 16384);
        label.setText(TuxGuitar.getProperty("text.text") + ":");
        label.setLayoutData(new GridData(4, 0x1000000, false, true));
        final Text text = new Text(composite, 2052);
        text.setLayoutData(new GridData(4, 4, true, true));
        text.setText(string);
        Composite composite2 = new Composite(shell, 0);
        composite2.setLayout(new GridLayout(3, false));
        composite2.setLayoutData(new GridData(131072, 4, true, true));
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData(this.getButtonData());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InsertTextAction.this.insertText(tGBeat, text.getText());
                shell.dispose();
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("clean"));
        button2.setLayoutData(this.getButtonData());
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InsertTextAction.this.removeText(tGBeat);
                shell.dispose();
            }
        });
        Button button3 = new Button(composite2, 8);
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.setLayoutData(this.getButtonData());
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell.dispose();
            }
        });
        shell.setDefaultButton(button);
        DialogUtils.openDialog(shell, 11);
    }

    private GridData getMainData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 300;
        return gridData;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected void insertText(TGBeat tGBeat, String string) {
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        TGText tGText = this.getSongManager().getFactory().newText();
        tGText.setValue(string);
        this.getSongManager().getMeasureManager().addText(tGBeat, tGText);
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.updateTablature();
        this.addUndoableEdit(undoableMeasureGeneric.endUndo());
    }

    protected void removeText(TGBeat tGBeat) {
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        this.getSongManager().getMeasureManager().removeText(tGBeat);
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        this.updateTablature();
        this.addUndoableEdit(undoableMeasureGeneric.endUndo());
    }
}

