/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.insert;

import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.undo.undoables.UndoableJoined;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeAlternativeRepeat;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeCloseRepeat;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;

public class RepeatAlternativeAction
extends Action {
    public static final String NAME = "action.insert.repeat-alternative";

    public RepeatAlternativeAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        TGMeasureImpl tGMeasureImpl = this.getEditor().getTablature().getCaret().getMeasure();
        this.showCloseRepeatDialog(this.getEditor().getTablature().getShell(), tGMeasureImpl);
        return 0;
    }

    public void showCloseRepeatDialog(Shell shell, final TGMeasure tGMeasure) {
        if (tGMeasure != null) {
            int n = this.getExistentEndings(tGMeasure);
            int n2 = tGMeasure.getHeader().getRepeatAlternative() > 0 ? tGMeasure.getHeader().getRepeatAlternative() : this.getDefaultEndings(n);
            final Shell shell2 = DialogUtils.newDialog(shell, 67680);
            shell2.setLayout(new GridLayout());
            shell2.setText(TuxGuitar.getProperty("repeat.alternative.editor"));
            Group group = new Group(shell2, 16);
            group.setLayout(new GridLayout(4, true));
            group.setLayoutData(this.getMainData());
            group.setText(TuxGuitar.getProperty("repeat.alternative"));
            final Button[] buttonArray = new Button[8];
            for (int i = 0; i < buttonArray.length; ++i) {
                boolean bl = (n & 1 << i) == 0;
                buttonArray[i] = new Button(group, 32);
                buttonArray[i].setText(Integer.toString(i + 1));
                buttonArray[i].setLayoutData(new GridData(4, 4, true, true));
                buttonArray[i].setEnabled(bl);
                buttonArray[i].setSelection(bl && (n2 & 1 << i) != 0);
            }
            Composite composite = new Composite(shell2, 0);
            composite.setLayout(new GridLayout(3, false));
            composite.setLayoutData(new GridData(0x1000008, 4, true, true));
            Button button = new Button(composite, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData(this.getButtonData());
            button.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n = 0;
                    for (int i = 0; i < buttonArray.length; ++i) {
                        n |= buttonArray[i].getSelection() ? 1 << i : 0;
                    }
                    RepeatAlternativeAction.this.update(tGMeasure, n);
                    shell2.dispose();
                }
            });
            Button button2 = new Button(composite, 8);
            button2.setText(TuxGuitar.getProperty("clean"));
            button2.setLayoutData(this.getButtonData());
            button2.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RepeatAlternativeAction.this.update(tGMeasure, 0);
                    shell2.dispose();
                }
            });
            Button button3 = new Button(composite, 8);
            button3.setText(TuxGuitar.getProperty("cancel"));
            button3.setLayoutData(this.getButtonData());
            button3.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.setDefaultButton(button);
            DialogUtils.openDialog(shell2, 11);
        }
    }

    private GridData getMainData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 350;
        return gridData;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected int getExistentEndings(TGMeasure tGMeasure) {
        TGMeasureHeader tGMeasureHeader;
        int n = 0;
        Iterator iterator = this.getSongManager().getSong().getMeasureHeaders();
        while (iterator.hasNext() && (tGMeasureHeader = (TGMeasureHeader)iterator.next()).getNumber() != tGMeasure.getNumber()) {
            if (tGMeasureHeader.isRepeatOpen()) {
                n = 0;
            }
            n |= tGMeasureHeader.getRepeatAlternative();
        }
        return n;
    }

    protected int getDefaultEndings(int n) {
        for (int i = 0; i < 8; ++i) {
            if ((n & 1 << i) != 0) continue;
            return 1 << i;
        }
        return -1;
    }

    protected void update(TGMeasure tGMeasure, int n) {
        if (n != tGMeasure.getHeader().getRepeatAlternative()) {
            TGMeasureHeader tGMeasureHeader;
            boolean bl = tGMeasure.getHeader().getRepeatAlternative() == 0 && (n & 1) == 0;
            UndoableJoined undoableJoined = new UndoableJoined();
            TuxGuitar.instance().getFileHistory().setUnsavedFile();
            UndoableChangeAlternativeRepeat undoableChangeAlternativeRepeat = UndoableChangeAlternativeRepeat.startUndo();
            this.getSongManager().changeAlternativeRepeat(tGMeasure.getStart(), n);
            this.fireUpdate(tGMeasure.getNumber());
            undoableJoined.addUndoableEdit(undoableChangeAlternativeRepeat.endUndo(n));
            if (bl && (tGMeasureHeader = this.getSongManager().getMeasureHeader(tGMeasure.getNumber() - 1)) != null && tGMeasureHeader.getRepeatClose() == 0) {
                UndoableChangeCloseRepeat undoableChangeCloseRepeat = UndoableChangeCloseRepeat.startUndo(tGMeasureHeader.getStart(), tGMeasureHeader.getRepeatClose());
                this.getSongManager().changeCloseRepeat(tGMeasureHeader.getStart(), 1);
                this.fireUpdate(tGMeasureHeader.getNumber());
                undoableJoined.addUndoableEdit(undoableChangeCloseRepeat.endUndo(1));
            }
            this.addUndoableEdit(undoableJoined.endUndo());
        }
    }
}

