/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.insert;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.TGMeasureImpl;
import org.herac.tuxguitar.gui.undo.undoables.custom.UndoableChangeCloseRepeat;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class RepeatCloseAction
extends Action {
    public static final String NAME = "action.insert.close-repeat";

    public RepeatCloseAction() {
        super(NAME, 31);
    }

    protected int execute(TypedEvent typedEvent) {
        TGMeasureImpl tGMeasureImpl = this.getEditor().getTablature().getCaret().getMeasure();
        this.showCloseRepeatDialog(this.getEditor().getTablature().getShell(), tGMeasureImpl);
        return 0;
    }

    public void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }

    public void showCloseRepeatDialog(Shell shell, final TGMeasureImpl tGMeasureImpl) {
        if (tGMeasureImpl != null) {
            final Shell shell2 = DialogUtils.newDialog(shell, 67680);
            shell2.setLayout(new GridLayout());
            shell2.setText(TuxGuitar.getProperty("repeat.close"));
            int n = tGMeasureImpl.getRepeatClose();
            if (n < 1) {
                n = 1;
            }
            Group group = new Group(shell2, 16);
            group.setLayout(new GridLayout(2, false));
            group.setLayoutData(new GridData(4, 4, true, true));
            group.setText(TuxGuitar.getProperty("repeat.close"));
            Label label = new Label(group, 0);
            label.setText(TuxGuitar.getProperty("repeat.number-of-repetitions"));
            final Spinner spinner = new Spinner(group, 2048);
            spinner.setMinimum(0);
            spinner.setMaximum(100);
            spinner.setSelection(n);
            spinner.setLayoutData(this.getSpinnerData());
            Composite composite = new Composite(shell2, 0);
            composite.setLayout(new GridLayout(3, false));
            composite.setLayoutData(new GridData(0x1000008, 4, true, true));
            Button button = new Button(composite, 8);
            button.setText(TuxGuitar.getProperty("ok"));
            button.setLayoutData(this.getButtonData());
            button.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RepeatCloseAction.this.closeRepeat(tGMeasureImpl, spinner.getSelection());
                    shell2.dispose();
                }
            });
            Button button2 = new Button(composite, 8);
            button2.setText(TuxGuitar.getProperty("clean"));
            button2.setLayoutData(this.getButtonData());
            button2.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RepeatCloseAction.this.closeRepeat(tGMeasureImpl, 0);
                    shell2.dispose();
                }
            });
            Button button3 = new Button(composite, 8);
            button3.setText(TuxGuitar.getProperty("cancel"));
            button3.setLayoutData(this.getButtonData());
            button3.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    shell2.dispose();
                }
            });
            shell2.setDefaultButton(button);
            DialogUtils.openDialog(shell2, 11);
        }
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    protected GridData getSpinnerData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 100;
        return gridData;
    }

    protected void closeRepeat(TGMeasureImpl tGMeasureImpl, int n) {
        if (n >= 0) {
            UndoableChangeCloseRepeat undoableChangeCloseRepeat = UndoableChangeCloseRepeat.startUndo();
            TuxGuitar.instance().getFileHistory().setUnsavedFile();
            this.getSongManager().changeCloseRepeat(tGMeasureImpl.getStart(), n);
            this.updateTablature();
            this.addUndoableEdit(undoableChangeCloseRepeat.endUndo(n));
        }
    }
}

