/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.note;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.TGBeatImpl;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;

public class RemoveNoteAction
extends Action {
    public static final String NAME = "action.note.general.remove";

    public RemoveNoteAction() {
        super(NAME, 23);
    }

    protected int execute(TypedEvent typedEvent) {
        UndoableMeasureGeneric undoableMeasureGeneric = UndoableMeasureGeneric.startUndo();
        TuxGuitar.instance().getFileHistory().setUnsavedFile();
        Caret caret = this.getEditor().getTablature().getCaret();
        TGBeatImpl tGBeatImpl = caret.getSelectedBeat();
        if (tGBeatImpl.isRestBeat()) {
            if (tGBeatImpl.isTextBeat()) {
                this.getSongManager().getMeasureManager().removeText(tGBeatImpl);
            } else {
                this.getSongManager().getMeasureManager().removeBeat(tGBeatImpl, true);
            }
        } else {
            int n = caret.getSelectedString().getNumber();
            this.getSongManager().getMeasureManager().removeNote(caret.getMeasure(), tGBeatImpl.getStart(), n);
        }
        this.addUndoableEdit(undoableMeasureGeneric.endUndo());
        this.updateTablature();
        return 0;
    }

    public void updateTablature() {
        this.fireUpdate(this.getEditor().getTablature().getCaret().getMeasure().getNumber());
    }
}

