/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.actions.transport;

import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Display;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.util.MessageDialog;
import org.herac.tuxguitar.gui.util.MidiTickUtil;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.util.TGSynchronizer;

public class TransportPlayAction
extends Action {
    public static final String NAME = "action.transport.play";

    public TransportPlayAction() {
        super(NAME, 15);
    }

    protected int execute(TypedEvent typedEvent) {
        MidiPlayer midiPlayer = TuxGuitar.instance().getPlayer();
        if (!midiPlayer.isRunning()) {
            try {
                midiPlayer.getMode().reset();
                midiPlayer.play();
                this.playThread();
            }
            catch (MidiPlayerException midiPlayerException) {
                MessageDialog.errorMessage(midiPlayerException);
            }
        } else {
            midiPlayer.pause();
            this.updateTickPosition();
        }
        return 0;
    }

    protected void playThread() {
        final Display display = TuxGuitar.instance().getDisplay();
        final TGSynchronizer.TGRunnable tGRunnable = new TGSynchronizer.TGRunnable(){

            public void run() {
                if (TuxGuitar.instance().getPlayer().isRunning()) {
                    TuxGuitar.instance().redrawPayingMode();
                }
            }
        };
        final TGSynchronizer.TGRunnable tGRunnable2 = new TGSynchronizer.TGRunnable(){

            public void run() {
                TransportPlayAction.this.updateTickPosition();
                TuxGuitar.instance().updateCache(true);
            }
        };
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (TuxGuitar.instance().getPlayer().isRunning()) {
                        TGSynchronizer.TGRunnable tGRunnable3 = tGRunnable;
                        synchronized (tGRunnable3) {
                            TGSynchronizer.instance().addRunnable(tGRunnable);
                            tGRunnable.wait(25L);
                        }
                    }
                    if (!display.isDisposed()) {
                        TGSynchronizer.instance().addRunnable(tGRunnable2);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }).start();
    }

    protected void updateTickPosition() {
        MidiPlayer midiPlayer = TuxGuitar.instance().getPlayer();
        TGMeasureHeader tGMeasureHeader = this.getSongManager().getMeasureHeaderAt(MidiTickUtil.getStart(midiPlayer.getTickPosition()));
        if (tGMeasureHeader != null) {
            midiPlayer.setTickPosition(MidiTickUtil.getTick(tGMeasureHeader.getStart()));
        }
        this.getEditor().getTablature().getCaret().goToTickPosition();
    }
}

