/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors;

import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.fretboard.FretBoard;
import org.herac.tuxguitar.gui.system.icons.IconLoader;
import org.herac.tuxguitar.gui.system.language.LanguageLoader;

public class FretBoardEditor
implements IconLoader,
LanguageLoader {
    private FretBoard fretBoard;
    private boolean visible;

    public FretBoardEditor() {
        TuxGuitar.instance().getIconManager().addLoader(this);
        TuxGuitar.instance().getLanguageManager().addLoader(this);
    }

    private FretBoard getFretBoard() {
        return this.fretBoard;
    }

    public void hideFretBoard() {
        this.visible = false;
        this.getFretBoard().setVisible(this.visible);
        TuxGuitar.instance().updateShellFooter(0, 0, 0);
    }

    public void showFretBoard() {
        this.visible = true;
        this.getFretBoard().setVisible(this.visible);
        TuxGuitar.instance().updateShellFooter(this.getFretBoard().getHeight(), 730, 520);
    }

    public void showFretBoard(Composite composite) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.fretBoard = new FretBoard(composite);
        this.fretBoard.setLayoutData(formData);
    }

    public void setScaleChanges() {
        if (this.getFretBoard() != null) {
            this.getFretBoard().setChanges(true);
        }
    }

    public void dispose() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().dispose();
        }
    }

    public void redraw() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed() && !TuxGuitar.instance().isLocked()) {
            this.getFretBoard().redraw();
        }
    }

    public void redrawPlayingMode() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed() && !TuxGuitar.instance().isLocked()) {
            this.getFretBoard().redrawPlayingMode();
        }
    }

    public boolean isVisible() {
        return this.getFretBoard() != null && !this.getFretBoard().isDisposed() && this.visible;
    }

    public void loadProperties() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().loadProperties();
        }
    }

    public void loadIcons() {
        if (this.getFretBoard() != null && !this.getFretBoard().isDisposed()) {
            this.getFretBoard().loadIcons();
        }
    }
}

