/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.chord;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.chord.ChordSettings;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class ChordSettingsDialog {
    private boolean updated;
    private Shell dialog;
    private Button emptyStringChords = null;
    private Spinner chordsToDisplay = null;
    private Combo typeCombo = null;
    private Spinner minFret = null;
    private Spinner maxFret = null;

    public boolean open(Shell shell) {
        this.updated = false;
        this.dialog = DialogUtils.newDialog(shell, 67680);
        this.dialog.setLayout(new GridLayout());
        this.dialog.setText(TuxGuitar.getProperty("settings"));
        this.init();
        DialogUtils.openDialog(this.dialog, 11);
        return this.updated;
    }

    protected void init() {
        Group group = new Group(this.dialog, 16);
        group.setLayout(new GridLayout());
        group.setLayoutData(new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("chord.settings.tip"));
        Composite composite = new Composite(group, 0);
        composite.setLayout(new GridLayout(2, false));
        composite.setLayoutData(new GridData(4, 4, true, true));
        this.initTypeCombo(composite);
        this.initChordsToDisplay(composite);
        this.initEmptyStringChords(composite);
        this.initFretSearch(composite);
        Composite composite2 = new Composite(this.dialog, 0);
        composite2.setLayout(new GridLayout(2, false));
        composite2.setLayoutData(new GridData(0x1000008, 4, true, true));
        Button button = new Button(composite2, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData(this.getButtonData());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordSettingsDialog.this.dispose(true);
            }
        });
        Button button2 = new Button(composite2, 8);
        button2.setText(TuxGuitar.getProperty("cancel"));
        button2.setLayoutData(this.getButtonData());
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordSettingsDialog.this.dispose(false);
            }
        });
        this.dialog.setDefaultButton(button);
    }

    private GridData getGridData(int n, int n2) {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = n;
        gridData.minimumHeight = n2;
        return gridData;
    }

    private GridData getGridData() {
        return this.getGridData(125, 0);
    }

    private GridData getButtonData() {
        return this.getGridData(80, 25);
    }

    private Spinner makeSpinner(Composite composite, String string, int n, int n2, int n3) {
        this.newLabel(composite, string);
        Spinner spinner = new Spinner(composite, 2048);
        spinner.setMinimum(n2);
        spinner.setMaximum(n3);
        spinner.setSelection(n);
        spinner.setLayoutData(this.getGridData());
        return spinner;
    }

    private Label newLabel(Composite composite, String string) {
        Label label = new Label(composite, 256);
        label.setText(string);
        return label;
    }

    private void initTypeCombo(Composite composite) {
        this.newLabel(composite, TuxGuitar.getProperty("chord.settings.type"));
        this.typeCombo = new Combo(composite, 12);
        this.typeCombo.setLayoutData(this.getGridData());
        this.typeCombo.add(TuxGuitar.getProperty("chord.settings.type.most-common"));
        this.typeCombo.add(TuxGuitar.getProperty("chord.settings.type.inversions"));
        this.typeCombo.add(TuxGuitar.getProperty("chord.settings.type.close-voiced"));
        this.typeCombo.add(TuxGuitar.getProperty("chord.settings.type.open-voiced"));
        this.typeCombo.select(ChordSettings.instance().getChordTypeIndex());
    }

    private void initChordsToDisplay(Composite composite) {
        this.chordsToDisplay = this.makeSpinner(composite, TuxGuitar.getProperty("chord.settings.chords-to-display"), ChordSettings.instance().getChordsToDisplay(), 1, 100);
    }

    private void initEmptyStringChords(Composite composite) {
        this.emptyStringChords = new Button(composite, 32);
        this.emptyStringChords.setSelection(ChordSettings.instance().isEmptyStringChords());
        this.emptyStringChords.setText(TuxGuitar.getProperty("chord.settings.open-chords"));
        this.emptyStringChords.setSize(100, 20);
        this.emptyStringChords.setLayoutData(new GridData(4, 4, true, true, 2, 1));
    }

    private void initFretSearch(Composite composite) {
        Group group = new Group(composite, 16);
        group.setLayout(new GridLayout(4, false));
        group.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        group.setText(TuxGuitar.getProperty("chord.settings.search-frets"));
        this.minFret = this.makeSpinner(group, TuxGuitar.getProperty("chord.settings.minimum-fret"), ChordSettings.instance().getFindChordsMin(), 0, 15);
        this.maxFret = this.makeSpinner(group, TuxGuitar.getProperty("chord.settings.maximum-fret"), ChordSettings.instance().getFindChordsMax(), 2, 25);
        this.minFret.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordSettingsDialog.this.checkMinimumFretValue();
            }
        });
        this.maxFret.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ChordSettingsDialog.this.checkMaximunFretValue();
            }
        });
    }

    protected void checkMinimumFretValue() {
        int n;
        int n2 = this.maxFret.getSelection();
        if (n2 < (n = this.minFret.getSelection())) {
            this.maxFret.setSelection(n);
        }
    }

    protected void checkMaximunFretValue() {
        int n;
        int n2 = this.maxFret.getSelection();
        if (n2 < (n = this.minFret.getSelection())) {
            this.maxFret.setSelection(n);
        }
    }

    private void update() {
        ChordSettings.instance().setChordTypeIndex(this.typeCombo.getSelectionIndex());
        ChordSettings.instance().setEmptyStringChords(this.emptyStringChords.getSelection());
        ChordSettings.instance().setChordsToDisplay(this.chordsToDisplay.getSelection());
        ChordSettings.instance().setFindChordsMax(this.maxFret.getSelection());
        ChordSettings.instance().setFindChordsMin(this.minFret.getSelection());
    }

    protected void dispose(boolean bl) {
        this.updated = bl;
        if (this.updated) {
            this.update();
        }
        this.dialog.dispose();
    }
}

