/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.effects;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.util.DialogUtils;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;

public class HarmonicEditor
extends SelectionAdapter {
    public static final int WIDTH = 400;
    public static final int HEIGHT = 0;
    protected Combo harmonicType;
    protected Combo harmonicDataCombo;
    protected TGEffectHarmonic result;
    protected Button[] typeButtons;

    public TGEffectHarmonic show(final TGNote tGNote) {
        final Shell shell = DialogUtils.newDialog(TuxGuitar.instance().getShell(), 67680);
        shell.setLayout(new GridLayout());
        shell.setText(TuxGuitar.getProperty("effects.harmonic-editor"));
        Group group = new Group(shell, 16);
        group.setLayout(new GridLayout());
        group.setLayoutData(this.resizeData(new GridData(4, 4, true, true), 400));
        group.setText(TuxGuitar.getProperty("effects.harmonic.type-of-harmonic"));
        this.typeButtons = new Button[5];
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HarmonicEditor.this.update(tGNote, HarmonicEditor.this.getSelectedType());
            }
        };
        String string = "[N.H] " + TuxGuitar.getProperty("effects.harmonic.natural");
        this.initButton(group, selectionAdapter, 0, 1, string);
        string = "[A.H] " + TuxGuitar.getProperty("effects.harmonic.artificial");
        this.initButton(group, selectionAdapter, 1, 2, string);
        string = "[T.H] " + TuxGuitar.getProperty("effects.harmonic.tapped");
        this.initButton(group, selectionAdapter, 2, 3, string);
        string = "[P.H] " + TuxGuitar.getProperty("effects.harmonic.pinch");
        this.initButton(group, selectionAdapter, 3, 4, string);
        string = "[S.H] " + TuxGuitar.getProperty("effects.harmonic.semi");
        this.initButton(group, selectionAdapter, 4, 5, string);
        this.harmonicDataCombo = new Combo(group, 12);
        this.harmonicDataCombo.setLayoutData(new GridData(4, 4, true, true));
        Composite composite = new Composite(shell, 0);
        composite.setLayout(new GridLayout(3, false));
        composite.setLayoutData(new GridData(0x1000008, 1024, true, true));
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty("ok"));
        button.setLayoutData(this.getButtonData());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HarmonicEditor.this.result = HarmonicEditor.this.getHarmonic();
                shell.dispose();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty("clean"));
        button2.setLayoutData(this.getButtonData());
        button2.setEnabled(tGNote.getEffect().isHarmonic());
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HarmonicEditor.this.result = null;
                shell.dispose();
            }
        });
        Button button3 = new Button(composite, 8);
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.setLayoutData(this.getButtonData());
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                HarmonicEditor.this.result = tGNote.getEffect().getHarmonic();
                shell.dispose();
            }
        });
        this.initDefaults(tGNote);
        shell.setDefaultButton(button);
        DialogUtils.openDialog(shell, 11);
        return this.result;
    }

    private GridData resizeData(GridData gridData, int n) {
        gridData.minimumWidth = n;
        return gridData;
    }

    private GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }

    private void initButton(Composite composite, SelectionListener selectionListener, int n, int n2, String string) {
        this.typeButtons[n] = new Button(composite, 16);
        this.typeButtons[n].setText(string);
        this.typeButtons[n].setLayoutData(new GridData(4, 4, true, true));
        this.typeButtons[n].setData(new Integer(n2));
        this.typeButtons[n].addSelectionListener(selectionListener);
    }

    protected void initDefaults(TGNote tGNote) {
        int n;
        int n2;
        int n3 = 1;
        if (tGNote.getEffect().isHarmonic()) {
            n3 = tGNote.getEffect().getHarmonic().getType();
        } else {
            n2 = 0;
            for (n = 0; n < TGEffectHarmonic.NATURAL_FREQUENCIES.length; ++n) {
                if (tGNote.getValue() % 12 != TGEffectHarmonic.NATURAL_FREQUENCIES[n][0] % 12) continue;
                n2 = 1;
                break;
            }
            if (n2 == 0) {
                this.typeButtons[0].setEnabled(false);
                n3 = 2;
            }
        }
        for (n2 = 0; n2 < this.typeButtons.length; ++n2) {
            n = (Integer)this.typeButtons[n2].getData();
            this.typeButtons[n2].setSelection(n == n3);
        }
        this.update(tGNote, n3);
    }

    protected int getSelectedType() {
        for (int i = 0; i < this.typeButtons.length; ++i) {
            if (!this.typeButtons[i].getSelection()) continue;
            return (Integer)this.typeButtons[i].getData();
        }
        return 0;
    }

    protected void update(TGNote tGNote, int n) {
        TGEffectHarmonic tGEffectHarmonic = tGNote.getEffect().getHarmonic();
        this.harmonicDataCombo.removeAll();
        this.harmonicDataCombo.setEnabled(n != 1);
        if (n != 1) {
            String string = this.getTypeLabel(n);
            for (int i = 0; i < TGEffectHarmonic.NATURAL_FREQUENCIES.length; ++i) {
                this.harmonicDataCombo.add(string + "(" + Integer.toString(TGEffectHarmonic.NATURAL_FREQUENCIES[i][0]) + ")");
            }
            this.harmonicDataCombo.select(tGEffectHarmonic != null && tGEffectHarmonic.getType() == n ? tGEffectHarmonic.getData() : 0);
        }
    }

    private String getTypeLabel(int n) {
        if (n == 1) {
            return "N.H";
        }
        if (n == 2) {
            return "A.H";
        }
        if (n == 3) {
            return "T.H";
        }
        if (n == 4) {
            return "P.H";
        }
        if (n == 5) {
            return "S.H";
        }
        return new String();
    }

    public TGEffectHarmonic getHarmonic() {
        int n = this.getSelectedType();
        if (n > 0) {
            TGEffectHarmonic tGEffectHarmonic = TuxGuitar.instance().getSongManager().getFactory().newEffectHarmonic();
            tGEffectHarmonic.setType(n);
            tGEffectHarmonic.setData(this.harmonicDataCombo.getSelectionIndex());
            return tGEffectHarmonic;
        }
        return null;
    }
}

