/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.gui.editors.piano;

import java.util.Properties;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TGPainter;
import org.herac.tuxguitar.gui.system.config.TGConfigManager;
import org.herac.tuxguitar.gui.util.DialogUtils;

public class PianoConfig {
    private static final int MINIMUN_CONTROL_WIDTH = 180;
    private static final int MINIMUN_BUTTON_WIDTH = 80;
    private static final int MINIMUN_BUTTON_HEIGHT = 25;
    private Color colorNatural;
    private Color colorNotNatural;
    private Color colorNote;
    private Color colorScale;

    public Color getColorNatural() {
        return this.colorNatural;
    }

    public Color getColorNotNatural() {
        return this.colorNotNatural;
    }

    public Color getColorNote() {
        return this.colorNote;
    }

    public Color getColorScale() {
        return this.colorScale;
    }

    public void load() {
        Display display = TuxGuitar.instance().getDisplay();
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        this.colorNatural = new Color(display, tGConfigManager.getRGBConfigValue("piano.color.natural-key"));
        this.colorNotNatural = new Color(display, tGConfigManager.getRGBConfigValue("piano.color.not-natural-key"));
        this.colorNote = new Color(display, tGConfigManager.getRGBConfigValue("piano.color.note"));
        this.colorScale = new Color(display, tGConfigManager.getRGBConfigValue("piano.color.scale"));
    }

    public void defaults() {
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        Properties properties = tGConfigManager.getDefaults();
        tGConfigManager.setProperty("piano.color.natural-key", properties.getProperty("piano.color.natural-key"));
        tGConfigManager.setProperty("piano.color.not-natural-key", properties.getProperty("piano.color.not-natural-key"));
        tGConfigManager.setProperty("piano.color.note", properties.getProperty("piano.color.note"));
        tGConfigManager.setProperty("piano.color.scale", properties.getProperty("piano.color.scale"));
    }

    public void save(RGB rGB, RGB rGB2, RGB rGB3, RGB rGB4) {
        TGConfigManager tGConfigManager = TuxGuitar.instance().getConfig();
        tGConfigManager.setProperty("piano.color.natural-key", rGB);
        tGConfigManager.setProperty("piano.color.not-natural-key", rGB2);
        tGConfigManager.setProperty("piano.color.note", rGB3);
        tGConfigManager.setProperty("piano.color.scale", rGB4);
    }

    public void dispose() {
        this.colorNatural.dispose();
        this.colorNotNatural.dispose();
        this.colorNote.dispose();
        this.colorScale.dispose();
    }

    public void configure(Shell shell) {
        final Shell shell2 = DialogUtils.newDialog(shell, 67680);
        shell2.setLayout(new GridLayout());
        shell2.setText(TuxGuitar.getProperty("piano.settings"));
        Group group = new Group(shell2, 16);
        group.setLayout(new GridLayout(2, false));
        group.setLayoutData(new GridData(4, 4, true, true));
        group.setText(TuxGuitar.getProperty("piano.settings"));
        final RGB rGB = this.getColorChooser(group, TuxGuitar.getProperty("piano.natural-key-color"), this.colorNatural.getRGB());
        final RGB rGB2 = this.getColorChooser(group, TuxGuitar.getProperty("piano.not-natural-key-color"), this.colorNotNatural.getRGB());
        final RGB rGB3 = this.getColorChooser(group, TuxGuitar.getProperty("piano.note-color"), this.colorNote.getRGB());
        final RGB rGB4 = this.getColorChooser(group, TuxGuitar.getProperty("piano.scale-note-color"), this.colorScale.getRGB());
        Composite composite = new Composite(shell2, 0);
        composite.setLayout(new GridLayout(3, false));
        composite.setLayoutData(new GridData(0x1000008, 4, true, true));
        Button button = new Button(composite, 8);
        button.setText(TuxGuitar.getProperty("defaults"));
        button.setLayoutData(this.getButtonData());
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
                PianoConfig.this.defaults();
                PianoConfig.this.applyChanges();
            }
        });
        Button button2 = new Button(composite, 8);
        button2.setText(TuxGuitar.getProperty("ok"));
        button2.setLayoutData(this.getButtonData());
        button2.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
                PianoConfig.this.save(rGB, rGB2, rGB3, rGB4);
                PianoConfig.this.applyChanges();
            }
        });
        Button button3 = new Button(composite, 8);
        button3.setText(TuxGuitar.getProperty("cancel"));
        button3.setLayoutData(this.getButtonData());
        button3.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell2.dispose();
            }
        });
        shell2.setDefaultButton(button2);
        DialogUtils.openDialog(shell2, 11);
    }

    protected void applyChanges() {
        this.dispose();
        this.load();
    }

    private RGB getColorChooser(final Composite composite, String string, RGB rGB) {
        final RGB rGB2 = new RGB(rGB.red, rGB.green, rGB.blue);
        Label label = new Label(composite, 0);
        label.setLayoutData(new GridData(131072, 0x1000000, true, true));
        label.setText(string);
        final Button button = new Button(composite, 8);
        button.setLayoutData(this.getAlignmentData(180, 4));
        button.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                Color color = new Color(composite.getDisplay(), rGB2);
                TGPainter tGPainter = new TGPainter(paintEvent.gc);
                tGPainter.setBackground(color);
                tGPainter.initPath(2);
                tGPainter.addRectangle(5.0f, 5.0f, button.getSize().x - 10, button.getSize().y - 10);
                tGPainter.closePath();
                color.dispose();
            }
        });
        button.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(composite.getShell());
                colorDialog.setRGB(rGB2);
                colorDialog.setText(TuxGuitar.getProperty("choose-color"));
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    rGB2.red = rGB.red;
                    rGB2.green = rGB.green;
                    rGB2.blue = rGB.blue;
                    button.redraw();
                }
            }
        });
        return rGB2;
    }

    private GridData getAlignmentData(int n, int n2) {
        GridData gridData = new GridData();
        gridData.minimumWidth = n;
        gridData.horizontalAlignment = n2;
        gridData.verticalAlignment = -1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        return gridData;
    }

    protected GridData getButtonData() {
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 80;
        gridData.minimumHeight = 25;
        return gridData;
    }
}

